/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.module.radioactivedatinggame;

import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsResources;
import edu.colorado.phet.nuclearphysics.module.radioactivedatinggame.AnimatedModelElement;
import edu.colorado.phet.nuclearphysics.module.radioactivedatinggame.ModelAnimationListener;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.Point;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatableItem
implements AnimatedModelElement {
    public static final DatableItem DATABLE_AIR = new DatableItem("Datable Air", (List<String>)null, (Point2D)new Point2D.Double(0.0, 0.0), 0.0, 0.0, 0.0, true);
    private double width;
    private double height;
    private final double age;
    private final String name;
    private double rotationAngle;
    private Point2D center;
    private ArrayList<BufferedImage> images = new ArrayList();
    private ArrayList<ModelAnimationListener> animationListeners = new ArrayList();
    private int primaryImageIndex;
    private int secondaryImageIndex;
    private double fadeFactor;
    private final boolean isOrganic;

    public DatableItem(String string, List<String> list, Point2D point2D, double d, double d2, double d3, boolean bl) {
        this.name = string;
        this.center = new Point2D.Double(point2D.getX(), point2D.getY());
        this.width = d;
        this.age = d3;
        this.rotationAngle = d2;
        this.isOrganic = bl;
        if (list != null && list.size() != 0) {
            BufferedImage bufferedImage = NuclearPhysicsResources.getImage(list.get(0));
            this.images.add(bufferedImage);
            this.height = (double)this.images.get(this.primaryImageIndex).getHeight() / (double)this.images.get(this.primaryImageIndex).getWidth() * d;
            for (int i = 1; i < list.size(); ++i) {
                BufferedImage bufferedImage2 = NuclearPhysicsResources.getImage(list.get(i));
                if (bufferedImage2.getWidth() != bufferedImage.getWidth() || bufferedImage2.getHeight() != bufferedImage.getHeight()) {
                    bufferedImage2 = BufferedImageUtils.rescaleFractional(bufferedImage2, (double)bufferedImage.getWidth() / (double)bufferedImage2.getWidth(), (double)bufferedImage.getHeight() / (double)bufferedImage2.getHeight());
                }
                this.images.add(bufferedImage2);
            }
        } else {
            this.height = d;
        }
        this.secondaryImageIndex = 0;
        this.primaryImageIndex = 0;
        if (this.images.size() >= 2) {
            this.secondaryImageIndex = 1;
        }
    }

    public DatableItem(String string, String string2, Point2D point2D, double d, double d2, double d3, boolean bl) {
        this(string, Arrays.asList(string2), point2D, d, d2, d3, bl);
    }

    @Override
    public Point2D getPosition() {
        return new Point2D.Double(this.center.getX(), this.center.getY());
    }

    @Override
    public void setPosition(Point2D point2D) {
        this.setPosition(point2D.getX(), point2D.getY());
    }

    public void setPosition(double d, double d2) {
        if (this.center.getX() != d || this.center.getY() != d2) {
            this.center = new Point2D.Double(d, d2);
            this.notifyPositionChanged();
        }
    }

    public void addAnimationListener(ModelAnimationListener modelAnimationListener) {
        if (!this.animationListeners.contains(modelAnimationListener)) {
            this.animationListeners.add(modelAnimationListener);
        }
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public boolean isOrganic() {
        return this.isOrganic;
    }

    public double getRadiometricAge() {
        return this.age;
    }

    public BufferedImage getImage() {
        if (this.images.size() > 1) {
            return this.fadeImages(this.images.get(this.primaryImageIndex), this.images.get(this.secondaryImageIndex), this.fadeFactor);
        }
        return this.images.get(this.primaryImageIndex);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return super.toString() + ": " + this.name;
    }

    public boolean contains(Point2D point2D) {
        ModelViewTransform2D modelViewTransform2D = new ModelViewTransform2D(this.getBoundingRect(), new Rectangle2D.Double(0.0, 0.0, this.getImage().getWidth(), this.getImage().getHeight()));
        Point point = modelViewTransform2D.modelToView(point2D);
        Point2D.Double double_ = new Point2D.Double(this.getImage().getWidth() / 2, this.getImage().getHeight() / 2);
        MutableVector2D mutableVector2D = new MutableVector2D(double_, point);
        Vector2D vector2D = mutableVector2D.getRotatedInstance(-this.rotationAngle);
        Point2D.Double double_2 = vector2D.getDestination(double_);
        Point point2 = new Point((int)((Point2D)double_2).getX(), (int)((Point2D)double_2).getY());
        if (point2.x >= 0 && point2.y >= 0 && point2.x < this.getImage().getWidth() && point2.y < this.getImage().getHeight()) {
            return this.isPixelOpaque(point2);
        }
        return false;
    }

    private boolean isPixelOpaque(Point point) {
        if (this.getImage().getType() == 2) {
            int[] nArray = this.getImage().getData().getPixel(point.x, point.y, (int[])null);
            return nArray[3] > 128;
        }
        return true;
    }

    public Rectangle2D getBoundingRect() {
        return new Rectangle2D.Double(this.center.getX() - this.width / 2.0, this.center.getY() - this.height / 2.0, this.width, this.height);
    }

    @Override
    public double getRotationalAngle() {
        return this.rotationAngle;
    }

    @Override
    public Dimension2D getSize() {
        return new PDimension(this.width, this.height);
    }

    public boolean removeAnimationListener(ModelAnimationListener modelAnimationListener) {
        return this.animationListeners.remove(modelAnimationListener);
    }

    @Override
    public void setFadeFactor(double d) {
        if (this.fadeFactor != d) {
            this.fadeFactor = d;
            this.notifyImageChanged();
        }
    }

    @Override
    public void setRotationalAngle(double d) {
        if (this.rotationAngle != d) {
            this.rotationAngle = d;
            this.notifyRotationalAngleChanged();
        }
    }

    @Override
    public int getNumberImages() {
        return this.images.size();
    }

    @Override
    public int getPrimaryImageIndex() {
        return this.primaryImageIndex;
    }

    @Override
    public int getSecondaryImageIndex() {
        return this.secondaryImageIndex;
    }

    @Override
    public void setPrimaryImageIndex(int n) {
        assert (n < this.images.size());
        if (this.primaryImageIndex != n) {
            this.primaryImageIndex = n;
            this.notifyImageChanged();
        }
    }

    @Override
    public void setSecondaryImageIndex(int n) {
        assert (n < this.images.size());
        if (this.secondaryImageIndex != n) {
            this.secondaryImageIndex = n;
            this.notifyImageChanged();
        }
    }

    @Override
    public double getFadeFactor() {
        return this.fadeFactor;
    }

    @Override
    public void setSize(Dimension2D dimension2D) {
        if (this.width != dimension2D.getWidth() || this.height != dimension2D.getHeight()) {
            this.width = dimension2D.getWidth();
            this.height = dimension2D.getHeight();
            this.notifySizeChanged();
        }
    }

    private void notifySizeChanged() {
        for (ModelAnimationListener modelAnimationListener : this.animationListeners) {
            modelAnimationListener.sizeChanged();
        }
    }

    private void notifyPositionChanged() {
        for (ModelAnimationListener modelAnimationListener : this.animationListeners) {
            modelAnimationListener.positionChanged();
        }
    }

    private void notifyRotationalAngleChanged() {
        for (ModelAnimationListener modelAnimationListener : this.animationListeners) {
            modelAnimationListener.rotationalAngleChanged();
        }
    }

    private void notifyImageChanged() {
        for (ModelAnimationListener modelAnimationListener : this.animationListeners) {
            modelAnimationListener.imageChanged();
        }
    }

    private BufferedImage fadeImages(BufferedImage bufferedImage, BufferedImage bufferedImage2, double d) {
        if (d < 0.0 || d > 1.0) {
            System.err.println("Error: invalid fade factor = " + d);
            assert (false);
            d = 0.0;
        }
        PNode pNode = new PNode();
        PImage pImage = new PImage(bufferedImage);
        PImage pImage2 = new PImage(bufferedImage2);
        pImage.setTransparency((float)(-Math.pow(d, 4.0) + 1.0));
        pImage2.setTransparency((float)(-Math.pow(d - 1.0, 4.0) + 1.0));
        pNode.addChild(pImage);
        pNode.addChild(pImage2);
        return BufferedImageUtils.toBufferedImage(pNode.toImage());
    }
}

