/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.module.nuclearreactor;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.nodes.HTMLImageButtonNode;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsConstants;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsStrings;
import edu.colorado.phet.nuclearphysics.dialog.ReactorPictureDialog;
import edu.colorado.phet.nuclearphysics.module.nuclearreactor.NuclearReactorModel;
import edu.colorado.phet.nuclearphysics.view.NuclearReactorNode;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import javax.swing.Timer;

public class NuclearReactorCanvas
extends PhetPCanvas {
    private final double CANVAS_WIDTH = 700.0;
    private final double CANVAS_HEIGHT = 609.0;
    private final double WIDTH_TRANSLATION_FACTOR = 2.0;
    private final double HEIGHT_TRANSLATION_FACTOR = 2.5;
    private static final Timer BUTTON_DELAY_TIMER = new Timer(1000, null);
    private NuclearReactorModel _nuclearReactorModel;
    private NuclearReactorNode _nuclearReactorNode;
    private HTMLImageButtonNode _resetNucleiButtonNode;
    private HTMLImageButtonNode _showReactorImageButtonNode;
    private Frame _parentFrame;

    public NuclearReactorCanvas(NuclearReactorModel nuclearReactorModel, Frame frame) {
        this._nuclearReactorModel = nuclearReactorModel;
        this._parentFrame = frame;
        this.setWorldTransformStrategy(new PhetPCanvas.RenderingSizeStrategy(this, new PDimension(700.0, 609.0)){

            protected AffineTransform getPreprocessedTransform() {
                return AffineTransform.getTranslateInstance((double)NuclearReactorCanvas.this.getWidth() / 2.0, (double)NuclearReactorCanvas.this.getHeight() / 2.5);
            }
        });
        this.setBackground(NuclearPhysicsConstants.CANVAS_BACKGROUND);
        this._nuclearReactorModel.addListener(new NuclearReactorModel.Adapter(){

            public void resetOccurred() {
                NuclearReactorCanvas.this._resetNucleiButtonNode.setVisible(false);
            }

            public void reactionStarted() {
                BUTTON_DELAY_TIMER.restart();
            }
        });
        BUTTON_DELAY_TIMER.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NuclearReactorCanvas.this._resetNucleiButtonNode.setVisible(true);
                BUTTON_DELAY_TIMER.stop();
            }
        });
        this._nuclearReactorNode = new NuclearReactorNode(this._nuclearReactorModel, this);
        this.addWorldChild(this._nuclearReactorNode);
        this._resetNucleiButtonNode = new HTMLImageButtonNode(NuclearPhysicsStrings.RESET_NUCLEI, new PhetFont(1, 16), NuclearPhysicsConstants.CANVAS_RESET_BUTTON_COLOR);
        this.addWorldChild(this._resetNucleiButtonNode);
        this._resetNucleiButtonNode.setOffset(this._nuclearReactorNode.getFullBounds().getMinX(), this._nuclearReactorNode.getFullBounds().getMinY() - this._resetNucleiButtonNode.getFullBounds().height);
        this._resetNucleiButtonNode.setVisible(false);
        this._resetNucleiButtonNode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NuclearReactorCanvas.this._nuclearReactorModel.reset();
            }
        });
        this._showReactorImageButtonNode = new HTMLImageButtonNode(NuclearPhysicsStrings.SHOW_REACTOR_IMAGE, new PhetFont(1, 16), NuclearPhysicsConstants.CANVAS_RESET_BUTTON_COLOR);
        this.addWorldChild(this._showReactorImageButtonNode);
        this._showReactorImageButtonNode.setOffset(-350.0, 304.5);
        this._showReactorImageButtonNode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReactorPictureDialog reactorPictureDialog = new ReactorPictureDialog(NuclearReactorCanvas.this._parentFrame);
                if (reactorPictureDialog != null) {
                    SwingUtils.centerDialogInParent(reactorPictureDialog);
                }
                reactorPictureDialog.setVisible(true);
            }
        });
    }
}

