/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.module.chainreaction;

import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.LinearValueControl;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsConstants;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsStrings;
import edu.colorado.phet.nuclearphysics.module.chainreaction.ChainReactionModel;
import edu.colorado.phet.nuclearphysics.view.LabeledNucleusImageNode;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ChainReactionControlsSubPanel
extends VerticalLayoutPanel {
    private LinearValueControl _u235AmountControl;
    private LinearValueControl _u238AmountControl;
    private JCheckBox _enableContainmentVesselCheckBox;
    private JTextField _percentFissioned;
    private ChainReactionModel _model;
    private boolean _ignoreStateChanges;

    public ChainReactionControlsSubPanel(ChainReactionModel chainReactionModel) {
        this._model = chainReactionModel;
        this._model.addListener(new ChainReactionModel.Adapter(){

            public void resetOccurred() {
                ChainReactionControlsSubPanel.this._u235AmountControl.setValue(ChainReactionControlsSubPanel.this._model.getNumU235Nuclei());
                ChainReactionControlsSubPanel.this._u238AmountControl.setValue(ChainReactionControlsSubPanel.this._model.getNumU238Nuclei());
                ChainReactionControlsSubPanel.this._enableContainmentVesselCheckBox.setSelected(ChainReactionControlsSubPanel.this._model.getContainmentVessel().getIsEnabled());
            }

            public void percentageU235FissionedChanged(double d) {
                DecimalFormat decimalFormat = new DecimalFormat("##0.00");
                ChainReactionControlsSubPanel.this._percentFissioned.setText(new String(decimalFormat.format(d) + "%"));
            }

            public void reactiveNucleiNumberChanged() {
                ChainReactionControlsSubPanel.this._u235AmountControl.setValue(ChainReactionControlsSubPanel.this._model.getNumU235Nuclei());
                ChainReactionControlsSubPanel.this._u238AmountControl.setValue(ChainReactionControlsSubPanel.this._model.getNumU238Nuclei());
            }
        });
        BevelBorder bevelBorder = (BevelBorder)BorderFactory.createRaisedBevelBorder();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(bevelBorder, NuclearPhysicsStrings.MULTI_NUCLEUS_CONTROLS_BORDER, 1, 2, new PhetFont(1, 14), Color.GRAY);
        this.setBorder(titledBorder);
        this._enableContainmentVesselCheckBox = new JCheckBox(NuclearPhysicsStrings.CONTAINMENT_VESSEL_CHECK_BOX);
        this._enableContainmentVesselCheckBox.setSelected(this._model.getContainmentVessel().getIsEnabled());
        this._enableContainmentVesselCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChainReactionControlsSubPanel.this._model.getContainmentVessel().setIsEnabled(ChainReactionControlsSubPanel.this._enableContainmentVesselCheckBox.isSelected());
                ChainReactionControlsSubPanel.this._u235AmountControl.setValue(ChainReactionControlsSubPanel.this._model.getNumU235Nuclei());
                ChainReactionControlsSubPanel.this._u238AmountControl.setValue(ChainReactionControlsSubPanel.this._model.getNumU238Nuclei());
            }
        });
        this._enableContainmentVesselCheckBox.setBorder(BorderFactory.createEtchedBorder());
        this.add(this._enableContainmentVesselCheckBox);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(Box.createVerticalStrut(20));
        this.add(jPanel);
        this._u235AmountControl = new LinearValueControl(0.0, 100.0, NuclearPhysicsStrings.U235_LABEL, "###", NuclearPhysicsStrings.NUCLEI_LABEL);
        this._u235AmountControl.setUpDownArrowDelta(1.0);
        this._u235AmountControl.setTextFieldEditable(true);
        this._u235AmountControl.setFont(new PhetFont(0, 14));
        this._u235AmountControl.setTickPattern("0");
        this._u235AmountControl.setMajorTickSpacing(25.0);
        this._u235AmountControl.setMinorTickSpacing(12.5);
        this._u235AmountControl.setBorder(BorderFactory.createEtchedBorder());
        this._u235AmountControl.setValue(this._model.getNumU235Nuclei());
        this._u235AmountControl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (!ChainReactionControlsSubPanel.this._ignoreStateChanges) {
                    ChainReactionControlsSubPanel.this._model.setNumU235Nuclei((int)Math.round(ChainReactionControlsSubPanel.this._u235AmountControl.getValue()));
                }
            }
        });
        this._u235AmountControl.getSlider().addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                ChainReactionControlsSubPanel.this._model.removeDecayedU235Nuclei();
            }
        });
        LabeledNucleusImageNode labeledNucleusImageNode = new LabeledNucleusImageNode("uranium-nucleus-small.png", NuclearPhysicsStrings.URANIUM_235_ISOTOPE_NUMBER, NuclearPhysicsStrings.URANIUM_235_CHEMICAL_SYMBOL, NuclearPhysicsConstants.URANIUM_235_LABEL_COLOR);
        ImageIcon imageIcon = new ImageIcon(labeledNucleusImageNode.toImage(25, 25, null));
        this._u235AmountControl.setValueLabelIcon(imageIcon);
        this._u235AmountControl.getSlider().addMouseListener(new MouseListener(){

            public void mouseReleased(MouseEvent mouseEvent) {
                ChainReactionControlsSubPanel.this._ignoreStateChanges = true;
                double d = ChainReactionControlsSubPanel.this._model.getNumU235Nuclei();
                if (d > 0.0) {
                    ChainReactionControlsSubPanel.this._u235AmountControl.setValue(d - 1.0);
                } else {
                    ChainReactionControlsSubPanel.this._u235AmountControl.setValue(d + 1.0);
                }
                ChainReactionControlsSubPanel.this._u235AmountControl.setValue(d);
                ChainReactionControlsSubPanel.this._ignoreStateChanges = false;
            }

            public void mouseClicked(MouseEvent mouseEvent) {
            }

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
        this.add(this._u235AmountControl);
        this._u238AmountControl = new LinearValueControl(0.0, 100.0, NuclearPhysicsStrings.U238_LABEL, "###", NuclearPhysicsStrings.NUCLEI_LABEL);
        this._u238AmountControl.setUpDownArrowDelta(1.0);
        this._u238AmountControl.setTextFieldEditable(true);
        this._u238AmountControl.setFont(new PhetFont(0, 14));
        this._u238AmountControl.setTickPattern("0");
        this._u238AmountControl.setMajorTickSpacing(25.0);
        this._u238AmountControl.setMinorTickSpacing(12.5);
        this._u238AmountControl.setBorder(BorderFactory.createEtchedBorder());
        this._u238AmountControl.setValue(this._model.getNumU238Nuclei());
        this._u238AmountControl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (!ChainReactionControlsSubPanel.this._ignoreStateChanges) {
                    ChainReactionControlsSubPanel.this._model.setNumU238Nuclei((int)Math.round(ChainReactionControlsSubPanel.this._u238AmountControl.getValue()));
                }
            }
        });
        LabeledNucleusImageNode labeledNucleusImageNode2 = new LabeledNucleusImageNode("uranium-nucleus-small.png", NuclearPhysicsStrings.URANIUM_238_ISOTOPE_NUMBER, NuclearPhysicsStrings.URANIUM_238_CHEMICAL_SYMBOL, NuclearPhysicsConstants.URANIUM_238_LABEL_COLOR);
        imageIcon = new ImageIcon(labeledNucleusImageNode2.toImage(25, 25, null));
        this._u238AmountControl.setValueLabelIcon(imageIcon);
        this._u238AmountControl.getSlider().addMouseListener(new MouseListener(){

            public void mouseReleased(MouseEvent mouseEvent) {
                ChainReactionControlsSubPanel.this._ignoreStateChanges = true;
                double d = ChainReactionControlsSubPanel.this._model.getNumU238Nuclei();
                if (d > 0.0) {
                    ChainReactionControlsSubPanel.this._u238AmountControl.setValue(d - 1.0);
                } else {
                    ChainReactionControlsSubPanel.this._u238AmountControl.setValue(d + 1.0);
                }
                ChainReactionControlsSubPanel.this._u238AmountControl.setValue(d);
                ChainReactionControlsSubPanel.this._ignoreStateChanges = false;
            }

            public void mouseClicked(MouseEvent mouseEvent) {
            }

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
        this.add(this._u238AmountControl);
        JPanel jPanel2 = new JPanel();
        JLabel jLabel = new JLabel(NuclearPhysicsStrings.PERCENT_FISSIONED_LABEL);
        jPanel2.add(jLabel);
        this._percentFissioned = new JTextField(5);
        this._percentFissioned.setHorizontalAlignment(4);
        this._percentFissioned.setText("0");
        this._percentFissioned.setEditable(false);
        jPanel2.add(this._percentFissioned);
        this.add(jPanel2);
    }
}

