/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.model;

import edu.colorado.phet.nuclearphysics.common.NuclearPhysicsClock;
import edu.colorado.phet.nuclearphysics.model.AbstractAlphaDecayNucleus;
import java.awt.geom.Point2D;
import java.util.Random;

public class Polonium211Nucleus
extends AbstractAlphaDecayNucleus {
    public static double HALF_LIFE = 516.0;
    private static final Random RAND = new Random();

    public Polonium211Nucleus(NuclearPhysicsClock nuclearPhysicsClock, Point2D point2D) {
        super(nuclearPhysicsClock, point2D, 84, 127);
    }

    public Polonium211Nucleus(NuclearPhysicsClock nuclearPhysicsClock) {
        this(nuclearPhysicsClock, new Point2D.Double(0.0, 0.0));
    }

    public double getHalfLife() {
        return HALF_LIFE;
    }

    public void reset() {
        super.reset();
        if (this._numNeutrons != 127 || this._numProtons != 84) {
            this._numNeutrons = 127;
            this._numProtons = 84;
            this.notifyNucleusChangeEvent(null);
        }
    }

    public void activateDecay() {
        if (this._numNeutrons == 127) {
            this._decayTime = this._clock.getSimulationTime() + this.calcPolonium211DecayTime();
        }
    }

    public boolean hasDecayed() {
        return this._numProtons < 84;
    }

    private double calcPolonium211DecayTime() {
        double d = RAND.nextDouble();
        if (d > 0.999) {
            d = 0.999;
        }
        double d2 = -(Math.log(1.0 - d) / (0.693 / HALF_LIFE));
        return d2;
    }
}

