/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.common.model;

import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.nuclearphysics.common.NuclearPhysicsClock;
import edu.colorado.phet.nuclearphysics.common.NucleusType;
import edu.colorado.phet.nuclearphysics.common.model.AtomicNucleus;
import edu.colorado.phet.nuclearphysics.common.model.NuclearDecayModelListener;
import edu.colorado.phet.nuclearphysics.common.model.NucleusTypeControl;
import edu.colorado.phet.nuclearphysics.model.AbstractAlphaDecayNucleus;
import edu.colorado.phet.nuclearphysics.model.HeavyAdjustableHalfLifeNucleus;
import edu.colorado.phet.nuclearphysics.model.Polonium211Nucleus;
import edu.colorado.phet.nuclearphysics.module.betadecay.LabelVisibilityModel;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;

public class MultiNucleusDecayModel
implements NucleusTypeControl {
    protected NuclearPhysicsClock _clock;
    protected ArrayList _listeners = new ArrayList();
    protected ArrayList<AtomicNucleus> _atomicNuclei;
    protected NucleusType _currentNucleusType;
    protected NucleusType _initialNucleusType;
    protected AtomicNucleus.Adapter _nucleusListener;
    private final Random _rand = new Random();
    protected Point2D[] _jitterOffsets;
    private int _jitterOffsetCount = 0;
    protected final int _maxNuclei;
    private boolean _jitterEnabled;
    private double _maxJitterLength;
    private LabelVisibilityModel _labelVisibilityModel;

    public MultiNucleusDecayModel(NuclearPhysicsClock nuclearPhysicsClock, int n, NucleusType nucleusType, boolean bl, LabelVisibilityModel labelVisibilityModel) {
        this._labelVisibilityModel = labelVisibilityModel;
        this._clock = nuclearPhysicsClock;
        this._initialNucleusType = nucleusType;
        this._currentNucleusType = nucleusType;
        this._maxNuclei = n;
        this._jitterEnabled = bl;
        this._atomicNuclei = new ArrayList();
        this._jitterOffsets = new Point2D[this._maxNuclei];
        this._maxJitterLength = 0.0;
        nuclearPhysicsClock.addClockListener(new ClockAdapter(){

            public void clockTicked(ClockEvent clockEvent) {
                MultiNucleusDecayModel.this.handleClockTicked(clockEvent);
            }
        });
        this.initializeNucleusListener();
    }

    public void setNucleusType(NucleusType nucleusType) {
        if (nucleusType != this._currentNucleusType) {
            this.removeAllNuclei();
            this._currentNucleusType = nucleusType;
            this.addMaxNuclei();
            this.notifyNucleusTypeChanged();
            this._maxJitterLength = 0.0;
        }
    }

    public NucleusType getNucleusType() {
        return this._currentNucleusType;
    }

    public LabelVisibilityModel getLabelVisibilityModel() {
        return this._labelVisibilityModel;
    }

    public void addListener(NuclearDecayModelListener nuclearDecayModelListener) {
        if (!this._listeners.contains(nuclearDecayModelListener)) {
            this._listeners.add(nuclearDecayModelListener);
        }
    }

    public int resetActiveAndDecayedNuclei() {
        int n = 0;
        for (int i = 0; i < this._atomicNuclei.size(); ++i) {
            AtomicNucleus atomicNucleus = this._atomicNuclei.get(i);
            if (!atomicNucleus.isDecayActive() && !atomicNucleus.hasDecayed()) continue;
            atomicNucleus.reset();
            atomicNucleus.activateDecay();
            ++n;
        }
        return n;
    }

    protected void handleClockTicked(ClockEvent clockEvent) {
        if (this._jitterEnabled) {
            for (int i = this._jitterOffsetCount; i < this._atomicNuclei.size(); i += 2) {
                AtomicNucleus atomicNucleus = this._atomicNuclei.get(i);
                if (!atomicNucleus.isDecayActive() || atomicNucleus.isPaused()) continue;
                Point2D point2D = this._jitterOffsets[i];
                Point2D point2D2 = atomicNucleus.getPositionReference();
                if (point2D.getX() == 0.0 && point2D.getY() == 0.0) {
                    this.generateJitterOffset(point2D);
                    atomicNucleus.setPosition(point2D2.getX() + point2D.getX(), point2D2.getY() + point2D.getY());
                    continue;
                }
                atomicNucleus.setPosition(point2D2.getX() - point2D.getX(), point2D2.getY() - point2D.getY());
                this._jitterOffsets[i].setLocation(0.0, 0.0);
            }
            this._jitterOffsetCount = (this._jitterOffsetCount + 1) % 2;
        }
    }

    protected void initializeNucleusListener() {
        this._nucleusListener = new AtomicNucleus.Adapter();
    }

    public void reset() {
        this.removeAllNuclei();
        this._currentNucleusType = this._initialNucleusType;
        this.addMaxNuclei();
        this.notifyNucleusTypeChanged();
    }

    protected void removeAllNuclei() {
        Iterator<AtomicNucleus> iterator = this._atomicNuclei.iterator();
        while (iterator.hasNext()) {
            AtomicNucleus atomicNucleus = iterator.next();
            atomicNucleus.removeListener(this._nucleusListener);
            atomicNucleus.removedFromModel();
            this.notifyModelElementRemoved(atomicNucleus);
            iterator.remove();
        }
    }

    protected void addMaxNuclei() {
        for (int i = 0; i < this._maxNuclei; ++i) {
            AbstractAlphaDecayNucleus abstractAlphaDecayNucleus = this._currentNucleusType == NucleusType.POLONIUM_211 ? new Polonium211Nucleus(this._clock) : new HeavyAdjustableHalfLifeNucleus(this._clock);
            this._atomicNuclei.add(abstractAlphaDecayNucleus);
            this._jitterOffsets[i] = new Point2D.Double();
            this.notifyModelElementAdded(abstractAlphaDecayNucleus);
            abstractAlphaDecayNucleus.addListener(this._nucleusListener);
        }
    }

    protected void notifyModelElementRemoved(Object object) {
        for (int i = 0; i < this._listeners.size(); ++i) {
            ((NuclearDecayModelListener)this._listeners.get(i)).modelElementRemoved(object);
        }
    }

    protected void notifyModelElementAdded(Object object) {
        for (int i = 0; i < this._listeners.size(); ++i) {
            ((NuclearDecayModelListener)this._listeners.get(i)).modelElementAdded(object);
        }
    }

    private void notifyNucleusTypeChanged() {
        for (int i = 0; i < this._listeners.size(); ++i) {
            ((NuclearDecayModelListener)this._listeners.get(i)).nucleusTypeChanged();
        }
    }

    protected void notifyHalfLifeChanged() {
        for (int i = 0; i < this._listeners.size(); ++i) {
            ((NuclearDecayModelListener)this._listeners.get(i)).halfLifeChanged();
        }
    }

    private void generateJitterOffset(Point2D point2D) {
        double d;
        if (this._maxJitterLength == 0.0) {
            this._maxJitterLength = this._atomicNuclei.size() > 0 ? this._atomicNuclei.get(0).getDiameter() / 16.0 : 1.0;
        }
        if ((d = this._rand.nextDouble() * this._maxJitterLength) > 1.0) {
            d = 1.0;
        }
        double d2 = this._rand.nextDouble() * Math.PI * 2.0;
        point2D.setLocation(Math.cos(d2) * d, Math.sin(d2) * d);
    }

    public ConstantDtClock getClock() {
        return this._clock;
    }

    public void setHalfLife(double d) {
        if (this._currentNucleusType != NucleusType.HEAVY_CUSTOM && this._currentNucleusType != NucleusType.LIGHT_CUSTOM) {
            System.err.println(this.getClass().getName() + " - Warning: Can only set half life for custom nucleus, ignoring request.");
            return;
        }
        for (int i = 0; i < this._atomicNuclei.size(); ++i) {
            this._atomicNuclei.get(i).setHalfLife(d);
        }
        this.notifyHalfLifeChanged();
    }

    public double getHalfLife() {
        if (this._atomicNuclei.size() == 0) {
            return 0.0;
        }
        return this._atomicNuclei.get(0).getHalfLife();
    }

    public int getTotalNumNuclei() {
        return this._atomicNuclei.size();
    }

    public int getNumDecayedNuclei() {
        int n = 0;
        for (AtomicNucleus atomicNucleus : this._atomicNuclei) {
            if (!atomicNucleus.hasDecayed()) continue;
            ++n;
        }
        return n;
    }

    public int getNumActiveNuclei() {
        int n = 0;
        for (AtomicNucleus atomicNucleus : this._atomicNuclei) {
            if (!atomicNucleus.isDecayActive()) continue;
            ++n;
        }
        return n;
    }
}

