/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.common;

import edu.colorado.phet.nuclearphysics.NuclearPhysicsConstants;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsStrings;
import edu.colorado.phet.nuclearphysics.common.NucleusType;
import edu.colorado.phet.nuclearphysics.common.model.AtomicNucleus;
import java.awt.Color;

public class NucleusDisplayInfo {
    public static final NucleusDisplayInfo HYDROGEN_3_DISPLAY_INFO = new NucleusDisplayInfo(NuclearPhysicsStrings.HYDROGEN_3_LEGEND_LABEL, NuclearPhysicsStrings.HYDROGEN_3_CHEMICAL_SYMBOL, NuclearPhysicsStrings.HYDROGEN_3_ISOTOPE_NUMBER, NuclearPhysicsConstants.HYDROGEN_3_LABEL_COLOR, NuclearPhysicsConstants.HYDROGEN_COLOR, "hydrogen-nucleus.png");
    public static final NucleusDisplayInfo HELIUM_3_DISPLAY_INFO = new NucleusDisplayInfo(NuclearPhysicsStrings.HELIUM_3_LEGEND_LABEL, NuclearPhysicsStrings.HELIUM_3_CHEMICAL_SYMBOL, NuclearPhysicsStrings.HELIUM_3_ISOTOPE_NUMBER, NuclearPhysicsConstants.HELIUM_3_LABEL_COLOR, NuclearPhysicsConstants.HELIUM_COLOR, "helium-nucleus.png");
    public static final NucleusDisplayInfo CARBON_14_DISPLAY_INFO = new NucleusDisplayInfo(NuclearPhysicsStrings.CARBON_14_LEGEND_LABEL, NuclearPhysicsStrings.CARBON_14_CHEMICAL_SYMBOL, NuclearPhysicsStrings.CARBON_14_ISOTOPE_NUMBER, NuclearPhysicsConstants.CARBON_14_LABEL_COLOR, NuclearPhysicsConstants.CARBON_COLOR, "atomic_nucleus_with_around_15_nucleons.png");
    public static final NucleusDisplayInfo NITROGEN_14_DISPLAY_INFO = new NucleusDisplayInfo(NuclearPhysicsStrings.NITROGEN_14_LEGEND_LABEL, NuclearPhysicsStrings.NITROGEN_14_CHEMICAL_SYMBOL, NuclearPhysicsStrings.NITROGEN_14_ISOTOPE_NUMBER, NuclearPhysicsConstants.NITROGEN_14_LABEL_COLOR, NuclearPhysicsConstants.NITROGEN_COLOR, "atomic_nucleus_with_around_15_nucleons.png");
    public static final NucleusDisplayInfo LIGHT_CUSTOM_NUCLEUS_DISPLAY_INFO = new NucleusDisplayInfo(NuclearPhysicsStrings.CUSTOM_NUCLEUS_LEGEND_LABEL, NuclearPhysicsStrings.CUSTOM_NUCLEUS_CHEMICAL_SYMBOL, "", NuclearPhysicsConstants.CUSTOM_NUCLEUS_LABEL_COLOR, NuclearPhysicsConstants.CUSTOM_NUCLEUS_PRE_DECAY_COLOR, "atomic_nucleus_with_around_15_nucleons.png");
    public static final NucleusDisplayInfo DECAYED_LIGHT_CUSTOM_NUCLEUS_DISPLAY_INFO = new NucleusDisplayInfo(NuclearPhysicsStrings.CUSTOM_NUCLEUS_LEGEND_LABEL, NuclearPhysicsStrings.CUSTOM_NUCLEUS_CHEMICAL_SYMBOL, "", NuclearPhysicsConstants.CUSTOM_NUCLEUS_POST_DECAY_LABEL_COLOR, NuclearPhysicsConstants.CUSTOM_NUCLEUS_POST_DECAY_COLOR, "atomic_nucleus_with_around_15_nucleons.png");
    public static final NucleusDisplayInfo URANIUM_235_DISPLAY_INFO = new NucleusDisplayInfo(NuclearPhysicsStrings.URANIUM_235_LEGEND_LABEL, NuclearPhysicsStrings.URANIUM_235_CHEMICAL_SYMBOL, NuclearPhysicsStrings.URANIUM_235_ISOTOPE_NUMBER, NuclearPhysicsConstants.URANIUM_235_LABEL_COLOR, NuclearPhysicsConstants.URANIUM_COLOR, "polonium-nucleus-small.png");
    public static final NucleusDisplayInfo URANIUM_236_DISPLAY_INFO = new NucleusDisplayInfo(NuclearPhysicsStrings.URANIUM_236_LEGEND_LABEL, NuclearPhysicsStrings.URANIUM_236_CHEMICAL_SYMBOL, NuclearPhysicsStrings.URANIUM_236_ISOTOPE_NUMBER, NuclearPhysicsConstants.URANIUM_236_LABEL_COLOR, NuclearPhysicsConstants.URANIUM_COLOR, "polonium-nucleus-small.png");
    public static final NucleusDisplayInfo URANIUM_238_DISPLAY_INFO = new NucleusDisplayInfo(NuclearPhysicsStrings.URANIUM_238_LEGEND_LABEL, NuclearPhysicsStrings.URANIUM_238_CHEMICAL_SYMBOL, NuclearPhysicsStrings.URANIUM_238_ISOTOPE_NUMBER, NuclearPhysicsConstants.URANIUM_238_LABEL_COLOR, NuclearPhysicsConstants.URANIUM_COLOR, "polonium-nucleus-small.png");
    public static final NucleusDisplayInfo URANIUM_239_DISPLAY_INFO = new NucleusDisplayInfo(NuclearPhysicsStrings.URANIUM_239_LEGEND_LABEL, NuclearPhysicsStrings.URANIUM_239_CHEMICAL_SYMBOL, NuclearPhysicsStrings.URANIUM_239_ISOTOPE_NUMBER, NuclearPhysicsConstants.URANIUM_239_LABEL_COLOR, NuclearPhysicsConstants.URANIUM_COLOR, "polonium-nucleus-small.png");
    public static final NucleusDisplayInfo POLONIUM_211_DISPLAY_INFO = new NucleusDisplayInfo(NuclearPhysicsStrings.POLONIUM_211_LEGEND_LABEL, NuclearPhysicsStrings.POLONIUM_211_CHEMICAL_SYMBOL, NuclearPhysicsStrings.POLONIUM_211_ISOTOPE_NUMBER, NuclearPhysicsConstants.POLONIUM_LABEL_COLOR, NuclearPhysicsConstants.POLONIUM_COLOR, "polonium-nucleus-small.png");
    public static final NucleusDisplayInfo LEAD_206_DISPLAY_INFO = new NucleusDisplayInfo(NuclearPhysicsStrings.LEAD_206_LEGEND_LABEL, NuclearPhysicsStrings.LEAD_206_CHEMICAL_SYMBOL, NuclearPhysicsStrings.LEAD_206_ISOTOPE_NUMBER, NuclearPhysicsConstants.LEAD_LABEL_COLOR, NuclearPhysicsConstants.LEAD_COLOR, "polonium-nucleus-small.png");
    public static final NucleusDisplayInfo LEAD_207_DISPLAY_INFO = new NucleusDisplayInfo(NuclearPhysicsStrings.LEAD_207_LEGEND_LABEL, NuclearPhysicsStrings.LEAD_207_CHEMICAL_SYMBOL, NuclearPhysicsStrings.LEAD_207_ISOTOPE_NUMBER, NuclearPhysicsConstants.LEAD_LABEL_COLOR, NuclearPhysicsConstants.LEAD_COLOR, "polonium-nucleus-small.png");
    public static final NucleusDisplayInfo HEAVY_CUSTOM_NUCLEUS_DISPLAY_INFO = new NucleusDisplayInfo(NuclearPhysicsStrings.CUSTOM_NUCLEUS_LEGEND_LABEL, NuclearPhysicsStrings.CUSTOM_NUCLEUS_CHEMICAL_SYMBOL, "", NuclearPhysicsConstants.CUSTOM_NUCLEUS_LABEL_COLOR, NuclearPhysicsConstants.CUSTOM_NUCLEUS_PRE_DECAY_COLOR, "polonium-nucleus-small.png");
    public static final NucleusDisplayInfo DECAYED_HEAVY_CUSTOM_NUCLEUS_DISPLAY_INFO = new NucleusDisplayInfo(NuclearPhysicsStrings.DECAYED_CUSTOM_NUCLEUS_LEGEND_LABEL, NuclearPhysicsStrings.CUSTOM_NUCLEUS_CHEMICAL_SYMBOL, "", NuclearPhysicsConstants.CUSTOM_NUCLEUS_POST_DECAY_LABEL_COLOR, NuclearPhysicsConstants.CUSTOM_NUCLEUS_POST_DECAY_COLOR, "polonium-nucleus-small.png");
    public static final NucleusDisplayInfo DEFAULT_DISPLAY_INFO = new NucleusDisplayInfo("XX", "XX", "XX", Color.WHITE, Color.GRAY, "polonium-nucleus-small.png");
    private final String longName;
    private final String chemicalSymbol;
    private final String isotopeNumberString;
    private final Color labelColor;
    private final Color displayColor;
    private final String imageName;

    private NucleusDisplayInfo(String string, String string2, String string3, Color color, Color color2, String string4) {
        this.longName = string;
        this.chemicalSymbol = string2;
        this.isotopeNumberString = string3;
        this.labelColor = color;
        this.displayColor = color2;
        this.imageName = string4;
    }

    public String getName() {
        return this.longName;
    }

    public String getChemicalSymbol() {
        return this.chemicalSymbol;
    }

    public String getIsotopeNumberString() {
        return this.isotopeNumberString;
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public Color getDisplayColor() {
        return this.displayColor;
    }

    public String getImageName() {
        return this.imageName;
    }

    public static NucleusDisplayInfo getDisplayInfoForNucleusType(NucleusType nucleusType) {
        if (nucleusType == null) {
            return null;
        }
        NucleusDisplayInfo nucleusDisplayInfo = null;
        switch (nucleusType) {
            case HYDROGEN_3: {
                nucleusDisplayInfo = HYDROGEN_3_DISPLAY_INFO;
                break;
            }
            case HELIUM_3: {
                nucleusDisplayInfo = HELIUM_3_DISPLAY_INFO;
                break;
            }
            case CARBON_14: {
                nucleusDisplayInfo = CARBON_14_DISPLAY_INFO;
                break;
            }
            case NITROGEN_14: {
                nucleusDisplayInfo = NITROGEN_14_DISPLAY_INFO;
                break;
            }
            case LIGHT_CUSTOM: {
                nucleusDisplayInfo = LIGHT_CUSTOM_NUCLEUS_DISPLAY_INFO;
                break;
            }
            case LIGHT_CUSTOM_POST_DECAY: {
                nucleusDisplayInfo = DECAYED_LIGHT_CUSTOM_NUCLEUS_DISPLAY_INFO;
                break;
            }
            case LEAD_206: {
                nucleusDisplayInfo = LEAD_206_DISPLAY_INFO;
                break;
            }
            case LEAD_207: {
                nucleusDisplayInfo = LEAD_207_DISPLAY_INFO;
                break;
            }
            case POLONIUM_211: {
                nucleusDisplayInfo = POLONIUM_211_DISPLAY_INFO;
                break;
            }
            case URANIUM_235: {
                nucleusDisplayInfo = URANIUM_235_DISPLAY_INFO;
                break;
            }
            case URANIUM_236: {
                nucleusDisplayInfo = URANIUM_236_DISPLAY_INFO;
                break;
            }
            case URANIUM_238: {
                nucleusDisplayInfo = URANIUM_238_DISPLAY_INFO;
                break;
            }
            case URANIUM_239: {
                nucleusDisplayInfo = URANIUM_239_DISPLAY_INFO;
                break;
            }
            case HEAVY_CUSTOM: {
                nucleusDisplayInfo = HEAVY_CUSTOM_NUCLEUS_DISPLAY_INFO;
                break;
            }
            case HEAVY_CUSTOM_POST_DECAY: {
                nucleusDisplayInfo = DECAYED_HEAVY_CUSTOM_NUCLEUS_DISPLAY_INFO;
                break;
            }
            default: {
                System.err.println("Warning: No display information available for selected nucleus " + (Object)((Object)nucleusType) + ", using default");
                assert (false);
                nucleusDisplayInfo = DEFAULT_DISPLAY_INFO;
            }
        }
        return nucleusDisplayInfo;
    }

    public static NucleusDisplayInfo getDisplayInfoForNucleusConfig(int n, int n2) {
        return NucleusDisplayInfo.getDisplayInfoForNucleusType(AtomicNucleus.identifyNucleus(n, n2));
    }
}

