/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.input;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.java.games.input.Controller;
import net.java.games.input.ElementType;
import net.java.games.input.GenericDesktopUsage;
import net.java.games.input.OSXHIDElement;
import net.java.games.input.OSXHIDQueue;
import net.java.games.input.Usage;
import net.java.games.input.UsagePage;
import net.java.games.input.UsagePair;

final class OSXHIDDevice {
    private final long device_address;
    private final long device_interface_address;
    private final Map properties;
    private boolean released;

    public final Controller.PortType getPortType() {
        String transport = (String)this.properties.get("Transport");
        if (transport == null) {
            return Controller.PortType.UNKNOWN;
        }
        if (transport.equals("USB")) {
            return Controller.PortType.USB;
        }
        return Controller.PortType.UNKNOWN;
    }

    public final String getProductName() {
        return (String)this.properties.get("Product");
    }

    private final OSXHIDElement createElementFromElementProperties(Map element_properties) {
        long element_cookie = OSXHIDDevice.getLongFromProperties(element_properties, "ElementCookie");
        int element_type_id = OSXHIDDevice.getIntFromProperties(element_properties, "Type");
        ElementType element_type = ElementType.map(element_type_id);
        int min = (int)OSXHIDDevice.getLongFromProperties(element_properties, "Min", 0L);
        int max = (int)OSXHIDDevice.getLongFromProperties(element_properties, "Max", 65536L);
        UsagePair device_usage_pair = this.getUsagePair();
        boolean default_relative = device_usage_pair != null && (device_usage_pair.getUsage() == GenericDesktopUsage.POINTER || device_usage_pair.getUsage() == GenericDesktopUsage.MOUSE);
        boolean is_relative = OSXHIDDevice.getBooleanFromProperties(element_properties, "IsRelative", default_relative);
        int usage = OSXHIDDevice.getIntFromProperties(element_properties, "Usage");
        int usage_page = OSXHIDDevice.getIntFromProperties(element_properties, "UsagePage");
        UsagePair usage_pair = OSXHIDDevice.createUsagePair(usage_page, usage);
        if (usage_pair == null || element_type != ElementType.INPUT_MISC && element_type != ElementType.INPUT_BUTTON && element_type != ElementType.INPUT_AXIS) {
            return null;
        }
        return new OSXHIDElement(this, usage_pair, element_cookie, element_type, min, max, is_relative);
    }

    private final void addElements(List elements, Map properties) {
        Object[] elements_properties = (Object[])properties.get("Elements");
        if (elements_properties == null) {
            return;
        }
        for (int i = 0; i < elements_properties.length; ++i) {
            Map element_properties = (Map)elements_properties[i];
            OSXHIDElement element = this.createElementFromElementProperties(element_properties);
            if (element != null) {
                elements.add(element);
            }
            this.addElements(elements, element_properties);
        }
    }

    public final List getElements() {
        ArrayList elements = new ArrayList();
        this.addElements(elements, this.properties);
        return elements;
    }

    private static final long getLongFromProperties(Map properties, String key, long default_value) {
        Long long_obj = (Long)properties.get(key);
        if (long_obj == null) {
            return default_value;
        }
        return long_obj;
    }

    private static final boolean getBooleanFromProperties(Map properties, String key, boolean default_value) {
        return OSXHIDDevice.getLongFromProperties(properties, key, default_value ? 1L : 0L) != 0L;
    }

    private static final int getIntFromProperties(Map properties, String key) {
        return (int)OSXHIDDevice.getLongFromProperties(properties, key);
    }

    private static final long getLongFromProperties(Map properties, String key) {
        Long long_obj = (Long)properties.get(key);
        return long_obj;
    }

    private static final UsagePair createUsagePair(int usage_page_id, int usage_id) {
        Usage usage;
        UsagePage usage_page = UsagePage.map(usage_page_id);
        if (usage_page != null && (usage = usage_page.mapUsage(usage_id)) != null) {
            return new UsagePair(usage_page, usage);
        }
        return null;
    }

    public final UsagePair getUsagePair() {
        int usage_page_id = OSXHIDDevice.getIntFromProperties(this.properties, "PrimaryUsagePage");
        int usage_id = OSXHIDDevice.getIntFromProperties(this.properties, "PrimaryUsage");
        return OSXHIDDevice.createUsagePair(usage_page_id, usage_id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void release() throws IOException {
        try {
            this.close();
        }
        finally {
            this.released = true;
            OSXHIDDevice.nReleaseDevice(this.device_address, this.device_interface_address);
        }
    }

    private static final native void nReleaseDevice(long var0, long var2);

    public final synchronized OSXHIDQueue createQueue(int queue_depth) throws IOException {
        this.checkReleased();
        long queue_address = OSXHIDDevice.nCreateQueue(this.device_interface_address);
        return new OSXHIDQueue(queue_address, queue_depth);
    }

    private static final native long nCreateQueue(long var0) throws IOException;

    private final void close() throws IOException {
        OSXHIDDevice.nClose(this.device_interface_address);
    }

    private static final native void nClose(long var0) throws IOException;

    private final void checkReleased() throws IOException {
        if (this.released) {
            throw new IOException();
        }
    }
}

