/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.moleculeshapes.tabs.realmolecules;

import edu.colorado.phet.chemistry.utils.ChemUtils;
import edu.colorado.phet.common.phetcommon.model.property.ChangeObserver;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponent;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.Function0;
import edu.colorado.phet.common.phetcommon.util.function.Function1;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.ComboBoxNode;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.nodes.Spacer;
import edu.colorado.phet.common.piccolophet.nodes.kit.Kit;
import edu.colorado.phet.common.piccolophet.nodes.kit.KitSelectionNode;
import edu.colorado.phet.common.piccolophet.nodes.kit.ZeroOffsetNode;
import edu.colorado.phet.lwjglphet.utils.LWJGLUtils;
import edu.colorado.phet.moleculeshapes.MoleculeShapesResources;
import edu.colorado.phet.moleculeshapes.MoleculeShapesSimSharing;
import edu.colorado.phet.moleculeshapes.control.MoleculeShapesPanelNode;
import edu.colorado.phet.moleculeshapes.control.OptionsNode;
import edu.colorado.phet.moleculeshapes.control.PropertyCheckBoxNode;
import edu.colorado.phet.moleculeshapes.control.PropertyRadioButtonNode;
import edu.colorado.phet.moleculeshapes.control.TitledControlPanelNode;
import edu.colorado.phet.moleculeshapes.model.RealMoleculeShape;
import edu.colorado.phet.moleculeshapes.tabs.realmolecules.RealMoleculesTab;
import edu.umd.cs.piccolo.PNode;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Shape;
import java.awt.geom.RoundRectangle2D;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RealMoleculesControlPanel
extends PNode {
    private static final String[] TITLE_STRINGS = new String[]{MoleculeShapesResources.Strings.CONTROL__BONDING, MoleculeShapesResources.Strings.CONTROL__LONE_PAIR, MoleculeShapesResources.Strings.CONTROL__OPTIONS, MoleculeShapesResources.Strings.REAL_EXAMPLES__TITLE};
    private static final String[] CHECKBOX_STRINGS = new String[]{MoleculeShapesResources.Strings.CONTROL__SHOW_BOND_ANGLES, MoleculeShapesResources.Strings.CONTROL__SHOW_LONE_PAIRS};
    public static final double INNER_WIDTH = Math.ceil(RealMoleculesControlPanel.getRequiredInnerWidth());
    private Spacer moleculeSelectionSpacer;
    private RealMoleculeShape[][] kitMolecules;

    public RealMoleculesControlPanel(final RealMoleculesTab realMoleculesTab, Function0<Double> function0, boolean bl) {
        this.kitMolecules = bl ? new RealMoleculeShape[][]{{RealMoleculeShape.BORON_TRIFLUORIDE, RealMoleculeShape.METHANE, RealMoleculeShape.PHOSPHORUS_PENTACHLORIDE, RealMoleculeShape.SULFUR_HEXAFLUORIDE}} : new RealMoleculeShape[][]{{RealMoleculeShape.BORON_TRIFLUORIDE, RealMoleculeShape.METHANE, RealMoleculeShape.PHOSPHORUS_PENTACHLORIDE, RealMoleculeShape.SULFUR_HEXAFLUORIDE}, {RealMoleculeShape.CARBON_DIOXIDE, RealMoleculeShape.SULFUR_DIOXIDE, RealMoleculeShape.WATER, RealMoleculeShape.XENON_DIFLUORIDE}, {RealMoleculeShape.SULFUR_DIOXIDE, RealMoleculeShape.AMMONIA, RealMoleculeShape.SULFUR_TETRAFLUORIDE, RealMoleculeShape.BROMINE_PENTAFLUORIDE}, {RealMoleculeShape.WATER, RealMoleculeShape.CHLORINE_TRIFLUORIDE, RealMoleculeShape.XENON_TETRAFLUORIDE}};
        this.setOffset(0.0, 10.0);
        RealMoleculeShape[] realMoleculeShapeArray = bl ? RealMoleculeShape.TAB_2_BASIC_MOLECULES : RealMoleculeShape.TAB_2_MOLECULES;
        final PNode pNode = realMoleculesTab.shouldUseKit() ? new ZeroOffsetNode(new PNode(){
            {
                Dimension dimension = RealMoleculesControlPanel.this.getMaximumKitDimensions();
                Kit[] kitArray = new MoleculeKit[RealMoleculesControlPanel.this.kitMolecules.length];
                for (int i = 0; i < RealMoleculesControlPanel.this.kitMolecules.length; ++i) {
                    kitArray[i] = new MoleculeKit(realMoleculesTab, dimension, RealMoleculesControlPanel.this.kitMolecules[i]);
                }
                Property<Integer> property = new Property<Integer>(0);
                property.addObserver(new SimpleObserver((MoleculeKit[])kitArray, property){
                    final /* synthetic */ MoleculeKit[] val$kits;
                    final /* synthetic */ Property val$selectedKit;
                    {
                        this.val$kits = moleculeKitArray;
                        this.val$selectedKit = property;
                    }

                    public void update() {
                        final RealMoleculeShape realMoleculeShape = this.val$kits[(Integer)this.val$selectedKit.get()].getCurrentMolecule();
                        LWJGLUtils.invoke(new Runnable(){

                            public void run() {
                                realMoleculesTab.switchToMolecule(realMoleculeShape);
                            }
                        });
                    }
                });
                this.addChild(new KitSelectionNode<PNode>(property, (PNode)new Spacer(0.0, 0.0, 80.0, 10.0){
                    {
                        this.setPickable(false);
                        this.setChildrenPickable(false);
                    }
                }, kitArray){
                    {
                        this.controlHolderNode.setOffset(this.controlHolderNode.getXOffset(), this.controlHolderNode.getYOffset() + 100.0);
                    }
                });
            }
        }) : new ComboBoxNode<RealMoleculeShape>((IUserComponent)MoleculeShapesSimSharing.UserComponents.moleculeComboBox, (Function1)new Function1<RealMoleculeShape, String>(){

            @Override
            public String apply(RealMoleculeShape realMoleculeShape) {
                return realMoleculeShape.getDisplayName();
            }
        }, Arrays.asList(realMoleculeShapeArray), realMoleculeShapeArray[0], (Function1)new Function1<RealMoleculeShape, PNode>(){

            @Override
            public PNode apply(RealMoleculeShape realMoleculeShape) {
                return new HTMLNode(ChemUtils.toSubscript(realMoleculeShape.getDisplayName()), Color.BLACK, new PhetFont(12, true));
            }
        }){
            {
                super(iUserComponent, function1, list, realMoleculeShape, function12);
                this.scale(1.5);
                this.selectedItem.addObserver(new ChangeObserver<RealMoleculeShape>(){

                    @Override
                    public void update(final RealMoleculeShape realMoleculeShape, RealMoleculeShape realMoleculeShape2) {
                        LWJGLUtils.invoke(new Runnable(){

                            public void run() {
                                realMoleculesTab.switchToMolecule(realMoleculeShape);
                            }
                        });
                    }
                });
            }
        };
        MoleculeShapesPanelNode moleculeShapesPanelNode = new MoleculeShapesPanelNode(new PNode(){
            {
                this.addChild(new Spacer(0.0, 0.0, INNER_WIDTH, 20.0));
                RealMoleculesControlPanel.this.moleculeSelectionSpacer = new Spacer(pNode.getFullBounds()){
                    {
                        this.setOffset((INNER_WIDTH - pNode.getFullBounds().getWidth()) / 2.0, 10.0);
                    }
                };
                this.addChild(RealMoleculesControlPanel.this.moleculeSelectionSpacer);
            }
        }, MoleculeShapesResources.Strings.CONTROL__MOLECULE, 15);
        this.addChild(moleculeShapesPanelNode);
        MoleculeShapesPanelNode moleculeShapesPanelNode2 = new MoleculeShapesPanelNode((PNode)new OptionsNode(realMoleculesTab, INNER_WIDTH + 15.0), MoleculeShapesResources.Strings.CONTROL__OPTIONS);
        moleculeShapesPanelNode2.setOffset(0.0, moleculeShapesPanelNode.getFullBounds().getMaxY() + 20.0);
        this.addChild(moleculeShapesPanelNode2);
        pNode.setOffset(this.moleculeSelectionSpacer.getGlobalFullBounds().getX(), this.moleculeSelectionSpacer.getGlobalFullBounds().getY() - 10.0);
        this.addChild(pNode);
        this.addChild(new Spacer(0.0, 0.0, 10.0, 800.0));
    }

    public static double getRequiredInnerWidth() {
        double d = 160.0;
        for (String string : TITLE_STRINGS) {
            double d2 = new TitledControlPanelNode.TitleNode(string).getFullBounds().getWidth();
            d2 = string.equals(MoleculeShapesResources.Strings.REAL_EXAMPLES__TITLE) ? (d2 += 45.0) : (d2 += 25.0);
            d = Math.max(d, d2);
        }
        for (String string : CHECKBOX_STRINGS) {
            d = Math.max(d, new PropertyCheckBoxNode(new UserComponent("dummy"), string, new Property<Boolean>(true)).getFullBounds().getWidth());
        }
        return d;
    }

    public static PropertyRadioButtonNode<RealMoleculeShape> createRadioButton(RealMoleculeShape realMoleculeShape, Property<RealMoleculeShape> property) {
        return new PropertyRadioButtonNode<RealMoleculeShape>((IUserComponent)MoleculeShapesSimSharing.UserComponents.valueOf(realMoleculeShape.getDisplayName()), "<html>" + ChemUtils.toSubscript(realMoleculeShape.getDisplayName()) + "</html>", property, realMoleculeShape){
            {
                this.getRadioButton().setForeground(Color.BLACK);
            }
        };
    }

    public Dimension getMaximumKitDimensions() {
        Dimension dimension = new Dimension(0, 0);
        for (RealMoleculeShape[] realMoleculeShapeArray : this.kitMolecules) {
            double d = 0.0;
            double d2 = 0.0;
            for (RealMoleculeShape realMoleculeShape : realMoleculeShapeArray) {
                PropertyRadioButtonNode<RealMoleculeShape> propertyRadioButtonNode = RealMoleculesControlPanel.createRadioButton(realMoleculeShape, Property.property(realMoleculeShape));
                d = Math.max(d, propertyRadioButtonNode.getFullBounds().getWidth());
                d2 += propertyRadioButtonNode.getFullBounds().getHeight();
            }
            dimension = new Dimension(Math.max(dimension.width, (int)Math.ceil(d)), Math.max(dimension.height, (int)Math.ceil(d2)));
        }
        return dimension;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MoleculeKit
    extends Kit<PNode> {
        private Property<RealMoleculeShape> moleculeOptions;
        private final RealMoleculeShape[] shapes;

        public MoleculeKit(final RealMoleculesTab realMoleculesTab, Dimension dimension, RealMoleculeShape ... realMoleculeShapeArray) {
            super(new PNode());
            this.shapes = realMoleculeShapeArray;
            this.moleculeOptions = new Property<RealMoleculeShape>(realMoleculeShapeArray[0]);
            this.moleculeOptions.addObserver(new ChangeObserver<RealMoleculeShape>(){

                @Override
                public void update(RealMoleculeShape realMoleculeShape, RealMoleculeShape realMoleculeShape2) {
                    realMoleculesTab.switchToMolecule(realMoleculeShape);
                }
            });
            Property<Double> property = new Property<Double>(0.0);
            for (RealMoleculeShape realMoleculeShape : realMoleculeShapeArray) {
                PropertyRadioButtonNode<RealMoleculeShape> propertyRadioButtonNode = RealMoleculesControlPanel.createRadioButton(realMoleculeShape, this.moleculeOptions);
                propertyRadioButtonNode.setOffset(0.0, property.get());
                property.set(propertyRadioButtonNode.getFullBounds().getMaxY());
                this.content.addChild(propertyRadioButtonNode);
            }
            double d = 5.0;
            double d2 = 10.0;
            this.content.addChild(0, new PhetPPath((Shape)new RoundRectangle2D.Double(-d, -d, this.content.getFullBounds().getWidth() + d * 2.0, this.content.getFullBounds().getHeight() + d * 2.0, d2, d2), Color.WHITE));
        }

        public RealMoleculeShape getCurrentMolecule() {
            return this.moleculeOptions.get();
        }
    }
}

