/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.moleculeshapes.model;

import edu.colorado.phet.common.phetcommon.math.Permutation;
import edu.colorado.phet.common.phetcommon.math.vector.Vector3D;
import edu.colorado.phet.moleculeshapes.MoleculeShapesResources;
import edu.colorado.phet.moleculeshapes.model.AttractorModel;
import edu.colorado.phet.moleculeshapes.model.GeometryConfiguration;
import edu.colorado.phet.moleculeshapes.model.LocalShape;
import edu.colorado.phet.moleculeshapes.model.PairGroup;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VseprConfiguration {
    public final int x;
    public final int e;
    public final List<Vector3D> bondedUnitVectors;
    public final List<Vector3D> lonePairUnitVectors;
    public final GeometryConfiguration geometry;
    public final String name;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public VseprConfiguration(int n, int n2) {
        this.x = n;
        this.e = n2;
        this.geometry = GeometryConfiguration.getConfiguration(n + n2);
        this.bondedUnitVectors = new ArrayList<Vector3D>();
        this.lonePairUnitVectors = new ArrayList<Vector3D>();
        for (int i = 0; i < n + n2; ++i) {
            if (i < n2) {
                this.lonePairUnitVectors.add(this.geometry.unitVectors.get(i));
                continue;
            }
            this.bondedUnitVectors.add(this.geometry.unitVectors.get(i));
        }
        if (n == 0) {
            this.name = MoleculeShapesResources.Strings.SHAPE__EMPTY;
            return;
        } else if (n == 1) {
            this.name = MoleculeShapesResources.Strings.SHAPE__DIATOMIC;
            return;
        } else if (n == 2) {
            if (n2 == 0 || n2 == 3 || n2 == 4) {
                this.name = MoleculeShapesResources.Strings.SHAPE__LINEAR;
                return;
            } else {
                if (n2 != 1 && n2 != 2) throw new RuntimeException("invalid x: " + n + ", e: " + n2);
                this.name = MoleculeShapesResources.Strings.SHAPE__BENT;
            }
            return;
        } else if (n == 3) {
            if (n2 == 0) {
                this.name = MoleculeShapesResources.Strings.SHAPE__TRIGONAL_PLANAR;
                return;
            } else if (n2 == 1) {
                this.name = MoleculeShapesResources.Strings.SHAPE__TRIGONAL_PYRAMIDAL;
                return;
            } else {
                if (n2 != 2 && n2 != 3) throw new RuntimeException("invalid x: " + n + ", e: " + n2);
                this.name = MoleculeShapesResources.Strings.SHAPE__T_SHAPED;
            }
            return;
        } else if (n == 4) {
            if (n2 == 0) {
                this.name = MoleculeShapesResources.Strings.SHAPE__TETRAHEDRAL;
                return;
            } else if (n2 == 1) {
                this.name = MoleculeShapesResources.Strings.SHAPE__SEESAW;
                return;
            } else {
                if (n2 != 2) throw new RuntimeException("invalid x: " + n + ", e: " + n2);
                this.name = MoleculeShapesResources.Strings.SHAPE__SQUARE_PLANAR;
            }
            return;
        } else if (n == 5) {
            if (n2 == 0) {
                this.name = MoleculeShapesResources.Strings.SHAPE__TRIGONAL_BIPYRAMIDAL;
                return;
            } else {
                if (n2 != 1) throw new RuntimeException("invalid x: " + n + ", e: " + n2);
                this.name = MoleculeShapesResources.Strings.SHAPE__SQUARE_PYRAMIDAL;
            }
            return;
        } else if (n == 6) {
            if (n2 != 0) throw new RuntimeException("invalid x: " + n + ", e: " + n2);
            this.name = MoleculeShapesResources.Strings.SHAPE__OCTAHEDRAL;
            return;
        } else {
            this.name = null;
        }
    }

    public List<Vector3D> getAllUnitVectors() {
        return this.geometry.unitVectors;
    }

    public List<Vector3D> getIdealBondUnitVectors() {
        return new ArrayList<Vector3D>(){
            {
                for (int i = VseprConfiguration.this.e; i < VseprConfiguration.this.x + VseprConfiguration.this.e; ++i) {
                    this.add(VseprConfiguration.this.geometry.unitVectors.get(i));
                }
            }
        };
    }

    public AttractorModel.ResultMapping getIdealGroupRotationToPositions(List<PairGroup> list) {
        assert (this.x + this.e == list.size());
        return AttractorModel.findClosestMatchingConfiguration(AttractorModel.getOrientationsFromOrigin(list), this.geometry.unitVectors, LocalShape.vseprPermutations(list));
    }

    public AttractorModel.ResultMapping getIdealBondRotationToPositions(List<PairGroup> list) {
        assert (this.x == list.size());
        List<Vector3D> list2 = this.getIdealBondUnitVectors();
        return AttractorModel.findClosestMatchingConfiguration(AttractorModel.getOrientationsFromOrigin(list), list2, Permutation.permutations(list2.size()));
    }

    public int hashCode() {
        return this.x + this.e * 10;
    }

    public boolean equals(Object object) {
        if (object instanceof VseprConfiguration) {
            VseprConfiguration vseprConfiguration = (VseprConfiguration)object;
            return this.x == vseprConfiguration.x && this.e == vseprConfiguration.e;
        }
        return false;
    }
}

