/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.moleculeshapes.model;

import edu.colorado.phet.chemistry.model.Element;
import edu.colorado.phet.common.phetcommon.math.vector.Vector3D;
import edu.colorado.phet.common.phetcommon.util.FunctionalUtils;
import edu.colorado.phet.common.phetcommon.util.function.Function1;
import edu.colorado.phet.moleculeshapes.model.Atom3D;
import edu.colorado.phet.moleculeshapes.model.Bond;
import edu.colorado.phet.moleculeshapes.model.GeometryConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RealMoleculeShape {
    private final String displayName;
    private double simplifiedBondLength;
    private List<Atom3D> atoms = new ArrayList<Atom3D>();
    private List<Bond<Atom3D>> bonds = new ArrayList<Bond<Atom3D>>();
    private Atom3D centralAtom = null;
    private final boolean useSimplifiedBondLength = true;
    public static final RealMoleculeShape BERYLLIUM_CHLORIDE = new RealMoleculeShape("BeCl2", 1.8){
        {
            this.addCentralAtom(new Atom3D(Element.Be, new Vector3D()));
            this.addRadialAtom(new Atom3D(Element.Cl, new Vector3D(1.8, 0.0, 0.0), 3), 1);
            this.addRadialAtom(new Atom3D(Element.Cl, new Vector3D(-1.8, 0.0, 0.0), 3), 1);
        }
    };
    public static final RealMoleculeShape BORON_TRIFLUORIDE = new RealMoleculeShape("BF3", 1.313){
        {
            this.addCentralAtom(new Atom3D(Element.B, new Vector3D()));
            double d2 = 2.0943951023931953;
            double d3 = 1.313;
            this.addRadialAtom(new Atom3D(Element.F, new Vector3D(d3 * Math.cos(0.0 * d2), d3 * Math.sin(0.0 * d2), 0.0), 3), 1);
            this.addRadialAtom(new Atom3D(Element.F, new Vector3D(d3 * Math.cos(1.0 * d2), d3 * Math.sin(1.0 * d2), 0.0), 3), 1);
            this.addRadialAtom(new Atom3D(Element.F, new Vector3D(d3 * Math.cos(2.0 * d2), d3 * Math.sin(2.0 * d2), 0.0), 3), 1);
        }
    };
    public static final RealMoleculeShape BROMINE_PENTAFLUORIDE = new RealMoleculeShape("BrF5", 1.774){
        {
            this.addCentralAtom(new Atom3D(Element.B, new Vector3D(), 1));
            double d2 = 1.689;
            double d3 = 1.774;
            double d4 = Math.toRadians(84.8);
            double d5 = Math.sin(d4) * d3;
            double d6 = Math.cos(d4) * d3;
            this.addRadialAtom(new Atom3D(Element.F, new Vector3D(0.0, -d2, 0.0), 3), 1);
            this.addRadialAtom(new Atom3D(Element.F, new Vector3D(d5, -d6, 0.0), 3), 1);
            this.addRadialAtom(new Atom3D(Element.F, new Vector3D(0.0, -d6, d5), 3), 1);
            this.addRadialAtom(new Atom3D(Element.F, new Vector3D(-d5, -d6, 0.0), 3), 1);
            this.addRadialAtom(new Atom3D(Element.F, new Vector3D(0.0, -d6, -d5), 3), 1);
        }
    };
    public static final RealMoleculeShape METHANE = new RealMoleculeShape("CH4", 1.087){
        {
            this.addCentralAtom(new Atom3D(Element.C, new Vector3D()));
            double d2 = 1.087;
            for (Vector3D vector3D : GeometryConfiguration.getConfiguration((int)4).unitVectors) {
                this.addRadialAtom(new Atom3D(Element.H, vector3D.times(d2), 0), 1);
            }
        }
    };
    public static final RealMoleculeShape CHLORINE_TRIFLUORIDE = new RealMoleculeShape("ClF3", 1.698){
        {
            this.addCentralAtom(new Atom3D(Element.Cl, new Vector3D(), 2));
            this.addRadialAtom(new Atom3D(Element.F, new Vector3D(0.0, -1.598, 0.0), 3), 1);
            double d2 = Math.toRadians(87.5);
            double d3 = 1.698;
            double d4 = Math.sin(d2) * d3;
            double d5 = Math.cos(d2) * d3;
            this.addRadialAtom(new Atom3D(Element.F, new Vector3D(d4, -d5, 0.0), 3), 1);
            this.addRadialAtom(new Atom3D(Element.F, new Vector3D(-d4, -d5, 0.0), 3), 1);
        }
    };
    public static final RealMoleculeShape CARBON_DIOXIDE = new RealMoleculeShape("CO2", 1.163){
        {
            this.addCentralAtom(new Atom3D(Element.C, new Vector3D()));
            this.addRadialAtom(new Atom3D(Element.O, new Vector3D(-1.163, 0.0, 0.0), 2), 2);
            this.addRadialAtom(new Atom3D(Element.O, new Vector3D(1.163, 0.0, 0.0), 2), 2);
        }
    };
    public static final RealMoleculeShape WATER = new RealMoleculeShape("H2O", 0.957){
        {
            this.addCentralAtom(new Atom3D(Element.O, new Vector3D(), 2));
            double d2 = 0.957;
            double d3 = Math.toRadians(104.5) / 2.0;
            this.addRadialAtom(new Atom3D(Element.H, new Vector3D(Math.sin(d3), -Math.cos(d3), 0.0).times(d2)), 1);
            this.addRadialAtom(new Atom3D(Element.H, new Vector3D(-Math.sin(d3), -Math.cos(d3), 0.0).times(d2)), 1);
        }
    };
    public static final RealMoleculeShape AMMONIA = new RealMoleculeShape("NH3", 1.017){
        {
            this.addCentralAtom(new Atom3D(Element.N, new Vector3D(), 1));
            double d2 = 1.017;
            double d3 = 1.202623030417028;
            double d4 = 2.0943951023931953;
            double d5 = Math.sin(d3) * d2;
            double d6 = Math.cos(d3) * d2;
            this.addRadialAtom(new Atom3D(Element.H, new Vector3D(d5 * Math.cos(0.0 * d4), -d6, d5 * Math.sin(0.0 * d4))), 1);
            this.addRadialAtom(new Atom3D(Element.H, new Vector3D(d5 * Math.cos(1.0 * d4), -d6, d5 * Math.sin(1.0 * d4))), 1);
            this.addRadialAtom(new Atom3D(Element.H, new Vector3D(d5 * Math.cos(2.0 * d4), -d6, d5 * Math.sin(2.0 * d4))), 1);
        }
    };
    public static final RealMoleculeShape PHOSPHORUS_PENTACHLORIDE = new RealMoleculeShape("PCl5", 2.02){
        {
            this.addCentralAtom(new Atom3D(Element.P, new Vector3D()));
            this.addRadialAtom(new Atom3D(Element.Cl, new Vector3D(2.14, 0.0, 0.0), 3), 1);
            this.addRadialAtom(new Atom3D(Element.Cl, new Vector3D(-2.14, 0.0, 0.0), 3), 1);
            double d2 = 2.0943951023931953;
            double d3 = 2.02;
            this.addRadialAtom(new Atom3D(Element.Cl, new Vector3D(0.0, Math.cos(0.0 * d2), Math.sin(0.0 * d2)).times(d3), 3), 1);
            this.addRadialAtom(new Atom3D(Element.Cl, new Vector3D(0.0, Math.cos(1.0 * d2), Math.sin(1.0 * d2)).times(d3), 3), 1);
            this.addRadialAtom(new Atom3D(Element.Cl, new Vector3D(0.0, Math.cos(2.0 * d2), Math.sin(2.0 * d2)).times(d3), 3), 1);
        }
    };
    public static final RealMoleculeShape SULFUR_TETRAFLUORIDE = new RealMoleculeShape("SF4", 1.595){
        {
            this.addCentralAtom(new Atom3D(Element.S, new Vector3D(), 1));
            double d2 = Math.toRadians(173.1) / 2.0;
            double d3 = Math.toRadians(101.6) / 2.0;
            this.addRadialAtom(new Atom3D(Element.F, new Vector3D(Math.sin(d2), -Math.cos(d2), 0.0).times(1.646), 3), 1);
            this.addRadialAtom(new Atom3D(Element.F, new Vector3D(-Math.sin(d2), -Math.cos(d2), 0.0).times(1.646), 3), 1);
            this.addRadialAtom(new Atom3D(Element.F, new Vector3D(0.0, -Math.cos(d3), Math.sin(d3)).times(1.545), 3), 1);
            this.addRadialAtom(new Atom3D(Element.F, new Vector3D(0.0, -Math.cos(d3), -Math.sin(d3)).times(1.545), 3), 1);
        }
    };
    public static final RealMoleculeShape SULFUR_HEXAFLUORIDE = new RealMoleculeShape("SF6", 1.564){
        {
            this.addCentralAtom(new Atom3D(Element.S, new Vector3D()));
            for (Vector3D vector3D : GeometryConfiguration.getConfiguration((int)6).unitVectors) {
                this.addRadialAtom(new Atom3D(Element.F, vector3D.times(1.564), 3), 1);
            }
        }
    };
    public static final RealMoleculeShape SULFUR_DIOXIDE = new RealMoleculeShape("SO2", 1.431){
        {
            double d2 = Math.toRadians(119.0) / 2.0;
            double d3 = 1.431;
            this.addCentralAtom(new Atom3D(Element.S, new Vector3D(), 1));
            this.addRadialAtom(new Atom3D(Element.O, new Vector3D(Math.sin(d2), -Math.cos(d2), 0.0).times(d3), 2), 2);
            this.addRadialAtom(new Atom3D(Element.O, new Vector3D(-Math.sin(d2), -Math.cos(d2), 0.0).times(d3), 2), 2);
        }
    };
    public static final RealMoleculeShape XENON_DIFLUORIDE = new RealMoleculeShape("XeF2", 1.977){
        {
            this.addCentralAtom(new Atom3D(Element.Xe, new Vector3D(), 3));
            this.addRadialAtom(new Atom3D(Element.F, new Vector3D(1.977, 0.0, 0.0), 3), 1);
            this.addRadialAtom(new Atom3D(Element.F, new Vector3D(-1.977, 0.0, 0.0), 3), 1);
        }
    };
    public static final RealMoleculeShape XENON_TETRAFLUORIDE = new RealMoleculeShape("XeF4", 1.953){
        {
            double d2 = 1.953;
            this.addCentralAtom(new Atom3D(Element.Xe, new Vector3D(), 2));
            this.addRadialAtom(new Atom3D(Element.F, new Vector3D(d2, 0.0, 0.0), 3), 1);
            this.addRadialAtom(new Atom3D(Element.F, new Vector3D(-d2, 0.0, 0.0), 3), 1);
            this.addRadialAtom(new Atom3D(Element.F, new Vector3D(0.0, 0.0, d2), 3), 1);
            this.addRadialAtom(new Atom3D(Element.F, new Vector3D(0.0, 0.0, -d2), 3), 1);
        }
    };
    public static final RealMoleculeShape[] TAB_2_BASIC_MOLECULES = new RealMoleculeShape[]{BERYLLIUM_CHLORIDE, BORON_TRIFLUORIDE, METHANE, PHOSPHORUS_PENTACHLORIDE, SULFUR_HEXAFLUORIDE};
    public static final RealMoleculeShape[] TAB_2_MOLECULES = new RealMoleculeShape[]{WATER, CARBON_DIOXIDE, SULFUR_DIOXIDE, XENON_DIFLUORIDE, BORON_TRIFLUORIDE, CHLORINE_TRIFLUORIDE, AMMONIA, METHANE, SULFUR_TETRAFLUORIDE, XENON_TETRAFLUORIDE, BROMINE_PENTAFLUORIDE, PHOSPHORUS_PENTACHLORIDE, SULFUR_HEXAFLUORIDE};

    private RealMoleculeShape(String string, double d) {
        this.displayName = string;
        this.simplifiedBondLength = d;
    }

    public void addAtom(Atom3D atom3D) {
        assert (!this.atoms.contains(atom3D));
        this.atoms.add(atom3D);
    }

    public void addBond(Atom3D atom3D, Atom3D atom3D2, int n, double d) {
        this.bonds.add(new Bond<Atom3D>(atom3D, atom3D2, n, d));
    }

    public Collection<Bond<Atom3D>> getBonds() {
        return this.bonds;
    }

    public void addCentralAtom(Atom3D atom3D) {
        this.addAtom(atom3D);
        this.centralAtom = atom3D;
    }

    public void addRadialAtom(Atom3D atom3D, int n) {
        atom3D.position.set(atom3D.position.get().normalized().times(this.simplifiedBondLength));
        this.addAtom(atom3D);
        this.addBond(atom3D, this.centralAtom, n, this.simplifiedBondLength);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Atom3D getCentralAtom() {
        return this.centralAtom;
    }

    public int getCentralLonePairCount() {
        return this.getCentralAtom().lonePairCount;
    }

    public int getCentralAtomCount() {
        final Atom3D atom3D = this.getCentralAtom();
        return FunctionalUtils.map(FunctionalUtils.filter(this.getBonds(), new Function1<Bond<Atom3D>, Boolean>(){

            @Override
            public Boolean apply(Bond<Atom3D> bond) {
                return bond.contains(atom3D);
            }
        }), new Function1<Bond<Atom3D>, Atom3D>(){

            @Override
            public Atom3D apply(Bond<Atom3D> bond) {
                return bond.getOtherAtom(atom3D);
            }
        }).size();
    }

    public String toString() {
        return this.displayName;
    }
}

