/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.moleculeshapes.model;

import edu.colorado.phet.common.phetcommon.math.Permutation;
import edu.colorado.phet.common.phetcommon.math.vector.Vector3D;
import edu.colorado.phet.common.phetcommon.model.event.CompositeNotifier;
import edu.colorado.phet.common.phetcommon.model.event.Notifier;
import edu.colorado.phet.common.phetcommon.util.FunctionalUtils;
import edu.colorado.phet.common.phetcommon.util.Option;
import edu.colorado.phet.common.phetcommon.util.function.Function1;
import edu.colorado.phet.moleculeshapes.model.AttractorModel;
import edu.colorado.phet.moleculeshapes.model.Bond;
import edu.colorado.phet.moleculeshapes.model.LocalShape;
import edu.colorado.phet.moleculeshapes.model.PairGroup;
import edu.colorado.phet.moleculeshapes.model.VseprConfiguration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Molecule {
    private List<PairGroup> groups = new ArrayList<PairGroup>();
    private List<Bond<PairGroup>> bonds = new ArrayList<Bond<PairGroup>>();
    private PairGroup centralAtom;
    public final Notifier<Bond<PairGroup>> onBondAdded = new Notifier();
    public final Notifier<Bond<PairGroup>> onBondRemoved = new Notifier();
    public final CompositeNotifier<Bond<PairGroup>> onBondChanged = new CompositeNotifier(this.onBondAdded, this.onBondRemoved);
    public final Notifier<PairGroup> onGroupAdded = new Notifier();
    public final Notifier<PairGroup> onGroupRemoved = new Notifier();
    public final CompositeNotifier<PairGroup> onGroupChanged = new CompositeNotifier(this.onGroupAdded, this.onGroupRemoved);

    public abstract Option<Float> getMaximumBondLength();

    public void update(float f) {
        List<PairGroup> list = FunctionalUtils.filter(this.groups, new Function1<PairGroup, Boolean>(){

            @Override
            public Boolean apply(PairGroup pairGroup) {
                return pairGroup != Molecule.this.getCentralAtom();
            }
        });
        for (PairGroup pairGroup : list) {
            Bond<PairGroup> bond = this.getParentBond(pairGroup);
            Vector3D vector3D = bond.getOtherAtom((PairGroup)pairGroup).position.get();
            double d = pairGroup.position.get().minus(vector3D).magnitude();
            pairGroup.stepForward(f);
            pairGroup.attractToIdealDistance(f, d, bond);
        }
    }

    public List<PairGroup> getAtoms() {
        return FunctionalUtils.filter(this.getGroups(), new Function1<PairGroup, Boolean>(){

            @Override
            public Boolean apply(PairGroup pairGroup) {
                return !pairGroup.isLonePair;
            }
        });
    }

    public int getStericNumber(PairGroup pairGroup) {
        return this.getBonds(pairGroup).size();
    }

    public List<Bond<PairGroup>> getBonds(final PairGroup pairGroup) {
        return FunctionalUtils.filter(this.bonds, new Function1<Bond<PairGroup>, Boolean>(){

            @Override
            public Boolean apply(Bond<PairGroup> bond) {
                return bond.contains(pairGroup);
            }
        });
    }

    public List<PairGroup> getNeighbors(final PairGroup pairGroup) {
        return FunctionalUtils.map(this.getBonds(pairGroup), new Function1<Bond<PairGroup>, PairGroup>(){

            @Override
            public PairGroup apply(Bond<PairGroup> bond) {
                return bond.getOtherAtom(pairGroup);
            }
        });
    }

    public List<PairGroup> getAllLonePairs() {
        return FunctionalUtils.filter(this.getGroups(), new Function1<PairGroup, Boolean>(){

            @Override
            public Boolean apply(PairGroup pairGroup) {
                return pairGroup.isLonePair;
            }
        });
    }

    public List<PairGroup> getRadialAtoms() {
        return this.getNeighboringAtoms(this.getCentralAtom());
    }

    public List<PairGroup> getNeighboringAtoms(PairGroup pairGroup) {
        return FunctionalUtils.filter(this.getRadialGroups(), new Function1<PairGroup, Boolean>(){

            @Override
            public Boolean apply(PairGroup pairGroup) {
                return !pairGroup.isLonePair;
            }
        });
    }

    public List<PairGroup> getLonePairNeighbors(PairGroup pairGroup) {
        return FunctionalUtils.filter(this.getRadialGroups(), new Function1<PairGroup, Boolean>(){

            @Override
            public Boolean apply(PairGroup pairGroup) {
                return pairGroup.isLonePair;
            }
        });
    }

    public List<PairGroup> getRadialLonePairs() {
        return this.getLonePairNeighbors(this.getCentralAtom());
    }

    public VseprConfiguration getCentralVseprConfiguration() {
        return this.getVseprConfiguration(this.getCentralAtom());
    }

    public VseprConfiguration getVseprConfiguration(PairGroup pairGroup) {
        return new VseprConfiguration(this.getNeighboringAtoms(pairGroup).size(), this.getLonePairNeighbors(pairGroup).size());
    }

    public Bond<PairGroup> getParentBond(final PairGroup pairGroup) {
        if (pairGroup.isLonePair) {
            return this.getBonds(pairGroup).get(0);
        }
        return FunctionalUtils.firstOrNull(this.getBonds(pairGroup), new Function1<Bond<PairGroup>, Boolean>(){

            @Override
            public Boolean apply(Bond<PairGroup> bond) {
                return bond.getOtherAtom(pairGroup) == Molecule.this.getCentralAtom();
            }
        });
    }

    public PairGroup getParent(PairGroup pairGroup) {
        return this.getParentBond(pairGroup).getOtherAtom(pairGroup);
    }

    public void addCentralAtom(PairGroup pairGroup) {
        this.centralAtom = pairGroup;
        this.addGroup(pairGroup, true);
    }

    public void addGroup(PairGroup pairGroup, PairGroup pairGroup2, int n) {
        this.addGroup(pairGroup, false);
        this.addBond(pairGroup, pairGroup2, n, pairGroup.position.get().minus(pairGroup2.position.get()).magnitude() / 5.5);
        this.onGroupAdded.updateListeners(pairGroup);
    }

    public void addGroup(PairGroup pairGroup, PairGroup pairGroup2, int n, double d) {
        this.addGroup(pairGroup, false);
        this.addBond(new Bond<PairGroup>(pairGroup, pairGroup2, n, d));
        this.onGroupAdded.updateListeners(pairGroup);
    }

    public void addGroup(PairGroup pairGroup, boolean bl) {
        assert (this.getCentralAtom() != null);
        this.groups.add(pairGroup);
        if (bl) {
            this.onGroupAdded.updateListeners(pairGroup);
        }
    }

    public void addBond(Bond<PairGroup> bond) {
        this.bonds.add(bond);
        this.onBondAdded.updateListeners(bond);
    }

    public void addBond(PairGroup pairGroup, PairGroup pairGroup2, int n, double d) {
        this.addBond(new Bond<PairGroup>(pairGroup, pairGroup2, n, d));
    }

    public PairGroup getCentralAtom() {
        return this.centralAtom;
    }

    public void removeGroup(PairGroup pairGroup) {
        assert (this.getCentralAtom() != pairGroup);
        List<Bond<PairGroup>> list = this.getBonds(pairGroup);
        for (Bond<PairGroup> bond : list) {
            this.bonds.remove(bond);
        }
        this.groups.remove(pairGroup);
        this.onGroupRemoved.updateListeners(pairGroup);
        for (Bond<PairGroup> bond : list) {
            this.onBondRemoved.updateListeners(bond);
        }
    }

    public void removeAllGroups() {
        for (PairGroup pairGroup : new ArrayList<PairGroup>(this.getGroups())) {
            if (pairGroup == this.getCentralAtom()) continue;
            this.removeGroup(pairGroup);
        }
    }

    public List<PairGroup> getGroups() {
        return this.groups;
    }

    public boolean wouldAllowBondOrder(int n) {
        return this.getStericNumber(this.getCentralAtom()) < 6;
    }

    public List<PairGroup> getDistantLonePairs() {
        return FunctionalUtils.subtract(this.getAllLonePairs(), this.getLonePairNeighbors(this.getCentralAtom()));
    }

    public abstract boolean isReal();

    public LocalShape getLocalVSEPRShape(PairGroup pairGroup) {
        List<PairGroup> list = LocalShape.sortedLonePairsFirst(this.getNeighbors(pairGroup));
        int n = FunctionalUtils.count(list, new Function1<PairGroup, Boolean>(){

            @Override
            public Boolean apply(PairGroup pairGroup) {
                return pairGroup.isLonePair;
            }
        });
        int n2 = list.size() - n;
        return new LocalShape(LocalShape.vseprPermutations(list), pairGroup, list, new VseprConfiguration((int)n2, (int)n).geometry.unitVectors);
    }

    public List<PairGroup> getRadialGroups() {
        return this.getNeighbors(this.getCentralAtom());
    }

    public double getIdealDistanceFromCenter(PairGroup pairGroup) {
        Bond<PairGroup> bond = this.getParentBond(pairGroup);
        assert (bond.contains(this.getCentralAtom()));
        return pairGroup.isLonePair ? 7.0 : bond.length * 5.5;
    }

    public void addTerminalLonePairs(PairGroup pairGroup, int n) {
        VseprConfiguration vseprConfiguration = new VseprConfiguration(1, n);
        List<Vector3D> list = vseprConfiguration.geometry.unitVectors;
        AttractorModel.ResultMapping resultMapping = AttractorModel.findClosestMatchingConfiguration(Arrays.asList(pairGroup.position.get().normalized()), Arrays.asList(list.get(list.size() - 1).negated()), Arrays.asList(Permutation.identity(1)));
        for (int i = 0; i < n; ++i) {
            Vector3D vector3D = resultMapping.rotateVector(list.get(i));
            this.addGroup(new PairGroup(pairGroup.position.get().plus(vector3D.times(7.0)), true, false), pairGroup, 0);
        }
    }
}

