/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.moleculeshapes.model;

import edu.colorado.phet.common.phetcommon.math.vector.Vector3D;
import edu.colorado.phet.moleculeshapes.MoleculeShapesResources;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GeometryConfiguration {
    private static final Map<Integer, GeometryConfiguration> GEOMETRY_MAP = new HashMap<Integer, GeometryConfiguration>(){
        {
            this.put(0, new GeometryConfiguration(MoleculeShapesResources.Strings.GEOMETRY__EMPTY, new Vector3D[0]));
            this.put(1, new GeometryConfiguration(MoleculeShapesResources.Strings.GEOMETRY__DIATOMIC, new Vector3D[]{new Vector3D(1.0, 0.0, 0.0)}));
            this.put(2, new GeometryConfiguration(MoleculeShapesResources.Strings.GEOMETRY__LINEAR, new Vector3D[]{new Vector3D(1.0, 0.0, 0.0), new Vector3D(-1.0, 0.0, 0.0)}));
            this.put(3, new GeometryConfiguration(MoleculeShapesResources.Strings.GEOMETRY__TRIGONAL_PLANAR, new Vector3D[]{new Vector3D(1.0, 0.0, 0.0), new Vector3D(Math.cos(2.0943951023931953), Math.sin(2.0943951023931953), 0.0), new Vector3D(Math.cos(4.1887902047863905), Math.sin(4.1887902047863905), 0.0)}));
            this.put(4, new GeometryConfiguration(MoleculeShapesResources.Strings.GEOMETRY__TETRAHEDRAL, new Vector3D[]{new Vector3D(0.0, 0.0, 1.0), new Vector3D(Math.cos(0.0) * Math.cos(-0.3398369041921167), Math.sin(0.0) * Math.cos(-0.3398369041921167), Math.sin(-0.3398369041921167)), new Vector3D(Math.cos(2.0943951023931953) * Math.cos(-0.3398369041921167), Math.sin(2.0943951023931953) * Math.cos(-0.3398369041921167), Math.sin(-0.3398369041921167)), new Vector3D(Math.cos(4.1887902047863905) * Math.cos(-0.3398369041921167), Math.sin(4.1887902047863905) * Math.cos(-0.3398369041921167), Math.sin(-0.3398369041921167))}));
            this.put(5, new GeometryConfiguration(MoleculeShapesResources.Strings.GEOMETRY__TRIGONAL_BIPYRAMIDAL, new Vector3D[]{new Vector3D(0.0, 1.0, 0.0), new Vector3D(0.0, Math.cos(2.0943951023931953), Math.sin(2.0943951023931953)), new Vector3D(0.0, Math.cos(4.1887902047863905), Math.sin(4.1887902047863905)), new Vector3D(1.0, 0.0, 0.0), new Vector3D(-1.0, 0.0, 0.0)}));
            this.put(6, new GeometryConfiguration(MoleculeShapesResources.Strings.GEOMETRY__OCTAHEDRAL, new Vector3D[]{new Vector3D(0.0, 0.0, 1.0), new Vector3D(0.0, 0.0, -1.0), new Vector3D(0.0, 1.0, 0.0), new Vector3D(0.0, -1.0, 0.0), new Vector3D(1.0, 0.0, 0.0), new Vector3D(-1.0, 0.0, 0.0)}));
        }
    };
    public List<Vector3D> unitVectors;
    public final String name;

    public static GeometryConfiguration getConfiguration(int n) {
        return GEOMETRY_MAP.get(n);
    }

    private GeometryConfiguration(String string, Vector3D ... vector3DArray) {
        this.name = string;
        this.unitVectors = Arrays.asList(vector3DArray);
    }
}

