/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.moleculeshapes.model;

import Jama.Matrix;
import Jama.SingularValueDecomposition;
import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.math.Permutation;
import edu.colorado.phet.common.phetcommon.math.vector.AbstractVector3D;
import edu.colorado.phet.common.phetcommon.math.vector.Vector3D;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.FunctionalUtils;
import edu.colorado.phet.common.phetcommon.util.Pair;
import edu.colorado.phet.common.phetcommon.util.function.Function1;
import edu.colorado.phet.jamaphet.JamaUtils;
import edu.colorado.phet.moleculeshapes.model.PairGroup;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttractorModel {
    public static double applyAttractorForces(List<PairGroup> list, float f, List<Vector3D> list2, List<Permutation> list3, final Vector3D vector3D, boolean bl) {
        Object object;
        List<Vector3D> list4 = FunctionalUtils.map(list, new Function1<PairGroup, Vector3D>(){

            @Override
            public Vector3D apply(PairGroup pairGroup) {
                return pairGroup.position.get().minus(vector3D).normalized();
            }
        });
        ResultMapping resultMapping = AttractorModel.findClosestMatchingConfiguration(list4, list2, list3);
        boolean bl2 = vector3D.equals(new Vector3D());
        double d = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            PairGroup pairGroup = list.get(i);
            Vector3D vector3D2 = JamaUtils.vectorFromMatrix3D(resultMapping.target, i);
            double d2 = pairGroup.position.get().minus(vector3D).magnitude();
            Vector3D vector3D3 = vector3D2.times(d2).plus(vector3D);
            object = vector3D3.minus(pairGroup.position.get());
            d += ((AbstractVector3D)object).magnitude() * ((AbstractVector3D)object).magnitude();
            double d3 = (double)(f * 3.0f) * ((AbstractVector3D)object).magnitude();
            if ((pairGroup.isLonePair || !pairGroup.isCentralAtom()) && bl2) {
                pairGroup.addVelocity(((AbstractVector3D)object).times(d3));
            }
            if (!pairGroup.isCentralAtom() && bl2) {
                pairGroup.addPosition(((AbstractVector3D)object).times(2.0 * (double)f));
            }
            if (pairGroup.isCentralAtom() || bl2) continue;
            pairGroup.addPosition(((AbstractVector3D)object).times(Math.min(20.0 * (double)f, 1.0)));
        }
        double d4 = Math.sqrt(d);
        if (bl && bl2) {
            for (Pair pair : FunctionalUtils.pairs(FunctionalUtils.rangeInclusive(0, list.size() - 1))) {
                int n = (Integer)pair._1;
                int n2 = (Integer)pair._2;
                object = list.get(n);
                PairGroup pairGroup = list.get(n2);
                Vector3D vector3D4 = ((PairGroup)object).position.get().minus(vector3D).normalized();
                Vector3D vector3D5 = pairGroup.position.get().minus(vector3D).normalized();
                Vector3D vector3D6 = JamaUtils.vectorFromMatrix3D(resultMapping.target, n).normalized();
                Vector3D vector3D7 = JamaUtils.vectorFromMatrix3D(resultMapping.target, n2).normalized();
                double d5 = Math.acos(MathUtil.clamp(-1.0, vector3D6.dot(vector3D7), 1.0));
                double d6 = Math.acos(MathUtil.clamp(-1.0, vector3D4.dot(vector3D5), 1.0));
                double d7 = d5 - d6;
                Vector3D vector3D8 = ((PairGroup)object).position.get().minus(pairGroup.position.get()).normalized();
                double d8 = PairGroup.getTimescaleImpulseFactor(f);
                double d9 = MathUtil.clamp(1.0, 3.0 * Math.pow(Math.PI - d6, 2.0) / (Math.PI * Math.PI), 3.0);
                Vector3D vector3D9 = vector3D8.times(d8 * d7 * 3.0 * (d6 < d5 ? 2.0 : 0.5) * d9);
                ((PairGroup)object).addVelocity(vector3D9);
                pairGroup.addVelocity(vector3D9.negated());
            }
        }
        return d4;
    }

    public static ResultMapping findClosestMatchingConfiguration(List<Vector3D> list, List<Vector3D> list2, List<Permutation> list3) {
        int n = list.size();
        Matrix matrix = JamaUtils.matrixFromVectors3D(list);
        Matrix matrix2 = matrix.transpose();
        Property<Object> property = new Property<Object>(null);
        for (Permutation permutation : list3) {
            Matrix matrix3 = JamaUtils.matrixFromVectors3D(permutation.apply(list2));
            Matrix matrix4 = AttractorModel.computeRotationMatrixWithTranspose(matrix3, matrix2);
            Matrix matrix5 = matrix4.times(matrix3);
            double d = 0.0;
            Matrix matrix6 = matrix.minus(matrix5);
            Matrix matrix7 = matrix6.arrayTimes(matrix6);
            for (int i = 0; i < n; ++i) {
                d += matrix7.get(0, i) + matrix7.get(1, i) + matrix7.get(2, i);
            }
            if (property.get() != null && !(d < ((ResultMapping)property.get()).error)) continue;
            property.set(new ResultMapping(d, matrix5, permutation, matrix4));
        }
        return property.get();
    }

    public static List<Vector3D> getOrientationsFromOrigin(List<PairGroup> list) {
        return FunctionalUtils.map(list, new Function1<PairGroup, Vector3D>(){

            @Override
            public Vector3D apply(PairGroup pairGroup) {
                return pairGroup.position.get().normalized();
            }
        });
    }

    private static Matrix computeRotationMatrixWithTranspose(Matrix matrix, Matrix matrix2) {
        Matrix matrix3 = matrix.times(matrix2);
        assert (!Double.isNaN(matrix3.get(0, 0)));
        SingularValueDecomposition singularValueDecomposition = new SingularValueDecomposition(matrix3);
        double d = singularValueDecomposition.getV().times(singularValueDecomposition.getU().transpose()).det();
        return singularValueDecomposition.getV().times(new Matrix(new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, d}}).times(singularValueDecomposition.getU().transpose()));
    }

    public static class ResultMapping {
        public final double error;
        public final Matrix target;
        public final Permutation permutation;
        public final Matrix rotation;

        private ResultMapping(double d, Matrix matrix, Permutation permutation, Matrix matrix2) {
            this.error = d;
            this.target = matrix;
            this.permutation = permutation;
            this.rotation = matrix2;
        }

        public Vector3D rotateVector(Vector3D vector3D) {
            Matrix matrix = JamaUtils.matrixFromVectors3D(Arrays.asList(vector3D));
            Matrix matrix2 = this.rotation.times(matrix);
            return new Vector3D(matrix2.get(0, 0), matrix2.get(1, 0), matrix2.get(2, 0));
        }
    }
}

