/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.lwjglphet.nodes;

import edu.colorado.phet.common.phetcommon.math.Matrix4F;
import edu.colorado.phet.common.phetcommon.math.vector.Vector3F;
import edu.colorado.phet.lwjglphet.GLOptions;
import edu.colorado.phet.lwjglphet.materials.GLMaterial;
import edu.colorado.phet.lwjglphet.math.LWJGLTransform;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.opengl.GL11;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GLNode {
    private GLNode parent = null;
    private final List<GLNode> children = new ArrayList<GLNode>();
    private boolean visible = true;
    private GLOptions.RenderPass renderPass = GLOptions.RenderPass.REGULAR;
    public final LWJGLTransform transform = new LWJGLTransform();
    private GLMaterial material;
    protected int attributeRestorationMask = 0;
    protected int clientAttributeRestorationMask = 0;
    private final List<Integer> glEnableFlags = new ArrayList<Integer>();
    private final List<Integer> glDisableFlags = new ArrayList<Integer>();
    private final List<Integer> glEnableClientFlags = new ArrayList<Integer>();
    private final List<Integer> glDisableClientFlags = new ArrayList<Integer>();

    public final void render(GLOptions gLOptions) {
        if (this.isVisible()) {
            if (!this.transform.isIdentity()) {
                GL11.glPushMatrix();
                this.transform.apply();
            }
            this.preRender(gLOptions);
            if (this.material != null) {
                this.material.before(gLOptions);
            }
            if (this.renderPass == gLOptions.renderPass) {
                this.renderSelf(gLOptions);
            }
            this.renderChildren(gLOptions);
            if (this.material != null) {
                this.material.after(gLOptions);
            }
            this.postRender(gLOptions);
            if (!this.transform.isIdentity()) {
                GL11.glPopMatrix();
            }
        }
    }

    protected void renderChildren(GLOptions gLOptions) {
        for (GLNode gLNode : new ArrayList<GLNode>(this.children)) {
            gLNode.render(gLOptions);
        }
    }

    public void renderSelf(GLOptions gLOptions) {
    }

    public void requireEnabled(int n) {
        this.glEnableFlags.add(n);
        this.addResetForFlag(n);
    }

    public void addResetForFlag(int n) {
        switch (n) {
            case 3008: 
            case 3024: 
            case 3042: 
            case 3073: {
                this.attributeRestorationMask |= 0x2000;
                break;
            }
            case 2883: {
                this.attributeRestorationMask |= 0xB43;
                break;
            }
            case 2832: 
            case 2929: 
            case 2960: 
            case 2977: 
            case 3057: 
            case 3058: 
            case 3089: 
            case 3168: 
            case 3169: 
            case 3170: 
            case 3171: 
            case 3552: 
            case 3553: 
            case 16384: 
            case 16385: 
            case 16386: 
            case 16387: 
            case 16388: 
            case 16389: 
            case 16390: 
            case 16391: {
                this.attributeRestorationMask |= 0x2000;
                break;
            }
            case 3456: 
            case 3472: 
            case 3473: 
            case 3474: 
            case 3475: 
            case 3476: 
            case 3477: 
            case 3478: 
            case 3479: 
            case 3480: 
            case 3504: 
            case 3505: 
            case 3506: 
            case 3507: 
            case 3508: 
            case 3509: 
            case 3510: 
            case 3511: 
            case 3512: 
            case 3536: 
            case 3537: 
            case 3538: 
            case 3539: {
                this.attributeRestorationMask |= 0x12000;
                break;
            }
            case 2912: {
                this.attributeRestorationMask |= 0x2000;
            }
            case 2917: {
                this.attributeRestorationMask |= 0x80;
                break;
            }
            case 3152: 
            case 3153: 
            case 3154: 
            case 3155: 
            case 3156: {
                this.attributeRestorationMask |= 0x8000;
                break;
            }
            case 2896: 
            case 2903: {
                this.attributeRestorationMask |= 0x2000;
                break;
            }
            case 2897: 
            case 2898: 
            case 2900: 
            case 2901: {
                this.attributeRestorationMask |= 0x40;
                break;
            }
            case 2848: 
            case 2852: {
                this.attributeRestorationMask |= 0x2004;
                break;
            }
            case 2866: {
                this.attributeRestorationMask |= 0x20000;
                break;
            }
            case 2881: 
            case 2882: 
            case 2884: 
            case 10753: 
            case 10754: 
            case 32823: {
                this.attributeRestorationMask |= 0x2000;
            }
            case 2880: 
            case 2886: 
            case 10752: 
            case 32824: {
                this.attributeRestorationMask |= 8;
                break;
            }
            default: {
                System.out.println("unknown flag to reset: " + n);
            }
        }
    }

    public void addResetAttrib(int n) {
        this.attributeRestorationMask |= n;
    }

    protected void preRender(GLOptions gLOptions) {
        if (this.attributeRestorationMask != 0) {
            GL11.glPushAttrib(this.attributeRestorationMask);
        }
        if (this.clientAttributeRestorationMask != 0) {
            GL11.glPushClientAttrib(this.clientAttributeRestorationMask);
        }
        for (Integer n : this.glEnableFlags) {
            GL11.glEnable(n);
        }
        for (Integer n : this.glDisableFlags) {
            GL11.glDisable(n);
        }
        for (Integer n : this.glEnableClientFlags) {
            GL11.glEnableClientState(n);
        }
        for (Integer n : this.glDisableClientFlags) {
            GL11.glDisableClientState(n);
        }
    }

    protected void postRender(GLOptions gLOptions) {
        if (this.attributeRestorationMask != 0) {
            GL11.glPopAttrib();
        }
        if (this.clientAttributeRestorationMask != 0) {
            GL11.glPopClientAttrib();
        }
    }

    public List<GLNode> getChildren() {
        return new ArrayList<GLNode>(this.children);
    }

    public void addChild(GLNode gLNode) {
        assert (gLNode != null);
        if (this.isChild(gLNode)) {
            return;
        }
        if (gLNode.parent != null) {
            gLNode.parent.removeChild(gLNode);
        }
        gLNode.parent = this;
        this.children.add(gLNode);
    }

    public void removeChild(GLNode gLNode) {
        boolean bl = this.isChild(gLNode);
        assert (bl);
        if (bl) {
            gLNode.parent = null;
            this.children.remove(gLNode);
        }
    }

    public void detach() {
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
    }

    public boolean isChild(GLNode gLNode) {
        assert (gLNode.parent == this == this.children.contains(gLNode));
        return gLNode.parent == this;
    }

    public void translate(float f, float f2, float f3) {
        this.transform.append(Matrix4F.translation(f, f2, f3));
    }

    public void translate(Vector3F vector3F) {
        this.transform.append(Matrix4F.translation(vector3F));
    }

    public GLNode getParent() {
        return this.parent;
    }

    public void setMaterial(GLMaterial gLMaterial) {
        this.material = gLMaterial;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public void setRenderPass(GLOptions.RenderPass renderPass) {
        this.renderPass = renderPass;
    }

    public LWJGLTransform getTransformRelativeTo(GLNode gLNode) {
        Matrix4F matrix4F = this.transform.getMatrix();
        GLNode gLNode2 = this;
        while (gLNode2 != gLNode) {
            boolean bl;
            GLNode gLNode3 = gLNode2.getParent();
            boolean bl2 = bl = gLNode3 != null;
            if (gLNode != null) assert (bl);
            if (bl) {
                matrix4F = gLNode3.transform.getMatrix().times(matrix4F);
            }
            gLNode2 = gLNode3;
        }
        return new LWJGLTransform(matrix4F);
    }

    public LWJGLTransform getGlobalTransform() {
        return this.getTransformRelativeTo(null);
    }
}

