/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.lwjglphet;

import edu.colorado.phet.lwjglphet.contrib.LWJGLStartupImplementation;
import edu.colorado.phet.lwjglphet.utils.LWJGLUtils;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPopupMenu;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.opengl.Pbuffer;
import org.lwjgl.opengl.PixelFormat;

public class StartupUtils {
    private static final Logger logger = Logger.getLogger(StartupUtils.class.getName());

    public static void setupLibraries() throws IOException {
        boolean bl;
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        if (LWJGLUtils.containsMacJava7Issue()) {
            LWJGLUtils.showMacJava7Warning(null);
        }
        boolean bl2 = bl = System.getProperty("javawebstart.version") != null;
        if (!bl) {
            File file = new File(System.getProperty("java.io.tmpdir"), "phet-lwjgl-libs");
            file.mkdirs();
            String string = file.getAbsolutePath();
            logger.log(Level.INFO, "Extracting native JME3 libraries to: " + string);
            LWJGLStartupImplementation.extractNativeLibs(file, LWJGLStartupImplementation.getPlatform(), false, false);
        }
    }

    public static int getMaximumAntialiasingSamples() {
        int n = 0;
        try {
            Pbuffer pbuffer = new Pbuffer(10, 10, new PixelFormat(24, 8, 24, 8, 0), null);
            pbuffer.makeCurrent();
            boolean bl = GLContext.getCapabilities().GL_ARB_multisample;
            if (bl) {
                n = GL11.glGetInteger(36183);
            }
            pbuffer.destroy();
        }
        catch (LWJGLException lWJGLException) {
            // empty catch block
        }
        return n;
    }
}

