/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.nodes;

import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import edu.colorado.phet.common.piccolophet.RichPNode;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.nodes.kit.ZeroOffsetNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComboBox;
import javax.swing.text.JTextComponent;

public class ControlPanelNode
extends RichPNode {
    private static final Color DEFAULT_BACKGROUND_COLOR = new Color(238, 238, 238);
    private static final Color DEFAULT_BORDER_COLOR = Color.gray;
    private static final BasicStroke DEFAULT_STROKE = new BasicStroke(2.0f);
    protected final PhetPPath background;

    public ControlPanelNode(PNode pNode, Color color, BasicStroke basicStroke, Color color2, int n) {
        this(pNode, color, basicStroke, color2, n, 20, true);
    }

    public ControlPanelNode(final PNode pNode, Color color, BasicStroke basicStroke, Color color2, final int n, final int n2, boolean bl) {
        super(new PNode[0]);
        this.background = new PhetPPath(color, basicStroke, color2){
            {
                super(paint, stroke, paint2);
                PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        PBounds pBounds = ControlPanelNode.this.getControlPanelBounds(pNode);
                        this.setPathTo(new RoundRectangle2D.Double(0.0, 0.0, pBounds.width + (double)(n * 2), pBounds.height + (double)(n * 2), n2, n2));
                    }
                };
                pNode.addPropertyChangeListener("fullBounds", propertyChangeListener);
                propertyChangeListener.propertyChange(null);
            }
        };
        ZeroOffsetNode zeroOffsetNode = new ZeroOffsetNode(pNode){
            {
                super(pNode);
                this.setOffset(n, n);
            }
        };
        this.addChild(this.background);
        this.background.addChild(zeroOffsetNode);
        if (bl) {
            this.transparifySwing(this);
        }
    }

    protected PBounds getControlPanelBounds(PNode pNode) {
        return pNode.getFullBounds();
    }

    private void transparifySwing(PNode pNode) {
        for (int i = 0; i < pNode.getChildrenCount(); ++i) {
            PNode pNode2 = pNode.getChild(i);
            if (pNode2 instanceof PSwing) {
                SwingUtils.setBackgroundDeep(((PSwing)pNode2).getComponent(), new Color(0, 0, 0, 0), new Class[]{JTextComponent.class, JComboBox.class}, false);
            }
            this.transparifySwing(pNode2);
        }
    }
}

