/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.nodes;

import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.simsharing.SimSharingManager;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IParameterKey;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterKeys;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterSet;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserActions;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentTypes;
import edu.colorado.phet.common.phetcommon.util.function.Function1;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.util.DoubleGeneralPath;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.ControlPanelNode;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.nodes.layout.HBox;
import edu.colorado.phet.common.piccolophet.nodes.layout.VBox;
import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PComponent;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComboBoxNode<T>
extends PNode {
    public final Property<T> selectedItem;
    private PNode selectedItemNode;
    private final PNode popup;
    private final ArrayList<PCanvas> listeningTo = new ArrayList();
    final PBasicInputEventHandler dismissPopup = new PBasicInputEventHandler(){

        public void mousePressed(PInputEvent pInputEvent) {
            ComboBoxNode.this.hidePopup();
        }
    };
    private static final Font DEFAULT_FONT = new PhetFont(18);

    public ComboBoxNode(final IUserComponent iUserComponent, final Function1<T, String> function1, List<T> list, T t, final Function1<T, PNode> function12) {
        assert (list.contains(t));
        this.selectedItem = new Property<T>(t);
        PNode[] pNodeArray = new PNode[list.size()];
        double d = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            pNodeArray[i] = function12.apply(list.get(i));
            pNodeArray[i].setPickable(false);
            pNodeArray[i].setChildrenPickable(false);
            d = Math.max(d, pNodeArray[i].getFullBounds().getWidth());
        }
        PNode[] pNodeArray2 = new PNode[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            pNodeArray2[i] = new ListItem<T>(list.get(i), pNodeArray[i], d){
                {
                    super(object, pNode, d);
                    this.addInputEventListener(new PBasicInputEventHandler(){

                        public void mousePressed(PInputEvent pInputEvent) {
                            Object t = this.getItem();
                            SimSharingManager.sendUserMessage(iUserComponent, UserComponentTypes.comboBox, UserActions.selected, ParameterSet.parameterSet((IParameterKey)ParameterKeys.item, (String)function1.apply(t)));
                            ComboBoxNode.this.selectedItem.set(t);
                        }
                    });
                }
            };
        }
        this.popup = new ControlPanelNode((PNode)new VBox(2.0, VBox.LEFT_ALIGNED, pNodeArray2), Color.white, new BasicStroke(1.0f), Color.black, 2, 8, false){
            {
                this.addInputEventListener(new PBasicInputEventHandler(){

                    public void mouseReleased(PInputEvent pInputEvent) {
                        this.setVisible(false);
                    }
                });
                this.setVisible(false);
            }

            public void setVisible(boolean bl) {
                super.setVisible(bl);
                if (bl && !ComboBoxNode.this.getChildrenReference().contains(ComboBoxNode.this.popup)) {
                    ComboBoxNode.this.addChild(ComboBoxNode.this.popup);
                } else if (!bl && ComboBoxNode.this.getChildrenReference().contains(ComboBoxNode.this.popup)) {
                    ComboBoxNode.this.removeChild(ComboBoxNode.this.popup);
                }
                this.setPickable(bl);
                this.setChildrenPickable(bl);
            }
        };
        final double d2 = d;
        this.selectedItem.addObserver(new VoidFunction1<T>(){

            @Override
            public void apply(T t) {
                ComboBoxNode.this.removeChild(ComboBoxNode.this.selectedItemNode);
                ComboBoxNode.this.selectedItemNode = new SelectedItemNode((PNode)function12.apply(ComboBoxNode.this.selectedItem.get()), d2);
                ComboBoxNode.this.addChild(ComboBoxNode.this.selectedItemNode);
            }
        });
        this.popup.setOffset(0.0, this.selectedItemNode.getFullBounds().getHeight() + 2.0);
    }

    private void hidePopup() {
        this.popup.setVisible(false);
        for (PCanvas pCanvas : this.listeningTo) {
            pCanvas.removeInputEventListener(this.dismissPopup);
        }
        this.listeningTo.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ListItem<T>
    extends PNode {
        private final T item;

        public ListItem(T t, PNode pNode, double d) {
            this.item = t;
            final NodeWithBackground nodeWithBackground = new NodeWithBackground(pNode, d);
            final Color color = new Color(84, 226, 243);
            this.addChild(nodeWithBackground);
            this.addInputEventListener(new PBasicInputEventHandler(){

                public void mouseEntered(PInputEvent pInputEvent) {
                    nodeWithBackground.setPaint(color);
                    nodeWithBackground.setStrokePaint(Color.darkGray);
                }

                public void mouseExited(PInputEvent pInputEvent) {
                    nodeWithBackground.setPaint(Color.white);
                    nodeWithBackground.setStrokePaint(null);
                }
            });
            this.addInputEventListener(new CursorHandler());
        }

        public T getItem() {
            return this.item;
        }
    }

    private static class NodeWithBackground
    extends PNode {
        private PhetPPath background;

        public NodeWithBackground(PNode pNode, double d) {
            Color color = Color.white;
            this.background = new PhetPPath((Shape)new Rectangle2D.Double(-2.0, 0.0, d + 2.0 + 2.0, pNode.getFullBounds().getHeight()), color);
            this.background.setStroke(new BasicStroke(1.0f));
            this.background.setStrokePaint(null);
            this.addChild(this.background);
            this.addChild(pNode);
        }

        public void setStrokePaint(Color color) {
            this.background.setStrokePaint(color);
        }

        public void setPaint(Paint paint) {
            super.setPaint(paint);
            this.background.setPaint(paint);
        }
    }

    private class SelectedItemNode
    extends ControlPanelNode {
        public SelectedItemNode(PNode pNode, double d) {
            super((PNode)new HBox(new NodeWithBackground(pNode, d), new TriangleNode()), Color.white, new BasicStroke(1.0f), Color.black, 3, 5, false);
            this.addInputEventListener(new PBasicInputEventHandler(){

                public void mousePressed(final PInputEvent pInputEvent) {
                    ComboBoxNode.this.popup.setVisible(!ComboBoxNode.this.popup.getVisible());
                    if (ComboBoxNode.this.popup.getVisible()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                PComponent pComponent = pInputEvent.getComponent();
                                if (pComponent instanceof PCanvas) {
                                    PCanvas pCanvas = (PCanvas)pComponent;
                                    if (!ComboBoxNode.this.listeningTo.contains(pCanvas)) {
                                        ComboBoxNode.this.listeningTo.add(pCanvas);
                                        pCanvas.addInputEventListener(ComboBoxNode.this.dismissPopup);
                                    }
                                }
                            }
                        });
                    }
                }
            });
            this.addInputEventListener(new CursorHandler());
        }
    }

    private static class TriangleNode
    extends PNode {
        private TriangleNode() {
            this.addChild(new PhetPPath((Shape)new Rectangle2D.Double(0.0, 0.0, 20.0, 20.0), Color.lightGray));
            this.addChild(new PhetPPath((Shape)new DoubleGeneralPath(2.0, 8.0){
                {
                    this.lineToRelative(8.0, 8.0);
                    this.lineToRelative(8.0, -8.0);
                    this.closePath();
                }
            }.getGeneralPath(), Color.darkGray));
        }
    }
}

