/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.math;

import edu.colorado.phet.common.phetcommon.math.PlaneF;
import edu.colorado.phet.common.phetcommon.math.Ray3F;
import edu.colorado.phet.common.phetcommon.math.vector.Vector3F;
import edu.colorado.phet.common.phetcommon.util.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Triangle3F {
    public final Vector3F a;
    public final Vector3F b;
    public final Vector3F c;

    public Triangle3F(Vector3F vector3F, Vector3F vector3F2, Vector3F vector3F3) {
        this.a = vector3F;
        this.b = vector3F2;
        this.c = vector3F3;
    }

    public PlaneF getPlane() {
        return PlaneF.fromTriangle(this.a, this.b, this.c);
    }

    public Option<TriangleIntersectionResult> intersectWith(Ray3F ray3F) {
        boolean bl;
        PlaneF planeF = this.getPlane();
        if (planeF == null) {
            return new Option.None<TriangleIntersectionResult>();
        }
        Vector3F vector3F = planeF.intersectWithRay(ray3F);
        Vector3F vector3F2 = this.c.minus(this.a);
        Vector3F vector3F3 = this.b.minus(this.a);
        Vector3F vector3F4 = vector3F.minus(this.a);
        float f = vector3F2.dot(vector3F2);
        float f2 = vector3F2.dot(vector3F3);
        float f3 = vector3F2.dot(vector3F4);
        float f4 = vector3F3.dot(vector3F3);
        float f5 = vector3F3.dot(vector3F4);
        float f6 = 1.0f / (f * f4 - f2 * f2);
        float f7 = (f4 * f3 - f2 * f5) * f6;
        float f8 = (f * f5 - f2 * f3) * f6;
        boolean bl2 = bl = f7 >= 0.0f && f8 >= 0.0f && f7 + f8 <= 1.0f;
        if (bl) {
            return new Option.Some<TriangleIntersectionResult>(new TriangleIntersectionResult(vector3F, planeF.normal.dot(ray3F.dir) > 0.0f ? planeF.normal.negated() : planeF.normal));
        }
        return new Option.None<TriangleIntersectionResult>();
    }

    public static class TriangleIntersectionResult {
        public final Vector3F point;
        public final Vector3F normal;

        public TriangleIntersectionResult(Vector3F vector3F, Vector3F vector3F2) {
            this.point = vector3F;
            this.normal = vector3F2;
        }
    }
}

