/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.math;

import edu.colorado.phet.common.phetcommon.math.Matrix3F;
import edu.colorado.phet.common.phetcommon.math.vector.Vector3F;

public class QuaternionF {
    public final float x;
    public final float y;
    public final float z;
    public final float w;

    public QuaternionF() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
        this.w = 1.0f;
    }

    public QuaternionF(float f, float f2, float f3, float f4) {
        this.x = f;
        this.y = f2;
        this.z = f3;
        this.w = f4;
    }

    public QuaternionF times(QuaternionF quaternionF) {
        return new QuaternionF(this.x * quaternionF.w - this.z * quaternionF.y + this.y * quaternionF.z + this.w * quaternionF.x, -this.x * quaternionF.z + this.y * quaternionF.w + this.z * quaternionF.x + this.w * quaternionF.y, this.x * quaternionF.y - this.y * quaternionF.x + this.z * quaternionF.w + this.w * quaternionF.z, -this.x * quaternionF.x - this.y * quaternionF.y - this.z * quaternionF.z + this.w * quaternionF.w);
    }

    public Vector3F times(Vector3F vector3F) {
        if (vector3F.magnitude() == 0.0f) {
            return new Vector3F();
        }
        return new Vector3F(this.w * this.w * vector3F.x + 2.0f * this.y * this.w * vector3F.z - 2.0f * this.z * this.w * vector3F.y + this.x * this.x * vector3F.x + 2.0f * this.y * this.x * vector3F.y + 2.0f * this.z * this.x * vector3F.z - this.z * this.z * vector3F.x - this.y * this.y * vector3F.x, 2.0f * this.x * this.y * vector3F.x + this.y * this.y * vector3F.y + 2.0f * this.z * this.y * vector3F.z + 2.0f * this.w * this.z * vector3F.x - this.z * this.z * vector3F.y + this.w * this.w * vector3F.y - 2.0f * this.x * this.w * vector3F.z - this.x * this.x * vector3F.y, 2.0f * this.x * this.z * vector3F.x + 2.0f * this.y * this.z * vector3F.y + this.z * this.z * vector3F.z - 2.0f * this.w * this.y * vector3F.x - this.y * this.y * vector3F.z + 2.0f * this.w * this.x * vector3F.y - this.x * this.x * vector3F.z + this.w * this.w * vector3F.z);
    }

    public float magnitudeSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
    }

    public QuaternionF negated() {
        return new QuaternionF(-this.x, -this.y, -this.z, -this.w);
    }

    public static QuaternionF fromEulerAngles(float f, float f2, float f3) {
        float f4 = (float)Math.sin(f3 * 0.5f);
        float f5 = (float)Math.cos(f3 * 0.5f);
        float f6 = (float)Math.sin(f2 * 0.5f);
        float f7 = (float)Math.cos(f2 * 0.5f);
        float f8 = (float)Math.sin(f * 0.5f);
        float f9 = (float)Math.cos(f * 0.5f);
        float f10 = f7 * f5;
        float f11 = f6 * f4;
        float f12 = f7 * f4;
        float f13 = f6 * f5;
        return new QuaternionF(f10 * f8 + f11 * f9, f13 * f9 + f12 * f8, f12 * f9 - f13 * f8, f10 * f9 - f11 * f8);
    }

    public Matrix3F toRotationMatrix() {
        float f = this.magnitudeSquared();
        float f2 = f == 1.0f ? 2.0f : (f > 0.0f ? 2.0f / f : 0.0f);
        float f3 = this.x * this.x * f2;
        float f4 = this.x * this.y * f2;
        float f5 = this.x * this.z * f2;
        float f6 = this.w * this.x * f2;
        float f7 = this.y * this.y * f2;
        float f8 = this.y * this.z * f2;
        float f9 = this.w * this.y * f2;
        float f10 = this.z * this.z * f2;
        float f11 = this.w * this.z * f2;
        return Matrix3F.columnMajor(1.0f - (f7 + f10), f4 + f11, f5 - f9, f4 - f11, 1.0f - (f3 + f10), f8 + f6, f5 + f9, f8 - f6, 1.0f - (f3 + f7));
    }

    public static QuaternionF fromRotationMatrix(Matrix3F matrix3F) {
        float f = matrix3F.v00;
        float f2 = matrix3F.v01;
        float f3 = matrix3F.v02;
        float f4 = matrix3F.v10;
        float f5 = matrix3F.v11;
        float f6 = matrix3F.v12;
        float f7 = matrix3F.v20;
        float f8 = matrix3F.v21;
        float f9 = matrix3F.v22;
        float f10 = f + f5 + f9;
        if (f10 >= 0.0f) {
            float f11 = (float)Math.sqrt(f10 + 1.0f);
            return new QuaternionF((f8 - f6) * 0.5f / f11, (f3 - f7) * 0.5f / f11, (f4 - f2) * 0.5f / f11, 0.5f * f11);
        }
        if (f > f5 && f > f9) {
            float f12 = (float)Math.sqrt(1.0f + f - f5 - f9);
            return new QuaternionF(f12 * 0.5f, (f4 + f2) * 0.5f / f12, (f3 + f7) * 0.5f / f12, (f8 - f6) * 0.5f / f12);
        }
        if (f5 > f9) {
            float f13 = (float)Math.sqrt(1.0f + f5 - f - f9);
            return new QuaternionF((f4 + f2) * 0.5f / f13, f13 * 0.5f, (f8 + f6) * 0.5f / f13, (f3 - f7) * 0.5f / f13);
        }
        float f14 = (float)Math.sqrt(1.0f + f9 - f - f5);
        return new QuaternionF((f3 + f7) * 0.5f / f14, (f8 + f6) * 0.5f / f14, f14 * 0.5f, (f4 - f2) * 0.5f / f14);
    }

    public static QuaternionF getRotationQuaternion(Vector3F vector3F, Vector3F vector3F2) {
        return QuaternionF.fromRotationMatrix(Matrix3F.rotateAToB(vector3F, vector3F2));
    }

    public static QuaternionF slerp(QuaternionF quaternionF, QuaternionF quaternionF2, float f) {
        if (quaternionF.x == quaternionF2.x && quaternionF.y == quaternionF2.y && quaternionF.z == quaternionF2.z && quaternionF.w == quaternionF2.w) {
            return quaternionF;
        }
        float f2 = quaternionF.x * quaternionF2.x + quaternionF.y * quaternionF2.y + quaternionF.z * quaternionF2.z + quaternionF.w * quaternionF2.w;
        if (f2 < 0.0f) {
            quaternionF2 = quaternionF2.negated();
            f2 = -f2;
        }
        float f3 = 1.0f - f;
        float f4 = f;
        if (1.0f - f2 > 0.1f) {
            float f5 = (float)Math.acos(f2);
            float f6 = (float)(1.0 / Math.sin(f5));
            f3 = (float)(Math.sin((1.0f - f) * f5) * (double)f6);
            f4 = (float)(Math.sin(f * f5) * (double)f6);
        }
        return new QuaternionF(f3 * quaternionF.x + f4 * quaternionF2.x, f3 * quaternionF.y + f4 * quaternionF2.y, f3 * quaternionF.z + f4 * quaternionF2.z, f3 * quaternionF.w + f4 * quaternionF2.w);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof QuaternionF)) {
            return false;
        }
        QuaternionF quaternionF = (QuaternionF)object;
        if (!quaternionF.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.x, quaternionF.x) != 0) {
            return false;
        }
        if (Float.compare(this.y, quaternionF.y) != 0) {
            return false;
        }
        if (Float.compare(this.z, quaternionF.z) != 0) {
            return false;
        }
        return Float.compare(this.w, quaternionF.w) == 0;
    }

    public boolean canEqual(Object object) {
        return object instanceof QuaternionF;
    }

    public int hashCode() {
        int n = 1;
        n = n * 31 + Float.floatToIntBits(this.x);
        n = n * 31 + Float.floatToIntBits(this.y);
        n = n * 31 + Float.floatToIntBits(this.z);
        n = n * 31 + Float.floatToIntBits(this.w);
        return n;
    }

    public String toString() {
        return "QuaternionF(x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", w=" + this.w + ")";
    }
}

