/*
 * Decompiled with CFR 0.152.
 */
package Jama;

import Jama.Matrix;
import java.io.Serializable;

public class LUDecomposition
implements Serializable {
    private double[][] LU;
    private int m;
    private int n;
    private int pivsign;
    private int[] piv;

    public LUDecomposition(Matrix matrix) {
        this.LU = matrix.getArrayCopy();
        this.m = matrix.getRowDimension();
        this.n = matrix.getColumnDimension();
        this.piv = new int[this.m];
        for (int i = 0; i < this.m; ++i) {
            this.piv[i] = i;
        }
        this.pivsign = 1;
        double[] dArray = new double[this.m];
        for (int i = 0; i < this.n; ++i) {
            double d;
            int n;
            int n2;
            for (n2 = 0; n2 < this.m; ++n2) {
                dArray[n2] = this.LU[n2][i];
            }
            n2 = 0;
            while (n2 < this.m) {
                double[] dArray2 = this.LU[n2];
                n = Math.min(n2, i);
                d = 0.0;
                for (int j = 0; j < n; ++j) {
                    d += dArray2[j] * dArray[j];
                }
                int n3 = n2++;
                double d2 = dArray[n3] - d;
                dArray[n3] = d2;
                dArray2[i] = d2;
            }
            n2 = i;
            for (n = i + 1; n < this.m; ++n) {
                if (!(Math.abs(dArray[n]) > Math.abs(dArray[n2]))) continue;
                n2 = n;
            }
            if (n2 != i) {
                for (n = 0; n < this.n; ++n) {
                    d = this.LU[n2][n];
                    this.LU[n2][n] = this.LU[i][n];
                    this.LU[i][n] = d;
                }
                n = this.piv[n2];
                this.piv[n2] = this.piv[i];
                this.piv[i] = n;
                this.pivsign = -this.pivsign;
            }
            if (!(i < this.m & this.LU[i][i] != 0.0)) continue;
            for (n = i + 1; n < this.m; ++n) {
                double[] dArray3 = this.LU[n];
                int n4 = i;
                dArray3[n4] = dArray3[n4] / this.LU[i][i];
            }
        }
    }

    public double det() {
        if (this.m != this.n) {
            throw new IllegalArgumentException("Matrix must be square.");
        }
        double d = this.pivsign;
        for (int i = 0; i < this.n; ++i) {
            d *= this.LU[i][i];
        }
        return d;
    }
}

