/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.microwaves.view.graphics.splines;

import edu.colorado.phet.microwaves.view.graphics.splines.ControlCurve;
import java.awt.Graphics;
import java.awt.Polygon;

public class CubicSpline
extends ControlCurve {
    final int STEPS = 12;

    Cubic[] calcNaturalCubic(int n, int[] nArray) {
        int n2;
        float[] fArray = new float[n + 1];
        float[] fArray2 = new float[n + 1];
        float[] fArray3 = new float[n + 1];
        fArray[0] = 0.5f;
        for (n2 = 1; n2 < n; ++n2) {
            fArray[n2] = 1.0f / (4.0f - fArray[n2 - 1]);
        }
        fArray[n] = 1.0f / (2.0f - fArray[n - 1]);
        fArray2[0] = (float)(3 * (nArray[1] - nArray[0])) * fArray[0];
        for (n2 = 1; n2 < n; ++n2) {
            fArray2[n2] = ((float)(3 * (nArray[n2 + 1] - nArray[n2 - 1])) - fArray2[n2 - 1]) * fArray[n2];
        }
        fArray2[n] = ((float)(3 * (nArray[n] - nArray[n - 1])) - fArray2[n - 1]) * fArray[n];
        fArray3[n] = fArray2[n];
        for (n2 = n - 1; n2 >= 0; --n2) {
            fArray3[n2] = fArray2[n2] - fArray[n2] * fArray3[n2 + 1];
        }
        Cubic[] cubicArray = new Cubic[n];
        for (n2 = 0; n2 < n; ++n2) {
            cubicArray[n2] = new Cubic(nArray[n2], fArray3[n2], (float)(3 * (nArray[n2 + 1] - nArray[n2])) - 2.0f * fArray3[n2] - fArray3[n2 + 1], (float)(2 * (nArray[n2] - nArray[n2 + 1])) + fArray3[n2] + fArray3[n2 + 1]);
        }
        return cubicArray;
    }

    public void paint(Graphics graphics) {
        if (this.pts.npoints >= 2) {
            Cubic[] cubicArray = this.calcNaturalCubic(this.pts.npoints - 1, this.pts.xpoints);
            Cubic[] cubicArray2 = this.calcNaturalCubic(this.pts.npoints - 1, this.pts.ypoints);
            Polygon polygon = new Polygon();
            polygon.addPoint(Math.round(cubicArray[0].eval(0.0f)), Math.round(cubicArray2[0].eval(0.0f)));
            for (int i = 0; i < cubicArray.length; ++i) {
                for (int j = 1; j <= 12; ++j) {
                    float f = (float)j / 12.0f;
                    polygon.addPoint(Math.round(cubicArray[i].eval(f)), Math.round(cubicArray2[i].eval(f)));
                }
            }
            graphics.drawPolyline(polygon.xpoints, polygon.ypoints, polygon.npoints);
        }
    }

    public class Cubic {
        float a;
        float b;
        float c;
        float d;

        public Cubic(float f, float f2, float f3, float f4) {
            this.a = f;
            this.b = f2;
            this.c = f3;
            this.d = f4;
        }

        public float eval(float f) {
            return ((this.d * f + this.c) * f + this.b) * f + this.a;
        }
    }
}

