/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.microwaves.view;

import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import edu.colorado.phet.microwaves.CoffeeModule;
import edu.colorado.phet.microwaves.MicrowaveModule;
import edu.colorado.phet.microwaves.MicrowavesResources;
import edu.colorado.phet.microwaves.model.MicrowavesModel;
import java.awt.AWTException;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;

public class CoffeeControlPanel
extends JPanel {
    private static double DEFAULT_FREQUENCY = 0.002;
    private static double DEFAULT_AMPLITUDE = 0.33;
    MicrowavesModel model;
    MicrowaveModule module;
    private JRadioButton noFieldViewRB;
    private JRadioButton fullViewRB;
    private JRadioButton singleViewRB;
    private ButtonGroup fieldViewBtnGrp;
    private JRadioButton splineViewRB;
    private JRadioButton pct100RB;
    private JRadioButton pct75RB;
    private JRadioButton pct50RB;
    private JRadioButton pct25RB;
    private ButtonGroup powerBtnGrp;
    private ActionListener fieldViewActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            CoffeeControlPanel.this.setFieldView();
        }
    };
    private ActionListener powerBtnActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            CoffeeControlPanel.this.setPowerLevel();
        }
    };

    public CoffeeControlPanel(MicrowaveModule microwaveModule, MicrowavesModel microwavesModel) {
        this.module = microwaveModule;
        this.model = microwavesModel;
        this.layoutPanel();
    }

    private void layoutPanel() {
        this.module.setMicrowaveFrequency(DEFAULT_FREQUENCY);
        this.module.setMicrowaveAmplitude(DEFAULT_AMPLITUDE);
        JButton jButton = new JButton(MicrowavesResources.getString("CoffeeControlPanel.StartStopButton"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CoffeeControlPanel.this.module.toggleMicrowave();
            }
        });
        this.powerBtnGrp = new ButtonGroup();
        this.pct100RB = new JRadioButton(MicrowavesResources.getString("CoffeeControlPanel.FullPowerRadioButton"));
        this.pct100RB.addActionListener(this.powerBtnActionListener);
        this.powerBtnGrp.add(this.pct100RB);
        this.pct75RB = new JRadioButton(MicrowavesResources.getString("CoffeeControlPanel.ThreeQuarterPowerRadioButton"));
        this.pct75RB.addActionListener(this.powerBtnActionListener);
        this.powerBtnGrp.add(this.pct75RB);
        this.pct50RB = new JRadioButton(MicrowavesResources.getString("CoffeeControlPanel.HalfPowerRadioButton"));
        this.pct50RB.addActionListener(this.powerBtnActionListener);
        this.powerBtnGrp.add(this.pct50RB);
        this.pct25RB = new JRadioButton(MicrowavesResources.getString("CoffeeControlPanel.QuarterPowerRadioButton"));
        this.pct25RB.addActionListener(this.powerBtnActionListener);
        this.powerBtnGrp.add(this.pct25RB);
        JPanel jPanel = new JPanel(new GridBagLayout());
        int n = 0;
        try {
            SwingUtils.addGridBagComponent(jPanel, this.pct100RB, 0, n++, 1, 1, 2, 10);
            SwingUtils.addGridBagComponent(jPanel, this.pct75RB, 0, n++, 1, 1, 2, 10);
            SwingUtils.addGridBagComponent(jPanel, this.pct50RB, 0, n++, 1, 1, 2, 10);
            SwingUtils.addGridBagComponent(jPanel, this.pct25RB, 0, n++, 1, 1, 2, 10);
        }
        catch (AWTException aWTException) {
            aWTException.printStackTrace();
        }
        jPanel.setBorder(BorderFactory.createTitledBorder(MicrowavesResources.getString("CoffeeControlPanel.PowerBorderTitle")));
        this.noFieldViewRB = new JRadioButton(MicrowavesResources.getString("CoffeeControlPanel.NoneRadioButton"));
        this.noFieldViewRB.addActionListener(this.fieldViewActionListener);
        this.fullViewRB = new JRadioButton(MicrowavesResources.getString("CoffeeControlPanel.FullFieldRadioButton"));
        this.fullViewRB.addActionListener(this.fieldViewActionListener);
        this.singleViewRB = new JRadioButton(MicrowavesResources.getString("CoffeeControlPanel.SingleLineRadioButton"));
        this.singleViewRB.addActionListener(this.fieldViewActionListener);
        this.splineViewRB = new JRadioButton(MicrowavesResources.getString("CoffeeControlPanel.CurveRadioButton"));
        this.splineViewRB.addActionListener(this.fieldViewActionListener);
        this.fieldViewBtnGrp = new ButtonGroup();
        this.fieldViewBtnGrp.add(this.fullViewRB);
        this.fieldViewBtnGrp.add(this.singleViewRB);
        this.fieldViewBtnGrp.add(this.splineViewRB);
        this.fieldViewBtnGrp.add(this.noFieldViewRB);
        this.fieldViewActionListener.actionPerformed(null);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        int n2 = 0;
        try {
            SwingUtils.addGridBagComponent(jPanel2, this.splineViewRB, 0, n2++, 1, 1, 2, 10);
            SwingUtils.addGridBagComponent(jPanel2, this.singleViewRB, 0, n2++, 1, 1, 2, 10);
            SwingUtils.addGridBagComponent(jPanel2, this.fullViewRB, 0, n2++, 1, 1, 2, 10);
            SwingUtils.addGridBagComponent(jPanel2, this.noFieldViewRB, 0, n2++, 1, 1, 2, 10);
        }
        catch (AWTException aWTException) {
            aWTException.printStackTrace();
        }
        jPanel2.setBorder(BorderFactory.createTitledBorder(MicrowavesResources.getString("CoffeeControlPanel.FieldViewBorderTitle")));
        JButton jButton2 = new JButton(MicrowavesResources.getString("CoffeeControlPanel.ResetButton"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CoffeeControlPanel.this.module.reset();
            }
        });
        this.setPreferredSize(new Dimension(150, 400));
        EmptyBorder emptyBorder = (EmptyBorder)BorderFactory.createEmptyBorder();
        this.setBorder(emptyBorder);
        this.setLayout(new GridBagLayout());
        int n3 = 0;
        try {
            SwingUtils.addGridBagComponent(this, jButton, 0, n3++, 1, 1, 0, 10);
            SwingUtils.addGridBagComponent(this, jPanel, 0, n3++, 1, 1, 2, 10);
            SwingUtils.addGridBagComponent(this, jPanel2, 0, n3++, 1, 1, 2, 10);
            SwingUtils.addGridBagComponent(this, jButton2, 0, n3++, 1, 1, 0, 10);
        }
        catch (AWTException aWTException) {
            aWTException.printStackTrace();
        }
        this.reset();
    }

    private void setFieldView() {
        JRadioButton jRadioButton = SwingUtils.getSelection(this.fieldViewBtnGrp);
        if (jRadioButton == this.noFieldViewRB) {
            this.module.setFieldViewOff();
        }
        if (jRadioButton == this.fullViewRB) {
            this.module.setFieldViewFull();
        }
        if (jRadioButton == this.singleViewRB) {
            this.module.setFieldViewSingle();
        }
        if (jRadioButton == this.splineViewRB) {
            this.module.setFieldViewSingle();
            this.module.setFiledViewSpline();
        }
    }

    private void setPowerLevel() {
        JRadioButton jRadioButton = SwingUtils.getSelection(this.powerBtnGrp);
        if (jRadioButton == this.pct100RB) {
            ((CoffeeModule)this.module).setPowerLevel(1.0);
        }
        if (jRadioButton == this.pct75RB) {
            ((CoffeeModule)this.module).setPowerLevel(0.75);
        }
        if (jRadioButton == this.pct50RB) {
            ((CoffeeModule)this.module).setPowerLevel(0.5);
        }
        if (jRadioButton == this.pct25RB) {
            ((CoffeeModule)this.module).setPowerLevel(0.25);
        }
    }

    public void reset() {
        this.splineViewRB.setSelected(true);
        this.setFieldView();
        this.pct100RB.setSelected(true);
        this.setPowerLevel();
    }
}

