/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.microwaves.model;

import edu.colorado.phet.microwaves.coreadditions.Body;
import edu.colorado.phet.microwaves.coreadditions.Vector2D;
import edu.colorado.phet.microwaves.coreadditions.Vector3D;
import edu.colorado.phet.microwaves.coreadditions.collision.Box2D;
import edu.colorado.phet.microwaves.model.Lobe;
import edu.colorado.phet.microwaves.model.WaterMolecule;
import java.awt.geom.Point2D;

public class WaterMoleculeWallCollisionExpert {
    private static Vector2D loa = new Vector2D();
    private static Point2D.Double collisionPt;
    private static Vector2D n;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean areInContact(Body body, Body body2) {
        WaterMolecule waterMolecule;
        Box2D box2D = null;
        if (body instanceof Box2D) {
            box2D = (Box2D)body;
            if (!(body2 instanceof WaterMolecule)) throw new RuntimeException("bad args");
            waterMolecule = (WaterMolecule)body2;
        } else {
            if (!(body2 instanceof Box2D)) throw new RuntimeException("bad args");
            box2D = (Box2D)body2;
            if (!(body instanceof WaterMolecule)) throw new RuntimeException("bad args");
            waterMolecule = (WaterMolecule)body;
        }
        double d = waterMolecule.getKineticEnergy() + body2.getKineticEnergy();
        Lobe[] lobeArray = waterMolecule.getLobes();
        for (int i = 0; i < lobeArray.length; ++i) {
            Lobe lobe = lobeArray[i];
            double d2 = lobe.getCenterX() - lobe.getRadius() - box2D.getMinX();
            if (d2 <= 0.0 && waterMolecule.getVelocity().getX() < 0.0f) {
                loa.setComponents(1.0f, 0.0f);
                collisionPt = new Point2D.Double(lobe.getCenterX() - lobe.getRadius(), lobe.getCenterY());
                WaterMoleculeWallCollisionExpert.doCollision(waterMolecule, box2D.getWalls()[0], loa, collisionPt);
                Point2D.Double double_ = waterMolecule.getLocation();
                double_.setLocation(double_.getX() - d2, double_.getY());
                waterMolecule.setLocation(double_.getX(), double_.getY());
                return false;
            }
            d2 = lobe.getCenterX() + lobe.getRadius() - box2D.getMaxX();
            if (d2 >= 0.0 && waterMolecule.getVelocity().getX() > 0.0f) {
                loa.setComponents(1.0f, 0.0f);
                collisionPt = new Point2D.Double(lobe.getCenterX() + lobe.getRadius(), lobe.getCenterY());
                WaterMoleculeWallCollisionExpert.doCollision(waterMolecule, box2D.getWalls()[1], loa, collisionPt);
                Point2D.Double double_ = waterMolecule.getLocation();
                double_.setLocation(double_.getX() - d2, double_.getY());
                waterMolecule.setLocation(double_.getX(), double_.getY());
                return false;
            }
            double d3 = lobe.getCenterY() - lobe.getRadius() - box2D.getMinY();
            if (d3 <= 0.0 && waterMolecule.getVelocity().getY() < 0.0f) {
                loa.setComponents(0.0f, 1.0f);
                collisionPt = new Point2D.Double(lobe.getCenterX(), lobe.getCenterY() - lobe.getRadius());
                WaterMoleculeWallCollisionExpert.doCollision(waterMolecule, box2D.getWalls()[2], loa, collisionPt);
                Point2D.Double double_ = waterMolecule.getLocation();
                double_.setLocation(double_.getX(), double_.getY() - d3);
                waterMolecule.setLocation(double_.getX(), double_.getY());
                return false;
            }
            d3 = lobe.getCenterY() + lobe.getRadius() - box2D.getMaxY();
            if (!(d3 >= 0.0) || !(waterMolecule.getVelocity().getY() > 0.0f)) continue;
            loa.setComponents(0.0f, 1.0f);
            collisionPt = new Point2D.Double(lobe.getCenterX(), lobe.getCenterY() + lobe.getRadius());
            WaterMoleculeWallCollisionExpert.doCollision(waterMolecule, box2D.getWalls()[3], loa, collisionPt);
            Point2D.Double double_ = waterMolecule.getLocation();
            double_.setLocation(double_.getX(), double_.getY() - d3);
            waterMolecule.setLocation(double_.getX(), double_.getY());
            return false;
        }
        return false;
    }

    public static void doCollision(Body body, Body body2, Vector2D vector2D, Point2D.Double double_) {
        double d = body.getKineticEnergy();
        Vector2D vector2D2 = new Vector2D((float)(double_.getX() - body.getLocation().getX()), (float)(double_.getY() - body.getLocation().getY()));
        n.setComponents(vector2D).normalize();
        Vector3D vector3D = new Vector3D(0.0f, 0.0f, (float)body.getOmega());
        Vector3D vector3D2 = vector3D.crossProduct(new Vector3D(vector2D2)).add(new Vector3D(body.getVelocity()));
        float f = vector3D2.dot(new Vector3D(n));
        float f2 = 1.0f;
        float f3 = -f * (1.0f + f2);
        Vector3D vector3D3 = new Vector3D(n);
        Vector3D vector3D4 = new Vector3D(vector2D2);
        Vector3D vector3D5 = vector3D4.crossProduct(vector3D3).multiply((float)(1.0 / body.getMomentOfInertia()));
        Vector3D vector3D6 = vector3D5.crossProduct(vector3D5);
        float f4 = vector3D3.dot(vector3D6);
        double d2 = 1.0 / body.getMass() + (double)f4;
        d2 = 1.0 / body.getMass() + (double)vector3D3.dot(vector3D4.crossProduct(vector3D3).multiply(1.0f / (float)body.getMomentOfInertia()).crossProduct(vector3D4));
        double d3 = (double)f3 / d2;
        body.getVelocity().add(new Vector2D(n).multiply((float)(d3 / body.getMass())));
        double d4 = body.getMomentOfInertia();
        Vector3D vector3D7 = new Vector3D(n).multiply((float)d3);
        double d5 = body.getOmega() + (double)vector3D4.crossProduct(vector3D7).getZ() / body.getMomentOfInertia();
        body.setOmega(body.getOmega() + (double)(vector2D2.getX() * n.getY() - vector2D2.getY() * n.getX()) * d3 / body.getMomentOfInertia());
    }

    static {
        n = new Vector2D();
    }
}

