/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.microwaves;

import edu.colorado.phet.microwaves.MicrowaveModule;
import edu.colorado.phet.microwaves.MicrowavesResources;
import edu.colorado.phet.microwaves.coreadditions.collision.Box2D;
import edu.colorado.phet.microwaves.model.WaterMolecule;
import edu.colorado.phet.microwaves.view.WaterMoleculeGraphic;

public class ManyMoleculesModule
extends MicrowaveModule {
    public ManyMoleculesModule() {
        super(MicrowavesResources.getString("ModuleTitle.ManyMoleculesModule"));
    }

    protected void init() {
        super.init();
        WaterMolecule[] waterMoleculeArray = new WaterMolecule[20];
        Box2D box2D = this.getMicrowaveModel().getOven();
        for (int i = 0; i < 20; ++i) {
            WaterMolecule waterMolecule = new WaterMolecule();
            double d = -1.0;
            while (d < box2D.getMinX() + 20.0 + 20.0 || d > box2D.getMaxX() - 40.0) {
                d = Math.random() * box2D.getMaxX();
            }
            double d2 = -1.0;
            while (d2 < box2D.getMinY() + 20.0 + 20.0 || d2 > box2D.getMaxY() - 40.0) {
                d2 = Math.random() * box2D.getMaxY();
            }
            waterMolecule.setLocation(d, d2);
            waterMoleculeArray[i] = waterMolecule;
            waterMolecule.setDipoleOrientation(Math.random() * Math.PI * 2.0);
            this.getMicrowaveModel().addPolarBody(waterMolecule);
            WaterMoleculeGraphic waterMoleculeGraphic = new WaterMoleculeGraphic(waterMolecule, this.getModelViewTransform());
            this.getApparatusPanel().addGraphic(waterMoleculeGraphic, 5.0);
        }
    }
}

