/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas.model;

import edu.colorado.phet.common.phetcommon.util.EventChannel;
import edu.colorado.phet.idealgas.model.Box2D;
import edu.colorado.phet.idealgas.model.IdealGasClock;
import edu.colorado.phet.idealgas.model.IdealGasModel;
import edu.colorado.phet.idealgas.model.PressureSlice;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventObject;
import java.util.List;

public class PressureSensingBox
extends Box2D {
    private List averagingSlices = new ArrayList();
    private PressureSlice gaugeSlice;
    private boolean multipleSlicesEnabled;
    private double lastPressure = 0.0;
    private EventChannel changeEventChannel = new EventChannel(ChangeListener.class);
    private ChangeListener changeListenerProxy = (ChangeListener)this.changeEventChannel.getListenerProxy();

    public PressureSensingBox(Point2D point2D, Point2D point2D2, IdealGasModel idealGasModel, IdealGasClock idealGasClock) {
        super(point2D, point2D2, idealGasModel);
        int n = 5;
        for (int i = 0; i < n; ++i) {
            PressureSlice pressureSlice = new PressureSlice(this, idealGasModel, idealGasClock);
            pressureSlice.setY(this.getMinY() + this.getHeight() / (double)(n + 1) * (double)(i + 1));
            pressureSlice.setTimeAveragingWindow(2500.0 * (idealGasClock.getDt() / (double)idealGasClock.getDelay()));
            pressureSlice.setUpdateContinuously(true);
            idealGasModel.addModelElement(pressureSlice);
            this.averagingSlices.add(pressureSlice);
        }
        this.setTimeAveragingWindow(idealGasClock.getDt() * 100.0);
    }

    public void setTimeAveragingWindow(double d) {
        for (int i = 0; i < this.averagingSlices.size(); ++i) {
            PressureSlice pressureSlice = (PressureSlice)this.averagingSlices.get(i);
            pressureSlice.setTimeAveragingWindow(d);
        }
        if (this.gaugeSlice != null) {
            this.gaugeSlice.setTimeAveragingWindow(d);
        }
    }

    public void setMultipleSlicesEnabled(boolean bl) {
        this.multipleSlicesEnabled = bl;
        this.changeListenerProxy.stateChanged(new ChangeEvent(this));
    }

    public boolean getMultipleSlicesEnabled() {
        return this.multipleSlicesEnabled;
    }

    public double getPressure() {
        if (this.multipleSlicesEnabled) {
            double d = 0.0;
            for (int i = 0; i < this.averagingSlices.size(); ++i) {
                PressureSlice pressureSlice = (PressureSlice)this.averagingSlices.get(i);
                d += pressureSlice.getPressure();
            }
            return d / (double)this.averagingSlices.size();
        }
        return this.gaugeSlice.getPressure();
    }

    public boolean isPressureSafe() {
        return this.getPressure() <= 6.0;
    }

    public void setGaugeSlice(PressureSlice pressureSlice) {
        this.gaugeSlice = pressureSlice;
    }

    public void stepInTime(double d) {
        super.stepInTime(d);
        if (this.lastPressure != this.getPressure()) {
            this.lastPressure = this.getPressure();
            this.changeListenerProxy.stateChanged(new ChangeEvent(this));
        }
    }

    public void clearData() {
        this.gaugeSlice.clear();
        for (int i = 0; i < this.averagingSlices.size(); ++i) {
            ((PressureSlice)this.averagingSlices.get(i)).clear();
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeEventChannel.addListener(changeListener);
    }

    public class ChangeEvent
    extends EventObject {
        public ChangeEvent(Object object) {
            super(object);
        }

        public PressureSensingBox getPressureSensingBox() {
            return (PressureSensingBox)this.getSource();
        }
    }

    public static interface ChangeListener
    extends EventListener {
        public void stateChanged(ChangeEvent var1);
    }
}

