/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.model.components;

import edu.colorado.phet.circuitconstructionkit.model.CircuitChangeListener;
import edu.colorado.phet.circuitconstructionkit.model.Junction;
import edu.colorado.phet.circuitconstructionkit.model.components.CircuitComponent;

public class Battery
extends CircuitComponent {
    private double internalResistance;
    private boolean internalResistanceOn;

    public Battery(CircuitChangeListener circuitChangeListener, Junction junction, Junction junction2, double d, double d2, double d3, boolean bl) {
        super(circuitChangeListener, junction, junction2, d, d2);
        this.setKirkhoffEnabled(false);
        this.setVoltageDrop(9.0);
        this.setResistance(d3);
        this.setInternalResistance(d3);
        this.setInternalResistanceOn(bl);
        this.setKirkhoffEnabled(true);
    }

    public void setVoltageDrop(double d) {
        super.setVoltageDrop(d);
        super.fireKirkhoffChange();
    }

    public void setResistance(double d) {
        if (d < 1.0E-8) {
            throw new IllegalArgumentException("Resistance was les than the min, value=" + d + ", min=" + 1.0E-8);
        }
        super.setResistance(d);
    }

    public void setInternalResistance(double d) {
        this.internalResistance = d;
        if (this.internalResistanceOn) {
            this.setResistance(d);
        }
    }

    public double getInteralResistance() {
        return this.internalResistance;
    }

    public void setInternalResistanceOn(boolean bl) {
        this.internalResistanceOn = bl;
        if (bl) {
            this.setResistance(this.internalResistance);
        } else {
            this.setResistance(1.0E-8);
        }
    }
}

