/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.view.piccolo;

import edu.colorado.phet.circuitconstructionkit.model.CCKModel;
import edu.colorado.phet.circuitconstructionkit.model.Electron;
import edu.colorado.phet.circuitconstructionkit.model.ElectronSet;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.CircuitNode;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.ElectronNode;
import edu.umd.cs.piccolo.PNode;

public class ElectronSetNode
extends PNode {
    private CircuitNode circuitNode;
    private CCKModel model;

    public ElectronSetNode(final CircuitNode circuitNode, CCKModel cCKModel) {
        this.circuitNode = circuitNode;
        this.model = cCKModel;
        cCKModel.getParticleSet().addListener(new ElectronSet.Listener(){

            public void particlesRemoved(Electron[] electronArray) {
                for (int i = 0; i < electronArray.length; ++i) {
                    Electron electron = electronArray[i];
                    for (int j = 0; j < ElectronSetNode.this.getChildrenCount(); ++j) {
                        PNode pNode = ElectronSetNode.this.getChild(j);
                        if (!(pNode instanceof ElectronNode) || ((ElectronNode)pNode).getElectron() != electron) continue;
                        ElectronSetNode.this.removeChild(pNode);
                        --j;
                    }
                }
            }

            public void particleAdded(Electron electron) {
                ElectronNode electronNode = new ElectronNode(electron, circuitNode.getClipFactory());
                ElectronSetNode.this.addChild(electronNode);
            }
        });
    }
}

