/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.controls;

import edu.colorado.phet.circuitconstructionkit.CCKModule;
import edu.colorado.phet.circuitconstructionkit.CCKResources;
import edu.colorado.phet.circuitconstructionkit.controls.CCKControlPanel;
import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SizeControlPanel
extends VerticalLayoutPanel {
    private CCKModule module;

    public SizeControlPanel(CCKModule cCKModule) {
        this.module = cCKModule;
        final JSpinner jSpinner = new JSpinner(new SpinnerNumberModel(1.0, 0.1, 10.0, 0.1));
        jSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                Number number = (Number)jSpinner.getValue();
                double d = number.doubleValue();
                SizeControlPanel.this.zoom(d);
            }
        });
        jSpinner.setSize(50, jSpinner.getPreferredSize().height);
        jSpinner.setPreferredSize(new Dimension(50, jSpinner.getPreferredSize().height));
        ButtonGroup buttonGroup = new ButtonGroup();
        JRadioButton jRadioButton = new JRadioButton(CCKResources.getString("CCK3ControlPanel.SmallRadioButton"));
        jRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SizeControlPanel.this.zoom(2.0);
            }
        });
        JRadioButton jRadioButton2 = new JRadioButton(CCKResources.getString("CCK3ControlPanel.MediumRadioButton"));
        jRadioButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SizeControlPanel.this.zoom(1.0);
            }
        });
        JRadioButton jRadioButton3 = new JRadioButton(CCKResources.getString("CCK3ControlPanel.LargeRadioButton"));
        jRadioButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SizeControlPanel.this.zoom(0.5);
            }
        });
        jRadioButton2.setSelected(true);
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
        this.add(jRadioButton3);
        this.add(jRadioButton2);
        this.add(jRadioButton);
        this.setBorder(new CCKControlPanel.CCKTitledBorder(CCKResources.getString("CCK3ControlPanel.SizePanelBorder")));
    }

    private void zoom(double d) {
        this.module.setZoom(d);
    }
}

