/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildanatom.view;

import edu.colorado.phet.buildanatom.model.SphericalParticle;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.graphics.RoundGradientPaint;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.phetcommon.view.util.ColorUtils;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.SphericalNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PDragEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.Color;
import java.awt.geom.Point2D;

public class SubatomicParticleNode
extends PNode {
    private final ModelViewTransform mvt;
    private final SphericalNode sphericalNode;
    private final SphericalParticle subatomicParticle;

    public SubatomicParticleNode(final ModelViewTransform modelViewTransform, final SphericalParticle sphericalParticle, Color color) {
        this.mvt = modelViewTransform;
        this.subatomicParticle = sphericalParticle;
        double d = sphericalParticle.getRadius();
        RoundGradientPaint roundGradientPaint = new RoundGradientPaint(-d / 1.5, -d / 1.5, ColorUtils.brighterColor(color, 0.8), new Point2D.Double(d, d), color);
        this.sphericalNode = new SphericalNode(modelViewTransform.modelToViewDeltaX(sphericalParticle.getDiameter()), roundGradientPaint, false);
        this.addChild(this.sphericalNode);
        this.updatePosition();
        this.addInputEventListener(new CursorHandler());
        sphericalParticle.addPositionListener(new SimpleObserver(){

            public void update() {
                SubatomicParticleNode.this.updatePosition();
            }
        });
        this.addInputEventListener(new PDragEventHandler(){

            protected void startDrag(PInputEvent pInputEvent) {
                super.startDrag(pInputEvent);
                sphericalParticle.setUserControlled(true);
            }

            public void mouseDragged(PInputEvent pInputEvent) {
                PDimension pDimension = pInputEvent.getDeltaRelativeTo(SubatomicParticleNode.this.getParent());
                Vector2D vector2D = modelViewTransform.viewToModelDelta(new Vector2D(pDimension));
                sphericalParticle.setPositionAndDestination(sphericalParticle.getPosition().getX() + vector2D.getX(), sphericalParticle.getPosition().getY() + vector2D.getY());
            }

            protected void endDrag(PInputEvent pInputEvent) {
                super.endDrag(pInputEvent);
                sphericalParticle.setUserControlled(false);
            }
        });
    }

    private void updatePosition() {
        Point2D point2D = this.mvt.modelToView(this.subatomicParticle.getPosition().toPoint2D());
        this.sphericalNode.setOffset(point2D);
    }
}

