/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildanatom.view;

import edu.colorado.phet.buildanatom.BuildAnAtomStrings;
import edu.colorado.phet.buildanatom.model.AtomListener;
import edu.colorado.phet.buildanatom.model.IDynamicAtom;
import edu.colorado.phet.common.phetcommon.model.property.BooleanProperty;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.Color;

public class StabilityIndicator
extends PNode {
    public StabilityIndicator(final IDynamicAtom iDynamicAtom, final BooleanProperty booleanProperty) {
        final PText pText = new PText(BuildAnAtomStrings.UNSTABLE){
            {
                this.setFont(new PhetFont(18, true));
                this.setTextPaint(Color.black);
            }
        };
        this.addChild(pText);
        final AtomListener.Adapter adapter = new AtomListener.Adapter(){

            public void configurationChanged() {
                StabilityIndicator.this.setVisible((Boolean)booleanProperty.get() != false && iDynamicAtom.getMassNumber() > 0);
                if (iDynamicAtom.isStable()) {
                    pText.setText(BuildAnAtomStrings.STABLE);
                } else {
                    pText.setText(BuildAnAtomStrings.UNSTABLE);
                }
                pText.setOffset(-pText.getFullBoundsReference().width / 2.0, -pText.getFullBoundsReference().height / 2.0);
            }
        };
        iDynamicAtom.addAtomListener(adapter);
        booleanProperty.addObserver(new SimpleObserver(){

            public void update() {
                adapter.configurationChanged();
            }
        });
        adapter.configurationChanged();
    }
}

