/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildanatom.view;

import edu.colorado.phet.buildanatom.BuildAnAtomConstants;
import edu.colorado.phet.buildanatom.BuildAnAtomStrings;
import edu.colorado.phet.buildanatom.model.AtomListener;
import edu.colorado.phet.buildanatom.model.Electron;
import edu.colorado.phet.buildanatom.model.IDynamicAtom;
import edu.colorado.phet.buildanatom.model.Neutron;
import edu.colorado.phet.buildanatom.model.Proton;
import edu.colorado.phet.buildanatom.view.ElectronNode;
import edu.colorado.phet.buildanatom.view.NeutronNode;
import edu.colorado.phet.buildanatom.view.ProtonNode;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.phetcommon.view.util.RectangleUtils;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class ParticleCountLegend
extends PNode {
    private static final ModelViewTransform NO_TRANSFORM = ModelViewTransform.createIdentity();
    private static final ConstantDtClock NO_CLOCK = new ConstantDtClock(1000, 1.0);

    public ParticleCountLegend(IDynamicAtom iDynamicAtom) {
        this(iDynamicAtom, new Color(0, 0, 0, 0));
    }

    public ParticleCountLegend(final IDynamicAtom iDynamicAtom, Color color) {
        PNode pNode = new PNode();
        this.addChild(pNode);
        PNode pNode2 = new PNode();
        this.addChild(pNode2);
        final ReadoutLegendItem readoutLegendItem = new ReadoutLegendItem(BuildAnAtomStrings.PROTONS_READOUT, iDynamicAtom, new Getter(){

            public int get() {
                return iDynamicAtom.getNumProtons();
            }
        }, new PNodeFactory(){

            public PNode createNode() {
                return new ProtonNode(NO_TRANSFORM, new Proton(NO_CLOCK));
            }
        });
        final ReadoutLegendItem readoutLegendItem2 = new ReadoutLegendItem(BuildAnAtomStrings.NEUTRONS_READOUT, iDynamicAtom, new Getter(){

            public int get() {
                return iDynamicAtom.getNumNeutrons();
            }
        }, new PNodeFactory(){

            public PNode createNode() {
                return new NeutronNode(NO_TRANSFORM, new Neutron(NO_CLOCK));
            }
        });
        final ReadoutLegendItem readoutLegendItem3 = new ReadoutLegendItem(BuildAnAtomStrings.ELECTRONS_READOUT, iDynamicAtom, new Getter(){

            public int get() {
                return iDynamicAtom.getNumElectrons();
            }
        }, new PNodeFactory(){

            public PNode createNode() {
                return new ElectronNode(NO_TRANSFORM, new Electron(NO_CLOCK));
            }
        });
        pNode2.addChild(readoutLegendItem);
        pNode2.addChild(readoutLegendItem2);
        pNode2.addChild(readoutLegendItem3);
        readoutLegendItem.setOffset(0.0, 5.0);
        readoutLegendItem2.setOffset(0.0, readoutLegendItem.getFullBounds().getMaxY() + 5.0);
        readoutLegendItem3.setOffset(0.0, readoutLegendItem2.getFullBounds().getMaxY() + 5.0);
        double d = 20.0 + Math.max(readoutLegendItem.textNode.getFullBounds().getMaxX(), Math.max(readoutLegendItem2.textNode.getFullBounds().getMaxX(), readoutLegendItem3.textNode.getFullBounds().getMaxX()));
        readoutLegendItem.setIconXOffset(d);
        readoutLegendItem2.setIconXOffset(d);
        readoutLegendItem3.setIconXOffset(d);
        final PhetPPath phetPPath = new PhetPPath(color, (Stroke)new BasicStroke(1.0f), (Paint)Color.black);
        pNode.addChild(phetPPath);
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Rectangle2D rectangle2D = RectangleUtils.union(new Rectangle2D[]{readoutLegendItem.getFullBounds(), readoutLegendItem2.getFullBounds(), readoutLegendItem3.getFullBounds()});
                Rectangle2D rectangle2D2 = RectangleUtils.expandRectangle2D(rectangle2D, 5.0, 5.0);
                phetPPath.setPathTo(new RoundRectangle2D.Double(rectangle2D2.getX(), rectangle2D2.getY(), Math.max(rectangle2D2.getWidth(), 170.0), rectangle2D2.getHeight(), 10.0, 10.0));
            }
        };
        readoutLegendItem.addPropertyChangeListener("fullBounds", propertyChangeListener);
        readoutLegendItem2.addPropertyChangeListener("fullBounds", propertyChangeListener);
        readoutLegendItem3.addPropertyChangeListener("fullBounds", propertyChangeListener);
    }

    static interface Getter {
        public int get();
    }

    private static interface PNodeFactory {
        public PNode createNode();
    }

    private static class ReadoutLegendItem
    extends PNode {
        private final PNode iconChildNode = new PNode();
        private final PText textNode;
        private double iconX;
        private final Getter getter;
        private final PNodeFactory nodeFactory;

        public ReadoutLegendItem(String string, IDynamicAtom iDynamicAtom, Getter getter, PNodeFactory pNodeFactory) {
            this.getter = getter;
            this.nodeFactory = pNodeFactory;
            this.textNode = new PText(string){
                {
                    this.setFont(BuildAnAtomConstants.ITEM_FONT);
                }
            };
            this.addChild(this.iconChildNode);
            this.addChild(this.textNode);
            AtomListener.Adapter adapter = new AtomListener.Adapter(){

                public void configurationChanged() {
                    ReadoutLegendItem.this.updateLayout();
                }
            };
            iDynamicAtom.addAtomListener(adapter);
            adapter.configurationChanged();
        }

        private void updateLayout() {
            this.iconChildNode.removeAllChildren();
            for (int i = 0; i < this.getter.get(); ++i) {
                PNode pNode = this.nodeFactory.createNode();
                pNode.setPickable(false);
                pNode.setChildrenPickable(false);
                pNode.scale(1.3);
                this.iconChildNode.addChild(pNode);
                pNode.setOffset(17.0 * (double)i, 0.0);
            }
            this.iconChildNode.setOffset(this.iconX, this.textNode.getFullBounds().getCenterY());
        }

        public void setIconXOffset(double d) {
            this.iconX = d;
            this.updateLayout();
        }
    }
}

