/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildanatom.view;

import edu.colorado.phet.buildanatom.BuildAnAtomConstants;
import edu.colorado.phet.buildanatom.BuildAnAtomResources;
import edu.colorado.phet.buildanatom.model.Atom;
import edu.colorado.phet.buildanatom.model.AtomListener;
import edu.colorado.phet.buildanatom.model.ElectronShell;
import edu.colorado.phet.buildanatom.view.ElectronOrbitalNode;
import edu.colorado.phet.buildanatom.view.OrbitalView;
import edu.colorado.phet.buildanatom.view.ResizingElectronCloudNode;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.PhetColorScheme;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MassIndicatorNode
extends PNode {
    public MassIndicatorNode(final Atom atom, final Property<OrbitalView> property) {
        final PImage pImage = new PImage(BuildAnAtomResources.getImage("atom_builder_scale.png"));
        pImage.setScale(90.0 / pImage.getFullBoundsReference().width);
        final double d = pImage.getHeight();
        this.addChild(pImage);
        final PhetPPath phetPPath = new PhetPPath(Color.WHITE, new BasicStroke(1.0f), Color.LIGHT_GRAY){
            {
                super(paint, stroke, paint2);
                RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(0.0, 0.0, 36.0, d * 0.31, 4.0, 4.0);
                this.setPathTo(double_);
            }
        };
        this.addChild(phetPPath);
        final PText pText = new PText(){
            {
                this.setFont(BuildAnAtomConstants.WINDOW_TITLE_FONT);
                this.setTextPaint(Color.BLACK);
            }
        };
        final PNode pNode = new PNode();
        double d2 = 0.2;
        ModelViewTransform modelViewTransform = ModelViewTransform.createRectangleMapping(new Rectangle2D.Double(0.0, 0.0, 1.0, 1.0), new Rectangle2D.Double(0.0, 0.0, d2, d2));
        for (ElectronShell electronShell : atom.getElectronShells()) {
            pNode.addChild(new ElectronOrbitalNode(modelViewTransform, property, atom, electronShell, false));
        }
        pNode.addChild(new ResizingElectronCloudNode(modelViewTransform, property, atom));
        double d3 = 1.0;
        pNode.addChild(new PhetPPath(new Ellipse2D.Double(-d3 / 2.0, -d3 / 2.0, d3, d3), Color.red){
            {
                super(shape, paint);
                this.setOffset(pNode.getFullBounds().getCenter2D());
                AtomListener.Adapter adapter = new AtomListener.Adapter(){

                    public void configurationChanged() {
                        this.setVisible(atom.getNumProtons() + atom.getNumNeutrons() > 0);
                        if (atom.getNumProtons() > 0) {
                            this.setPaint(PhetColorScheme.RED_COLORBLIND);
                        } else {
                            this.setPaint(Color.gray);
                        }
                    }
                };
                atom.addAtomListener(adapter);
                adapter.configurationChanged();
            }
        });
        this.addChild(pNode);
        final AtomListener.Adapter adapter = new AtomListener.Adapter(){

            public void configurationChanged() {
                double d = 0.0;
                d = property.get() != OrbitalView.RESIZING_CLOUD ? pNode.getFullBoundsReference().height / 2.0 : (atom.getElectronShells().get(1).getNumElectrons() == 0 ? pNode.getFullBoundsReference().height * 0.9 : pNode.getFullBoundsReference().height * 0.6);
                pNode.setOffset(pImage.getFullBoundsReference().getCenterX(), d);
            }
        };
        atom.addAtomListener(adapter);
        property.addObserver(new SimpleObserver(){

            public void update() {
                adapter.configurationChanged();
            }
        });
        pImage.setOffset(0.0, pNode.getFullBoundsReference().height * 0.75);
        phetPPath.setOffset(pImage.getFullBoundsReference().getCenterX() - phetPPath.getFullBoundsReference().width / 2.0, pImage.getFullBoundsReference().getMaxX() - phetPPath.getFullBoundsReference().height - 2.5);
        AtomListener.Adapter adapter2 = new AtomListener.Adapter(){

            public void configurationChanged() {
                pText.setText(atom.getMassNumber() + "");
                pText.setOffset(phetPPath.getFullBounds().getCenterX() - pText.getFullBounds().getWidth() / 2.0, phetPPath.getFullBounds().getCenterY() - pText.getFullBounds().getHeight() / 2.0);
            }
        };
        atom.addAtomListener(adapter2);
        adapter2.configurationChanged();
        this.addChild(pText);
        this.setPickable(false);
        this.setChildrenPickable(false);
    }
}

