/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildanatom.view;

import edu.colorado.phet.buildanatom.model.AtomListener;
import edu.colorado.phet.buildanatom.model.IDynamicAtom;
import edu.colorado.phet.common.phetcommon.model.property.BooleanProperty;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.Color;

public class ElementNameIndicator
extends PNode {
    private final PText elementName;
    private final IDynamicAtom atom;
    private final BooleanProperty showLabels;
    private final boolean showMassNumber;

    public ElementNameIndicator(IDynamicAtom iDynamicAtom, BooleanProperty booleanProperty, boolean bl) {
        this.atom = iDynamicAtom;
        this.showLabels = booleanProperty;
        this.showMassNumber = bl;
        this.elementName = new PText(){
            {
                this.setFont(new PhetFont(18, true));
                this.setTextPaint(Color.red);
            }
        };
        this.addChild(this.elementName);
        iDynamicAtom.addAtomListener(new AtomListener.Adapter(){

            public void configurationChanged() {
                ElementNameIndicator.this.updateElementName();
            }
        });
        booleanProperty.addObserver(new SimpleObserver(){

            public void update() {
                ElementNameIndicator.this.updateElementName();
            }
        });
    }

    private void updateElementName() {
        if (this.atom.getNumProtons() > 0) {
            this.elementName.setText(this.atom.getName() + (this.showMassNumber ? "-" + this.atom.getMassNumber() : ""));
        } else {
            this.elementName.setText(" ");
        }
        this.elementName.setOffset(-this.elementName.getFullBoundsReference().width / 2.0, -this.elementName.getFullBoundsReference().height / 2.0);
        this.elementName.setVisible((Boolean)this.showLabels.get());
    }

    public void setColor(Color color) {
        this.elementName.setTextPaint(color);
    }

    public void setFont(PhetFont phetFont) {
        this.elementName.setFont(phetFont);
    }
}

