/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildanatom.view;

import edu.colorado.phet.buildanatom.model.Atom;
import edu.colorado.phet.buildanatom.model.ElectronShell;
import edu.colorado.phet.buildanatom.view.OrbitalView;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.umd.cs.piccolo.PNode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElectronOrbitalNode
extends PNode {
    private static final Stroke ELECTRON_SHELL_STROKE = new BasicStroke(2.0f, 0, 2, 0.0f, new float[]{3.0f, 3.0f}, 0.0f);
    private static final Paint ELECTRON_SHELL_STROKE_PAINT = new Color(0, 0, 255, 100);

    public ElectronOrbitalNode(ModelViewTransform modelViewTransform, final Property<OrbitalView> property, final Atom atom, ElectronShell electronShell, boolean bl) {
        Shape shape = modelViewTransform.modelToView(new Ellipse2D.Double(-electronShell.getRadius(), -electronShell.getRadius(), electronShell.getRadius() * 2.0, electronShell.getRadius() * 2.0));
        PhetPPath phetPPath = new PhetPPath(shape, ELECTRON_SHELL_STROKE, ELECTRON_SHELL_STROKE_PAINT){
            {
                super(shape, stroke, paint);
                this.setOffset(atom.getPosition());
                SimpleObserver simpleObserver = new SimpleObserver(){

                    public void update() {
                        this.setVisible(property.get() == OrbitalView.PARTICLES);
                    }
                };
                property.addObserver(simpleObserver);
            }
        };
        this.addChild(phetPPath);
    }
}

