/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildanatom.view;

import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import java.awt.Color;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class CircularGradientPaint
implements Paint {
    private final Color pointColor;
    private final Color backgroundColor;
    private final Point2D center;

    public CircularGradientPaint(Point2D point2D, Color color, Color color2) {
        this.center = point2D;
        this.pointColor = color;
        this.backgroundColor = color2;
    }

    public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
        Point2D point2D = affineTransform.transform(this.center, null);
        return new RoundGradientContext(point2D, this.pointColor, this.backgroundColor);
    }

    public int getTransparency() {
        int n;
        int n2 = this.pointColor.getAlpha();
        return (n2 & (n = this.backgroundColor.getAlpha())) == 255 ? 1 : 3;
    }

    private static class RoundGradientContext
    implements PaintContext {
        private final Point2D _point;
        private final Color _color1;
        private final Color _color2;
        private WritableRaster _raster;

        public RoundGradientContext(Point2D point2D, Color color, Color color2) {
            this._point = point2D;
            this._color1 = color;
            this._color2 = color2;
        }

        public void dispose() {
        }

        public ColorModel getColorModel() {
            return ColorModel.getRGBdefault();
        }

        public Raster getRaster(int n, int n2, int n3, int n4) {
            if (this._raster == null || n3 > this._raster.getWidth() || n4 > this._raster.getHeight()) {
                this._raster = this.getColorModel().createCompatibleWritableRaster(n3, n4);
            }
            this.paint(n, n2, n3, n4, this._raster);
            return this._raster;
        }

        private void paint(int n, int n2, int n3, int n4, WritableRaster writableRaster) {
            int[] nArray = new int[n3 * n4 * 4];
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n3; ++j) {
                    double d;
                    double d2 = d = new MutableVector2D(this._point, new Point2D.Double(n + j, n2 + i)).getAngle();
                    d2 = Math.abs(d2 / Math.PI) * 2.0;
                    int n5 = (i * n3 + j) * 4;
                    nArray[n5 + 0] = (int)((double)this._color1.getRed() + d2 * (double)(this._color2.getRed() - this._color1.getRed()));
                    nArray[n5 + 1] = (int)((double)this._color1.getGreen() + d2 * (double)(this._color2.getGreen() - this._color1.getGreen()));
                    nArray[n5 + 2] = (int)((double)this._color1.getBlue() + d2 * (double)(this._color2.getBlue() - this._color1.getBlue()));
                    nArray[n5 + 3] = (int)((double)this._color1.getAlpha() + d2 * (double)(this._color2.getAlpha() - this._color1.getAlpha()));
                }
            }
            writableRaster.setPixels(0, 0, n3, n4, nArray);
        }
    }
}

