/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildanatom.view;

import edu.colorado.phet.buildanatom.model.AtomListener;
import edu.colorado.phet.buildanatom.model.IDynamicAtom;
import edu.colorado.phet.common.phetcommon.view.util.DoubleGeneralPath;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;

public class ChargePairingGraphNode
extends PNode {
    private static final PPath chargeCancellationEnclosingBox = new PhetPPath((Paint)null, (Stroke)new BasicStroke(1.0f), (Paint)Color.BLACK);
    private final ArrayList<PositiveChargeIconNode> positiveChargeIconList = new ArrayList();
    private final ArrayList<NegativeChargeIconNode> negativeChargeIconList = new ArrayList();

    public ChargePairingGraphNode(final IDynamicAtom iDynamicAtom) {
        this.addChild(chargeCancellationEnclosingBox);
        iDynamicAtom.addAtomListener(new AtomListener.Adapter(){

            public void configurationChanged() {
                int n = iDynamicAtom.getNumElectrons() - ChargePairingGraphNode.this.negativeChargeIconList.size();
                if (n > 0) {
                    ChargePairingGraphNode.this.addNegativeIcons(n);
                } else if (n < 0) {
                    ChargePairingGraphNode.this.removeNegativeIcons(-n);
                }
                int n2 = iDynamicAtom.getNumProtons() - ChargePairingGraphNode.this.positiveChargeIconList.size();
                if (n2 > 0) {
                    ChargePairingGraphNode.this.addPositiveIcons(n2);
                } else if (n2 < 0) {
                    ChargePairingGraphNode.this.removePositiveIcons(-n2);
                }
                ChargePairingGraphNode.this.updateBoundingBox();
            }
        });
    }

    private void addPositiveIcons(int n) {
        assert (n >= 0);
        for (int i = 0; i < n; ++i) {
            PositiveChargeIconNode positiveChargeIconNode = new PositiveChargeIconNode();
            this.positiveChargeIconList.add(positiveChargeIconNode);
            positiveChargeIconNode.setOffset((double)(this.positiveChargeIconList.size() - 1) * (ChargeIconNode.CHARGE_ICON_SIZE.getWidth() + 3.0), 0.0);
            this.addChild(positiveChargeIconNode);
        }
    }

    private void addNegativeIcons(int n) {
        assert (n >= 0);
        for (int i = 0; i < n; ++i) {
            NegativeChargeIconNode negativeChargeIconNode = new NegativeChargeIconNode();
            this.negativeChargeIconList.add(negativeChargeIconNode);
            negativeChargeIconNode.setOffset((double)(this.negativeChargeIconList.size() - 1) * (ChargeIconNode.CHARGE_ICON_SIZE.getWidth() + 3.0), ChargeIconNode.CHARGE_ICON_SIZE.getHeight() + 3.0);
            this.addChild(negativeChargeIconNode);
        }
    }

    private void removePositiveIcons(int n) {
        assert (n >= 0);
        assert (this.positiveChargeIconList.size() >= n);
        for (int i = 0; i < n; ++i) {
            PositiveChargeIconNode positiveChargeIconNode = this.positiveChargeIconList.get(this.positiveChargeIconList.size() - 1);
            this.positiveChargeIconList.remove(positiveChargeIconNode);
            this.removeChild(positiveChargeIconNode);
        }
    }

    private void removeNegativeIcons(int n) {
        assert (n >= 0);
        assert (this.negativeChargeIconList.size() >= n);
        for (int i = 0; i < n; ++i) {
            NegativeChargeIconNode negativeChargeIconNode = this.negativeChargeIconList.get(this.negativeChargeIconList.size() - 1);
            this.negativeChargeIconList.remove(negativeChargeIconNode);
            this.removeChild(negativeChargeIconNode);
        }
    }

    private void updateBoundingBox() {
        int n = Math.min(this.positiveChargeIconList.size(), this.negativeChargeIconList.size());
        chargeCancellationEnclosingBox.setVisible(n > 0);
        RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(-1.5, -1.5, (double)n * ChargeIconNode.CHARGE_ICON_SIZE.getWidth() + (double)n * 3.0, ChargeIconNode.CHARGE_ICON_SIZE.getHeight() * 2.0 + 6.0, 4.0, 4.0);
        chargeCancellationEnclosingBox.setPathTo(double_);
    }

    private static Shape drawPlusSign(double d) {
        DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath();
        double d2 = d * 0.3;
        double d3 = d2 / 2.0;
        double d4 = d / 2.0;
        doubleGeneralPath.moveTo(-d4, -d3);
        doubleGeneralPath.lineTo(-d4, d3);
        doubleGeneralPath.lineTo(-d3, d3);
        doubleGeneralPath.lineTo(-d3, d4);
        doubleGeneralPath.lineTo(d3, d4);
        doubleGeneralPath.lineTo(d3, d3);
        doubleGeneralPath.lineTo(d4, d3);
        doubleGeneralPath.lineTo(d4, -d3);
        doubleGeneralPath.lineTo(d3, -d3);
        doubleGeneralPath.lineTo(d3, -d4);
        doubleGeneralPath.lineTo(-d3, -d4);
        doubleGeneralPath.lineTo(-d3, -d3);
        doubleGeneralPath.closePath();
        return doubleGeneralPath.getGeneralPath();
    }

    private static Shape drawMinusSign(double d) {
        double d2 = d * 0.3;
        return new Rectangle2D.Double(-d / 2.0, -d2 / 2.0, d, d2);
    }

    static class ChargeIconNode
    extends PNode {
        protected static final Dimension2D CHARGE_ICON_SIZE = new PDimension(20.0, 20.0);

        public ChargeIconNode(Shape shape, Color color, Color color2) {
            PhetPPath phetPPath = new PhetPPath(shape, color, new BasicStroke(1.0f), Color.BLACK);
            phetPPath.setOffset(CHARGE_ICON_SIZE.getWidth() / 2.0, CHARGE_ICON_SIZE.getHeight() / 2.0);
            this.addChild(phetPPath);
        }
    }

    static class NegativeChargeIconNode
    extends ChargeIconNode {
        private static Color BACKGROUND_COLOR = new Color(200, 217, 234);
        private static Color SYMBOL_COLOR = Color.BLUE;

        public NegativeChargeIconNode() {
            super(ChargePairingGraphNode.drawMinusSign(NegativeChargeIconNode.CHARGE_ICON_SIZE.getWidth() * 0.5), SYMBOL_COLOR, BACKGROUND_COLOR);
        }
    }

    static class PositiveChargeIconNode
    extends ChargeIconNode {
        private static Color BACKGROUND_COLOR = new Color(248, 203, 203);
        private static Color SYMBOL_COLOR = Color.RED;

        public PositiveChargeIconNode() {
            super(ChargePairingGraphNode.drawPlusSign(PositiveChargeIconNode.CHARGE_ICON_SIZE.getWidth() * 0.6), SYMBOL_COLOR, BACKGROUND_COLOR);
        }
    }
}

