/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildanatom.view;

import edu.colorado.phet.buildanatom.BuildAnAtomConstants;
import edu.colorado.phet.buildanatom.BuildAnAtomResources;
import edu.colorado.phet.buildanatom.model.AtomListener;
import edu.colorado.phet.buildanatom.model.IAtom;
import edu.colorado.phet.buildanatom.model.IDynamicAtom;
import edu.colorado.phet.buildanatom.view.ChargePairingGraphNode;
import edu.colorado.phet.buildanatom.view.CircularGradientPaint;
import edu.colorado.phet.common.phetcommon.math.Function;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.view.graphics.Arrow;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.nodes.ShadowPText;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;

public class ChargeIndicatorNode
extends PNode {
    public ChargeIndicatorNode(final IDynamicAtom iDynamicAtom) {
        final PImage pImage = new PImage(BuildAnAtomResources.getImage("atom_builder_charge_meter_no_window.png"));
        pImage.setScale(90.0 / pImage.getFullBoundsReference().width);
        this.addChild(pImage);
        final PNode pNode = new PNode(){
            {
                CircularGradientPaint circularGradientPaint = new CircularGradientPaint(new Point2D.Double(38.0, 40.0), Color.red, Color.white);
                PhetPPath phetPPath = new PhetPPath((Shape)new Arc2D.Double(0.0, 0.0, 76.0, 80.0, 0.0, 90.0, 2), (Paint)circularGradientPaint);
                this.addChild(phetPPath);
                CircularGradientPaint circularGradientPaint2 = new CircularGradientPaint(new Point2D.Double(38.0, 40.0), Color.white, Color.blue);
                PhetPPath phetPPath2 = new PhetPPath((Shape)new Arc2D.Double(0.0, 0.0, 76.0, 80.0, 90.0, 90.0, 2), (Paint)circularGradientPaint2);
                this.addChild(phetPPath2);
                double d = 2.0;
                Rectangle2D.Double double_ = new Rectangle2D.Double(38.0 - d / 2.0, 0.0, d, 40.0);
                this.addChild(new PhetPPath((Shape)double_, (Paint)Color.white));
                PhetPPath phetPPath3 = new PhetPPath(new Arc2D.Double(0.0, 0.0, 76.0, 80.0, 0.0, 180.0, 2), (Stroke)new BasicStroke(2.0f), (Paint)Color.GRAY);
                this.addChild(phetPPath3);
            }
        };
        pNode.setOffset(pImage.getFullBoundsReference().width / 2.0 - pNode.getFullBoundsReference().width / 2.0, 7.0);
        this.addChild(pNode);
        this.addChild(new PhetPPath(Color.WHITE, new BasicStroke(2.0f), Color.LIGHT_GRAY){
            {
                super(paint, stroke, paint2);
                RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(0.0, 0.0, pNode.getFullBoundsReference().width * 0.6, (pImage.getFullBoundsReference().getMaxY() - pNode.getFullBoundsReference().getMaxY()) * 0.7, 4.0, 4.0);
                this.setPathTo(double_);
                this.setOffset(pNode.getFullBoundsReference().getCenterX() - this.getFullBoundsReference().width / 2.0, pNode.getFullBoundsReference().getMaxY() + 5.0);
            }
        });
        final PText pText = new PText(iDynamicAtom.getCharge() + ""){
            {
                this.setFont(BuildAnAtomConstants.WINDOW_TITLE_FONT);
            }
        };
        AtomListener.Adapter adapter = new AtomListener.Adapter(){

            public void configurationChanged() {
                pText.setText(iDynamicAtom.getFormattedCharge());
                pText.setOffset(pNode.getFullBounds().getCenterX() - pText.getFullBounds().getWidth() / 2.0, (pNode.getFullBounds().getMaxY() + pImage.getFullBounds().getMaxY()) / 2.0 - pText.getFullBounds().getHeight() / 2.0);
                pText.setTextPaint(ChargeIndicatorNode.this.getTextPaint(iDynamicAtom));
            }
        };
        iDynamicAtom.addAtomListener(adapter);
        adapter.configurationChanged();
        this.addChild(pText);
        final PhetPPath phetPPath = new PhetPPath(Color.black);
        AtomListener.Adapter adapter2 = new AtomListener.Adapter(){

            public void configurationChanged() {
                Function.LinearFunction linearFunction = new Function.LinearFunction(0.0, 12.0, -1.5707963267948966, 0.0);
                double d = linearFunction.evaluate(iDynamicAtom.getCharge());
                phetPPath.setPathTo(new Arrow((Point2D)new Point2D.Double(pNode.getFullBounds().getCenterX(), pNode.getFullBounds().getMaxY()), Vector2D.createPolar(pNode.getFullBounds().getHeight() * 0.98, d), 8.0, 8.0, 4.0, 4.0, false).getShape());
            }
        };
        iDynamicAtom.addAtomListener(adapter2);
        adapter2.configurationChanged();
        this.addChild(phetPPath);
        this.addChild(new ShadowPText("+"){
            {
                super(string);
                this.setFont(BuildAnAtomConstants.WINDOW_TITLE_FONT);
                this.setOffset(pNode.getFullBounds().getWidth() * 3.0 / 4.0 - this.getFullBounds().getWidth() / 2.0, pNode.getFullBounds().getCenterY() - this.getFullBounds().getHeight() / 2.0);
                this.setTextPaint(Color.red);
            }
        });
        this.addChild(new ShadowPText("-"){
            {
                super(string);
                this.setFont(BuildAnAtomConstants.WINDOW_TITLE_FONT);
                this.setOffset(pNode.getFullBounds().getWidth() * 1.0 / 4.0 - this.getFullBounds().getWidth() / 2.0, pNode.getFullBounds().getCenterY() - this.getFullBounds().getHeight() / 2.0);
                this.setTextPaint(new Color(69, 94, 255));
            }
        });
        this.addChild(new ChargePairingGraphNode(iDynamicAtom){
            {
                super(iDynamicAtom);
                this.setOffset(pImage.getFullBoundsReference().getMaxX() + 15.0, pImage.getFullBoundsReference().getCenterY() - 5.0);
            }
        });
    }

    private Paint getTextPaint(IAtom iAtom) {
        if (iAtom.getCharge() == 0) {
            return Color.black;
        }
        if (iAtom.getCharge() > 0) {
            return Color.red;
        }
        return Color.blue;
    }
}

