/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildanatom.modules.isotopemixture.view;

import edu.colorado.phet.buildanatom.BuildAnAtomStrings;
import edu.colorado.phet.buildanatom.model.AtomIdentifier;
import edu.colorado.phet.buildanatom.model.ImmutableAtom;
import edu.colorado.phet.buildanatom.modules.isotopemixture.model.MixIsotopesModel;
import edu.colorado.phet.buildanatom.modules.isotopemixture.view.VariablePrecisionNumberFormat;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.DoubleGeneralPath;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Dimension2D;
import java.awt.geom.RoundRectangle2D;
import java.util.List;

public class AverageAtomicMassIndicator
extends PNode {
    private static double INDICATOR_WIDTH = 300.0;
    private double massSpan = 3.0;
    private double minMass = 0.0;

    public AverageAtomicMassIndicator(final MixIsotopesModel mixIsotopesModel) {
        PNode pNode = new PNode();
        this.addChild(pNode);
        DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath(0.0, 0.0);
        doubleGeneralPath.lineTo(INDICATOR_WIDTH, 0.0);
        PhetPPath phetPPath = new PhetPPath(doubleGeneralPath.getGeneralPath(), (Stroke)new BasicStroke(3.0f), (Paint)Color.BLACK);
        pNode.addChild(phetPPath);
        final PNode pNode2 = new PNode();
        pNode.addChild(pNode2);
        mixIsotopesModel.getPossibleIsotopesProperty().addObserver(new SimpleObserver(){

            public void update() {
                pNode2.removeAllChildren();
                List<ImmutableAtom> list = mixIsotopesModel.getPossibleIsotopesProperty().get();
                double d = Double.POSITIVE_INFINITY;
                double d2 = 0.0;
                AverageAtomicMassIndicator.this.minMass = Double.POSITIVE_INFINITY;
                for (ImmutableAtom immutableAtom : list) {
                    if (immutableAtom.getAtomicMass() > d2) {
                        d2 = immutableAtom.getAtomicMass();
                    }
                    if (!(immutableAtom.getAtomicMass() < d)) continue;
                    d = immutableAtom.getAtomicMass();
                }
                AverageAtomicMassIndicator.this.massSpan = d2 - d;
                if (AverageAtomicMassIndicator.this.massSpan < 2.0) {
                    AverageAtomicMassIndicator.this.massSpan = 2.0;
                }
                AverageAtomicMassIndicator.this.massSpan *= 1.2;
                AverageAtomicMassIndicator.this.minMass = (d2 + d) / 2.0 - AverageAtomicMassIndicator.this.massSpan / 2.0;
                for (ImmutableAtom immutableAtom : mixIsotopesModel.getPossibleIsotopesProperty().get()) {
                    IsotopeTickMark isotopeTickMark = new IsotopeTickMark(immutableAtom);
                    isotopeTickMark.setOffset(AverageAtomicMassIndicator.this.calcXOffsetFromAtomicMass(immutableAtom.getAtomicMass()), 0.0);
                    pNode2.addChild(isotopeTickMark);
                }
            }
        }, false);
        final ReadoutPointer readoutPointer = new ReadoutPointer(mixIsotopesModel);
        readoutPointer.setOffset(phetPPath.getFullBoundsReference().getCenterX(), 20.0);
        pNode.addChild(readoutPointer);
        mixIsotopesModel.getIsotopeTestChamber().addAverageAtomicMassPropertyListener(new SimpleObserver(){

            public void update() {
                if (mixIsotopesModel.getIsotopeTestChamber().getTotalIsotopeCount() > 0) {
                    readoutPointer.setOffset(AverageAtomicMassIndicator.this.calcXOffsetFromAtomicMass(mixIsotopesModel.getIsotopeTestChamber().getAverageAtomicMass()), 0.0);
                    readoutPointer.setVisible(true);
                } else {
                    readoutPointer.setVisible(false);
                }
            }
        });
        pNode.setOffset(0.0, 40.0);
    }

    private double calcXOffsetFromAtomicMass(double d) {
        return Math.max((d - this.minMass) / this.massSpan * INDICATOR_WIDTH, 0.0);
    }

    private static class IsotopeTickMark
    extends PNode {
        private static final Stroke TICK_MARK_STROKE = new BasicStroke(5.0f);

        public IsotopeTickMark(ImmutableAtom immutableAtom) {
            DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath(0.0, -5.0);
            doubleGeneralPath.lineTo(0.0, 5.0);
            this.addChild(new PhetPPath(doubleGeneralPath.getGeneralPath(), TICK_MARK_STROKE, (Paint)Color.BLACK));
            HTMLNode hTMLNode = new HTMLNode("<html><sup>" + immutableAtom.getMassNumber() + "</sup>" + immutableAtom.getSymbol() + "</html>"){
                {
                    this.setFont(new PhetFont(14));
                    this.setScale(30.0 / this.getFullBoundsReference().height);
                    this.setOffset(-this.getFullBoundsReference().width / 2.0, -this.getFullBoundsReference().height - 5.0);
                }
            };
            this.addChild(hTMLNode);
        }
    }

    private static final class ReadoutPointer
    extends PNode {
        private static final Dimension2D SIZE = new PDimension(120.0, 25.0);
        private final MixIsotopesModel model;
        private final PText textualReadout;
        private final PNode readoutBackgroundNode;

        public ReadoutPointer(MixIsotopesModel mixIsotopesModel) {
            this.model = mixIsotopesModel;
            DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath(0.0, 0.0);
            doubleGeneralPath.lineTo(-10.0, 15.0);
            doubleGeneralPath.lineTo(10.0, 15.0);
            doubleGeneralPath.closePath();
            PhetPPath phetPPath = new PhetPPath((Shape)doubleGeneralPath.getGeneralPath(), (Paint)new Color(0, 143, 212));
            this.addChild(phetPPath);
            this.readoutBackgroundNode = new PhetPPath(new RoundRectangle2D.Double(-SIZE.getWidth() / 2.0, 15.0, SIZE.getWidth(), SIZE.getHeight(), 5.0, 5.0), Color.WHITE, new BasicStroke(1.0f), Color.BLACK);
            this.addChild(this.readoutBackgroundNode);
            this.textualReadout = new PText(){
                {
                    this.setFont(new PhetFont(18));
                }
            };
            this.addChild(this.textualReadout);
            mixIsotopesModel.getIsotopeTestChamber().addAverageAtomicMassPropertyListener(new SimpleObserver(){

                public void update() {
                    ReadoutPointer.this.updateReadout();
                }
            });
            mixIsotopesModel.getShowingNaturesMixProperty().addObserver(new SimpleObserver(){

                public void update() {
                    ReadoutPointer.this.updateReadout();
                }
            });
        }

        private void updateReadout() {
            int n;
            double d;
            if (((Boolean)this.model.getShowingNaturesMixProperty().get()).booleanValue()) {
                d = AtomIdentifier.getStandardAtomicMassPrecisionDecimal(this.model.getAtom().getNumProtons()).getPreciseValue();
                n = Math.min(AtomIdentifier.getStandardAtomicMassPrecisionDecimal(this.model.getAtom().getNumProtons()).getNumberOfDecimalPlaces(), 5);
            } else {
                d = this.model.getIsotopeTestChamber().getAverageAtomicMass();
                n = 5;
            }
            this.textualReadout.setText(VariablePrecisionNumberFormat.format(d, n) + BuildAnAtomStrings.UNITS_AMU);
            this.textualReadout.setScale(1.0);
            if (this.textualReadout.getFullBoundsReference().width >= this.readoutBackgroundNode.getFullBoundsReference().getWidth() * 0.95) {
                this.textualReadout.setScale(this.readoutBackgroundNode.getFullBoundsReference().width / this.textualReadout.getFullBoundsReference().width * 0.95);
            }
            this.textualReadout.centerFullBoundsOnPoint(this.readoutBackgroundNode.getFullBoundsReference().getCenterX(), this.readoutBackgroundNode.getFullBounds().getCenterY());
        }
    }
}

