/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildanatom.modules.interactiveisotope.view;

import edu.colorado.phet.buildanatom.BuildAnAtomConstants;
import edu.colorado.phet.buildanatom.BuildAnAtomDefaults;
import edu.colorado.phet.buildanatom.BuildAnAtomStrings;
import edu.colorado.phet.buildanatom.model.AtomListener;
import edu.colorado.phet.buildanatom.model.IDynamicAtom;
import edu.colorado.phet.buildanatom.modules.interactiveisotope.model.MakeIsotopesModel;
import edu.colorado.phet.buildanatom.modules.interactiveisotope.view.AtomScaleNode;
import edu.colorado.phet.buildanatom.modules.interactiveisotope.view.InteractiveIsotopeNode;
import edu.colorado.phet.buildanatom.view.ElementNameIndicator;
import edu.colorado.phet.buildanatom.view.MaximizeControlNode;
import edu.colorado.phet.buildanatom.view.ParticleCountLegend;
import edu.colorado.phet.buildanatom.view.PeriodicTableControlNode;
import edu.colorado.phet.buildanatom.view.StabilityIndicator;
import edu.colorado.phet.buildanatom.view.SymbolIndicatorNode;
import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.common.phetcommon.model.property.BooleanProperty;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetcommon.view.util.RectangleUtils;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.nodes.PieChartNode;
import edu.colorado.phet.common.piccolophet.nodes.ResetAllButtonNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolox.nodes.PLine;
import edu.umd.cs.piccolox.util.LineShape;
import edu.umd.cs.piccolox.util.XYArray;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;

public class MakeIsotopesCanvas
extends PhetPCanvas
implements Resettable {
    private static final Color BACKGROUND_COLOR = BuildAnAtomConstants.CANVAS_BACKGROUND;
    private final MakeIsotopesModel model;
    private final PNode rootNode;
    private final ModelViewTransform mvt;
    private final MaximizeControlNode symbolWindow;
    private final MaximizeControlNode abundanceWindow;
    private final AtomScaleNode scaleNode;

    public MakeIsotopesCanvas(final MakeIsotopesModel makeIsotopesModel) {
        this.model = makeIsotopesModel;
        this.setWorldTransformStrategy(new PhetPCanvas.CenteredStage(this, BuildAnAtomDefaults.STAGE_SIZE));
        this.mvt = ModelViewTransform.createSinglePointScaleInvertedYMapping(new Point2D.Double(0.0, 0.0), new Point((int)Math.round(BuildAnAtomDefaults.STAGE_SIZE.width * 0.32), (int)Math.round(BuildAnAtomDefaults.STAGE_SIZE.height * 0.49)), 2.0);
        this.setBackground(BACKGROUND_COLOR);
        this.rootNode = new PNode();
        this.addWorldChild(this.rootNode);
        PNode pNode = new PNode();
        this.rootNode.addChild(pNode);
        PNode pNode2 = new PNode();
        this.rootNode.addChild(pNode2);
        final ParticleCountLegend particleCountLegend = new ParticleCountLegend(makeIsotopesModel.getAtom(), BACKGROUND_COLOR);
        particleCountLegend.setScale(1.1);
        particleCountLegend.setOffset(20.0, 10.0);
        pNode.addChild(particleCountLegend);
        this.scaleNode = new AtomScaleNode(makeIsotopesModel.getAtom()){
            {
                this.setOffset(MakeIsotopesCanvas.this.mvt.modelToViewX(0.0) - this.getFullBoundsReference().width / 2.0, 530.0);
            }
        };
        Point2D.Double double_ = new Point2D.Double(this.scaleNode.getFullBoundsReference().getCenterX(), this.scaleNode.getFullBoundsReference().getMinY() + this.scaleNode.getWeighPlateTopProjectedHeight() / 2.0);
        final InteractiveIsotopeNode interactiveIsotopeNode = new InteractiveIsotopeNode(makeIsotopesModel, this.mvt, double_);
        final PText pText = new PText(BuildAnAtomStrings.MY_ISOTOPE){
            {
                super(string);
                this.setFont(new PhetFont(24, true));
                this.setTextPaint(Color.DARK_GRAY);
                this.setOffset(MakeIsotopesCanvas.this.mvt.modelToViewX(0.0) - this.getFullBoundsReference().width / 2.0, particleCountLegend.getFullBoundsReference().getMaxY() + 30.0);
            }
        };
        this.rootNode.addChild(pText);
        interactiveIsotopeNode.addElectronCloudBoundsChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                pText.setOffset(MakeIsotopesCanvas.this.mvt.modelToViewX(makeIsotopesModel.getAtom().getPosition().getX()) - pText.getFullBoundsReference().width / 2.0, MakeIsotopesCanvas.this.mvt.modelToViewY(makeIsotopesModel.getAtom().getPosition().getY()) - interactiveIsotopeNode.getCloudRadius() - pText.getFullBoundsReference().height - 4.0);
            }
        });
        pNode2.addChild(this.scaleNode);
        pNode2.addChild(interactiveIsotopeNode);
        final ElementNameIndicator elementNameIndicator = new ElementNameIndicator(makeIsotopesModel.getAtom(), new BooleanProperty(true), true){
            {
                super(iDynamicAtom, booleanProperty, bl);
                this.setFont(new PhetFont(20, true));
                this.setColor(Color.BLACK);
                this.setOffset(MakeIsotopesCanvas.this.mvt.modelToViewX(0.0), pText.getFullBoundsReference().getMaxY() + this.getFullBoundsReference().height);
            }
        };
        pNode.addChild(elementNameIndicator);
        final StabilityIndicator stabilityIndicator = new StabilityIndicator(makeIsotopesModel.getAtom(), new BooleanProperty(true));
        pNode.addChild(stabilityIndicator);
        makeIsotopesModel.getAtom().addAtomListener(new AtomListener.Adapter(){

            public void postitionChanged() {
                this.updateLabelPositions();
            }

            public void configurationChanged() {
                this.updateLabelPositions();
            }

            private void updateLabelPositions() {
                double d = makeIsotopesModel.getAtom().getPosition().getX();
                double d2 = makeIsotopesModel.getAtom().getPosition().getY();
                elementNameIndicator.setOffset(MakeIsotopesCanvas.this.mvt.modelToViewX(d), MakeIsotopesCanvas.this.mvt.modelToViewY(d2) - elementNameIndicator.getFullBounds().height - 25.0);
                stabilityIndicator.setOffset(MakeIsotopesCanvas.this.mvt.modelToViewX(d), MakeIsotopesCanvas.this.mvt.modelToViewY(d2) + elementNameIndicator.getFullBounds().height + 20.0);
            }
        });
        PeriodicTableControlNode periodicTableControlNode = new PeriodicTableControlNode(makeIsotopesModel, 10, BACKGROUND_COLOR){
            {
                this.setScale(1.3);
                this.setOffset(BuildAnAtomDefaults.STAGE_SIZE.width - this.getFullBoundsReference().width - 20.0, 20.0);
            }
        };
        pNode.addChild(periodicTableControlNode);
        int n = 600;
        SymbolIndicatorNode symbolIndicatorNode = new SymbolIndicatorNode(makeIsotopesModel.getAtom(), false, false);
        this.symbolWindow = new MaximizeControlNode(BuildAnAtomStrings.INDICATOR_SYMBOL, new PDimension(400.0, 100.0), (PNode)symbolIndicatorNode, true);
        symbolIndicatorNode.setOffset(20.0, this.symbolWindow.getFullBoundsReference().height / 2.0 - symbolIndicatorNode.getFullBounds().getHeight() / 2.0);
        this.symbolWindow.setOffset(n, 270.0);
        pNode.addChild(this.symbolWindow);
        PDimension pDimension = new PDimension(400.0, 150.0);
        AbundanceIndicatorNode abundanceIndicatorNode = new AbundanceIndicatorNode(makeIsotopesModel.getAtom());
        abundanceIndicatorNode.setOffset(pDimension.getWidth() / 2.0 + 40.0, pDimension.getHeight() / 2.0 + 10.0);
        this.abundanceWindow = new MaximizeControlNode(BuildAnAtomStrings.ABUNDANCE_IN_NATURE, pDimension, (PNode)abundanceIndicatorNode, true);
        this.abundanceWindow.setOffset(n, this.symbolWindow.getFullBoundsReference().getMaxY() + 30.0);
        pNode.addChild(this.abundanceWindow);
        ResetAllButtonNode resetAllButtonNode = new ResetAllButtonNode(this, this, 16, Color.BLACK, new Color(255, 153, 0)){
            {
                this.setConfirmationEnabled(false);
            }
        };
        double d = 100.0;
        resetAllButtonNode.setScale(d / resetAllButtonNode.getFullBoundsReference().width);
        pNode.addChild(resetAllButtonNode);
        resetAllButtonNode.centerFullBoundsOnPoint(this.abundanceWindow.getFullBoundsReference().getCenterX(), BuildAnAtomDefaults.STAGE_SIZE.height - resetAllButtonNode.getFullBoundsReference().height);
        this.symbolWindow.setMaximized(false);
        this.abundanceWindow.setMaximized(false);
    }

    public void reset() {
        this.model.reset();
        this.symbolWindow.setMaximized(false);
        this.abundanceWindow.setMaximized(false);
        this.scaleNode.reset();
    }

    static /* synthetic */ Color access$300() {
        return BACKGROUND_COLOR;
    }

    private static class AbundanceIndicatorNode
    extends PNode {
        private static DecimalFormat ABUNDANCE_FORMATTER = new DecimalFormat("#.####");
        private static final Font READOUT_FONT = new PhetFont(20);
        private static final Stroke CONNECTING_LINE_STROKE = new BasicStroke(2.0f, 0, 2, 0.0f, new float[]{5.0f, 3.0f}, 0.0f);
        private final int RECTANGLE_INSET_X = 6;

        public AbundanceIndicatorNode(final IDynamicAtom iDynamicAtom) {
            LineShape lineShape = new LineShape(new XYArray(new double[]{0.0, 0.0, 0.0, 0.0}));
            final PLine pLine = new PLine(lineShape, CONNECTING_LINE_STROKE);
            this.addChild(pLine);
            final HTMLNode hTMLNode = new HTMLNode(){
                {
                    this.setFont(READOUT_FONT);
                }
            };
            final PhetPPath phetPPath = new PhetPPath(Color.white, (Stroke)new BasicStroke(1.0f), (Paint)Color.darkGray);
            this.addChild(phetPPath);
            this.addChild(hTMLNode);
            PText pText = new PText(BuildAnAtomStrings.THIS_ISOTOPE){
                {
                    super(string);
                    this.setFont(new PhetFont(18));
                    phetPPath.addPropertyChangeListener("fullBounds", new PropertyChangeListener(){

                        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                            this.centerFullBoundsOnPoint(phetPPath.getFullBoundsReference().getCenterX(), phetPPath.getFullBoundsReference().getMinY() - this.getFullBoundsReference().height / 2.0 - 2.0);
                        }
                    });
                }
            };
            this.addChild(pText);
            final TwoItemPieChartNode twoItemPieChartNode = new TwoItemPieChartNode(100, iDynamicAtom.getNaturalAbundance(), 1.0 - iDynamicAtom.getNaturalAbundance());
            this.addChild(twoItemPieChartNode);
            HTMLNode hTMLNode2 = new HTMLNode(){
                {
                    this.setFont(new PhetFont(18));
                    iDynamicAtom.addAtomListener(new AtomListener.Adapter(){

                        public void configurationChanged() {
                            String string = "<center>" + BuildAnAtomStrings.OTHER + "<br>" + iDynamicAtom.getName() + "<br>" + BuildAnAtomStrings.ISOTOPES + "</center>";
                            this.setHTML(string);
                            this.setOffset(twoItemPieChartNode.getFullBoundsReference().getMaxX() + 4.0, twoItemPieChartNode.getFullBoundsReference().getCenterY() - this.getFullBoundsReference().height / 2.0);
                            this.setVisible(iDynamicAtom.getNaturalAbundance() < 1.0);
                        }
                    });
                }
            };
            this.addChild(hTMLNode2);
            twoItemPieChartNode.setOffset(0.0, 0.0);
            AtomListener.Adapter adapter = new AtomListener.Adapter(){

                public void configurationChanged() {
                    double d = iDynamicAtom.getNaturalAbundance() * 100.0;
                    hTMLNode.setHTML(d < 1.0E-4 && d > 0.0 ? BuildAnAtomStrings.VERY_SMALL : ABUNDANCE_FORMATTER.format(d) + "%");
                    hTMLNode.setOffset(twoItemPieChartNode.getFullBoundsReference().getMinX() - hTMLNode.getFullBoundsReference().getWidth() - 40.0, twoItemPieChartNode.getFullBoundsReference().getCenterY() - hTMLNode.getFullBoundsReference().height / 2.0);
                    Rectangle2D rectangle2D = RectangleUtils.expand(hTMLNode.getFullBounds(), 6.0, 3.0);
                    phetPPath.setPathTo(new RoundRectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight(), 10.0, 10.0));
                    twoItemPieChartNode.updateValues(iDynamicAtom.getNaturalAbundance(), 1.0 - iDynamicAtom.getNaturalAbundance());
                    pLine.setPoint(0, phetPPath.getFullBoundsReference().getMaxX(), phetPPath.getFullBoundsReference().getCenterY());
                    pLine.setPoint(1, twoItemPieChartNode.getFullBoundsReference().getCenterX(), phetPPath.getFullBoundsReference().getCenterY());
                    pLine.setVisible(iDynamicAtom.getNaturalAbundance() > 0.0);
                }
            };
            iDynamicAtom.addAtomListener(adapter);
            adapter.configurationChanged();
        }
    }

    private static class TwoItemPieChartNode
    extends PNode {
        private static final Color LEFT_SLICE_COLOR = new Color(134, 102, 172);
        private static final Color RIGHT_SLICE_COLOR = MakeIsotopesCanvas.access$300();
        private final PieChartNode.PieValue[] pieSlices = new PieChartNode.PieValue[]{new PieChartNode.PieValue(100.0, LEFT_SLICE_COLOR), new PieChartNode.PieValue(0.0, RIGHT_SLICE_COLOR)};
        private final PieChartNode pieChart;

        public TwoItemPieChartNode(int n, double d, double d2) {
            this.pieChart = new PieChartNode(this.pieSlices, new Rectangle(-n / 2, -n / 2, n, n));
            this.addChild(this.pieChart);
            this.updateValues(d, d2);
        }

        public void updateValues(double d, double d2) {
            this.pieSlices[0].setValue(d);
            this.pieSlices[1].setValue(d2);
            this.pieChart.setPieValues(this.pieSlices);
            this.pieChart.setRotation(Math.PI * -2 * d2 / (d2 + d) / 2.0);
        }
    }
}

