/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildanatom.modules.interactiveisotope.view;

import edu.colorado.phet.buildanatom.model.Neutron;
import edu.colorado.phet.buildanatom.model.SphericalParticle;
import edu.colorado.phet.buildanatom.modules.game.view.SchematicAtomNode;
import edu.colorado.phet.buildanatom.modules.interactiveisotope.model.MakeIsotopesModel;
import edu.colorado.phet.buildanatom.view.OrbitalView;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.piccolophet.nodes.BucketView;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class InteractiveIsotopeNode
extends SchematicAtomNode {
    public InteractiveIsotopeNode(final MakeIsotopesModel makeIsotopesModel, final ModelViewTransform modelViewTransform, final Point2D point2D) {
        super(makeIsotopesModel.getAtom(), modelViewTransform, new Property<OrbitalView>(OrbitalView.ISOTOPES_RESIZING_CLOUD), false, true, false);
        makeIsotopesModel.addListener(new MakeIsotopesModel.Adapter(){

            public void particleAdded(SphericalParticle sphericalParticle) {
                InteractiveIsotopeNode.this.addParticleNode(sphericalParticle);
            }
        });
        BucketView bucketView = new BucketView(makeIsotopesModel.getNeutronBucket(), modelViewTransform);
        this.electronShellLayer.addChild(bucketView.getHoleNode());
        this.frontLayer.addChild(bucketView.getFrontNode());
        for (SphericalParticle sphericalParticle : makeIsotopesModel.getNeutronBucket().getParticleList()) {
            this.addNeutronNode((Neutron)sphericalParticle);
        }
        this.getIsotopeElectronCloudNode().addPropertyChangeListener("fullBounds", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                makeIsotopesModel.getAtom().setPosition(modelViewTransform.viewToModel(point2D.getX(), point2D.getY() - ((InteractiveIsotopeNode)InteractiveIsotopeNode.this).getIsotopeElectronCloudNode().getFullBoundsReference().height / 2.0));
            }
        });
    }

    public double getCloudRadius() {
        return this.getIsotopeElectronCloudNode().getFullBoundsReference().height / 2.0;
    }

    public void addElectronCloudBoundsChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getIsotopeElectronCloudNode().addPropertyChangeListener("fullBounds", propertyChangeListener);
    }
}

