/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildanatom.modules.game.view;

import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.Function0;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueNode
extends PNode {
    public static final Font NUMBER_FONT = new PhetFont(14, true);
    public static final NumberFormat DEFAULT_NUMBER_FORMAT = new DecimalFormat("0");
    public static final Function0<Color> DEFAULT_COLOR_FUNCTION = new Function0.Constant<Color>(Color.BLACK);
    private final PText text = new PText("0");
    private final JSpinner spinner;
    private final SimpleObserver updateReadouts;
    private Function0<Color> colorFunction;

    public ValueNode(final Property<Integer> property, final int n, final int n2, int n3, final Property<Boolean> property2, final NumberFormat numberFormat, Function0<Color> function0) {
        this.colorFunction = function0;
        this.spinner = new JSpinner(new SpinnerNumberModel(property.get(), n, n2, n3)){
            {
                super(spinnerModel);
                this.addChangeListener(new ChangeListener(){

                    public void stateChanged(ChangeEvent changeEvent) {
                        property.set((Integer)this.getValue());
                    }
                });
            }
        };
        this.updateReadouts = new SimpleObserver(){

            public void update() {
                ValueNode.this.spinner.setValue(property.get());
                try {
                    ((JSpinner.DefaultEditor)ValueNode.this.spinner.getEditor()).getTextField().setForeground((Color)ValueNode.this.colorFunction.apply());
                }
                catch (Exception exception) {
                    System.out.println("ignoring = " + exception);
                }
                ValueNode.this.text.setTextPaint((Paint)ValueNode.this.colorFunction.apply());
                ValueNode.this.text.setText(numberFormat.format(property.get()));
            }
        };
        property.addObserver(this.updateReadouts);
        final PSwing pSwing = new PSwing(this.spinner);
        this.addChild(pSwing);
        this.text.setFont(NUMBER_FONT);
        this.text.setOffset(pSwing.getFullBoundsReference().getCenterX() - this.text.getFullBoundsReference().width / 2.0, pSwing.getFullBoundsReference().getCenterY() - this.text.getFullBoundsReference().height / 2.0);
        this.addChild(this.text);
        property2.addObserver(new SimpleObserver(){

            public void update() {
                pSwing.setVisible((Boolean)property2.get());
                ValueNode.this.text.setVisible((Boolean)property2.get() == false);
            }
        });
        final JSpinner.DefaultEditor defaultEditor = (JSpinner.DefaultEditor)this.getSpinnerEditor();
        defaultEditor.getTextField().setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(numberFormat){
            {
                super(numberFormat);
                this.setMinimum(Integer.valueOf(n));
                this.setMaximum(Integer.valueOf(n2));
                this.setValueClass(Integer.class);
            }
        }));
        defaultEditor.getTextField().addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        defaultEditor.getTextField().selectAll();
                    }
                });
            }
        });
        this.spinner.setEditor(defaultEditor);
        this.updateReadouts.update();
    }

    public JComponent getSpinnerEditor() {
        return this.spinner.getEditor();
    }

    public void setColorFunction(Function0<Color> function0) {
        this.colorFunction = function0;
    }
}

