/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildanatom.modules.game.view;

import edu.colorado.phet.buildanatom.BuildAnAtomDefaults;
import edu.colorado.phet.buildanatom.BuildAnAtomStrings;
import edu.colorado.phet.buildanatom.model.ImmutableAtom;
import edu.colorado.phet.buildanatom.modules.game.model.BuildAnAtomGameModel;
import edu.colorado.phet.buildanatom.modules.game.model.Problem;
import edu.colorado.phet.buildanatom.modules.game.view.BuildAnAtomGameCanvas;
import edu.colorado.phet.buildanatom.modules.game.view.GamePeriodicTable;
import edu.colorado.phet.buildanatom.modules.game.view.ProblemDescriptionNode;
import edu.colorado.phet.buildanatom.modules.game.view.ProblemView;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;

public abstract class ToElementView
extends ProblemView {
    private final ProblemDescriptionNode description = new ProblemDescriptionNode(BuildAnAtomStrings.GAME_FIND_THE_ELEMENT);
    private final GamePeriodicTable gamePeriodicTable = new GamePeriodicTable(){
        {
            this.setOffset(BuildAnAtomDefaults.STAGE_SIZE.getWidth() * 0.715 - this.getFullBounds().getWidth() / 2.0, BuildAnAtomDefaults.STAGE_SIZE.getHeight() / 2.0 - this.getFullBounds().getHeight() / 2.0);
            this.scale(1.2);
            super.addJRadioButtonListener(new SimpleObserver(){

                public void update() {
                    ToElementView.this.enableCheckButton();
                }
            });
        }
    };

    ToElementView(BuildAnAtomGameModel buildAnAtomGameModel, BuildAnAtomGameCanvas buildAnAtomGameCanvas, Problem problem) {
        super(buildAnAtomGameModel, buildAnAtomGameCanvas, problem);
        this.description.centerAbove(this.gamePeriodicTable);
    }

    public void init() {
        super.init();
        this.addChild(this.description);
        this.addChild(this.gamePeriodicTable);
    }

    public void teardown() {
        super.teardown();
        this.removeChild(this.description);
        this.removeChild(this.gamePeriodicTable);
    }

    protected ImmutableAtom getGuess() {
        boolean bl = this.gamePeriodicTable.doesAtomChargeMatchGuess(this.getProblem().getAnswer());
        return new ImmutableAtom(this.gamePeriodicTable.getGuessedNumberProtons(), this.getProblem().getAnswer().getNumNeutrons(), bl ? this.getProblem().getAnswer().getNumElectrons() : this.getProblem().getAnswer().getNumElectrons() + 1);
    }

    protected void displayAnswer(ImmutableAtom immutableAtom) {
        this.gamePeriodicTable.setNumProtonsInAtom(immutableAtom.getNumProtons());
        this.gamePeriodicTable.setGuessNeutral(immutableAtom.isNeutral());
    }

    protected void setGuessEditable(boolean bl) {
        this.gamePeriodicTable.setPickable(bl);
        this.gamePeriodicTable.setChildrenPickable(bl);
    }
}

