/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildanatom.modules.game.view;

import edu.colorado.phet.buildanatom.model.Atom;
import edu.colorado.phet.buildanatom.model.AtomListener;
import edu.colorado.phet.buildanatom.model.Electron;
import edu.colorado.phet.buildanatom.model.ElectronShell;
import edu.colorado.phet.buildanatom.model.Neutron;
import edu.colorado.phet.buildanatom.model.Proton;
import edu.colorado.phet.buildanatom.model.SphericalParticle;
import edu.colorado.phet.buildanatom.view.ElectronNode;
import edu.colorado.phet.buildanatom.view.ElectronOrbitalNode;
import edu.colorado.phet.buildanatom.view.IsotopeElectronCloudNode;
import edu.colorado.phet.buildanatom.view.NeutronNode;
import edu.colorado.phet.buildanatom.view.OrbitalView;
import edu.colorado.phet.buildanatom.view.ProtonNode;
import edu.colorado.phet.buildanatom.view.ResizingElectronCloudNode;
import edu.colorado.phet.buildanatom.view.SubatomicParticleNode;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.umd.cs.piccolo.PNode;
import java.util.ArrayList;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchematicAtomNode
extends PNode {
    protected final Atom atom;
    private final ModelViewTransform mvt;
    private final Property<OrbitalView> orbitalViewProperty;
    private final ArrayList<PNode> nucleusLayers = new ArrayList(8);
    private final PNode nucleusLayersParentNode;
    protected final PNode electronShellLayer;
    private final PNode electronParticleLayer;
    protected final PNode frontLayer;
    private final boolean electronsAreInteractive;
    private final boolean protonsAreInteractive;
    private final boolean neutronsAreInteractive;
    private final ResizingElectronCloudNode electronCloudNode;
    private final IsotopeElectronCloudNode isotopeElectronCloudNode;

    public SchematicAtomNode(Atom atom, ModelViewTransform modelViewTransform, Property<OrbitalView> property) {
        this(atom, modelViewTransform, property, true, true, true);
    }

    public SchematicAtomNode(Atom atom, ModelViewTransform modelViewTransform, Property<OrbitalView> property, boolean bl, boolean bl2, boolean bl3) {
        this.protonsAreInteractive = bl;
        this.electronsAreInteractive = bl3;
        this.neutronsAreInteractive = bl2;
        this.atom = atom;
        this.mvt = modelViewTransform;
        this.orbitalViewProperty = property;
        this.electronShellLayer = new PNode();
        this.addChild(this.electronShellLayer);
        this.electronParticleLayer = new PNode();
        this.addChild(this.electronParticleLayer);
        this.nucleusLayersParentNode = new PNode();
        this.addChild(this.nucleusLayersParentNode);
        for (int i = 0; i < 8; ++i) {
            PNode object = new PNode();
            this.nucleusLayersParentNode.addChild(object);
            this.nucleusLayers.add(object);
        }
        Collections.reverse(this.nucleusLayers);
        this.frontLayer = new PNode();
        this.addChild(this.frontLayer);
        for (ElectronShell electronShell : atom.getElectronShells()) {
            this.electronShellLayer.addChild(new ElectronOrbitalNode(modelViewTransform, property, atom, electronShell, true));
        }
        this.electronCloudNode = new ResizingElectronCloudNode(modelViewTransform, property, atom);
        this.electronShellLayer.addChild(this.electronCloudNode);
        this.isotopeElectronCloudNode = new IsotopeElectronCloudNode(modelViewTransform, property, atom);
        this.electronShellLayer.addChild(this.isotopeElectronCloudNode);
        for (Electron electron : atom.getElectrons()) {
            this.addElectronNode(electron);
        }
        for (Proton proton : atom.getProtons()) {
            this.addProtonNode(proton);
        }
        for (Neutron neutron : atom.getNeutrons()) {
            this.addNeutronNode(neutron);
        }
    }

    protected IsotopeElectronCloudNode getIsotopeElectronCloudNode() {
        return this.isotopeElectronCloudNode;
    }

    private int mapNucleonToLayerNumber(SphericalParticle sphericalParticle) {
        double d = 30.0;
        double d2 = sphericalParticle.getPosition().distance(this.atom.getPosition());
        return Math.min((int)Math.floor(d2 / (d / 8.0)), 7);
    }

    private void updateNucleonLayer(SphericalParticle sphericalParticle, SubatomicParticleNode subatomicParticleNode) {
        int n;
        int n2 = this.getNucleusLayerIndex(subatomicParticleNode);
        if (n2 != (n = this.mapNucleonToLayerNumber(sphericalParticle))) {
            this.removeNucleonNodeFromLayers(subatomicParticleNode);
            this.nucleusLayers.get(n).addChild(subatomicParticleNode);
        }
    }

    private int getNucleusLayerIndex(SubatomicParticleNode subatomicParticleNode) {
        int n;
        for (n = 0; n < 8 && !this.nucleusLayers.get(n).isAncestorOf(subatomicParticleNode); ++n) {
        }
        return n;
    }

    private boolean removeNucleonNodeFromLayers(SubatomicParticleNode subatomicParticleNode) {
        boolean bl = false;
        for (PNode pNode : this.nucleusLayers) {
            if (pNode.removeChild(subatomicParticleNode) == null) continue;
            bl = true;
            break;
        }
        return bl;
    }

    protected void addProtonNode(final Proton proton) {
        final ProtonNode protonNode = new ProtonNode(this.mvt, proton);
        proton.addPositionListener(new SimpleObserver(){

            public void update() {
                if (!proton.isUserControlled()) {
                    SchematicAtomNode.this.updateNucleonLayer(proton, protonNode);
                }
            }
        });
        proton.addListener(new SphericalParticle.Adapter(){

            public void removedFromModel(SphericalParticle sphericalParticle) {
                SchematicAtomNode.this.removeNucleonNodeFromLayers(protonNode);
                proton.removeListener(this);
            }
        });
        if (!this.protonsAreInteractive) {
            protonNode.setPickable(false);
            protonNode.setChildrenPickable(false);
        }
        this.nucleusLayers.get(this.mapNucleonToLayerNumber(proton)).addChild(protonNode);
    }

    protected void addNeutronNode(final Neutron neutron) {
        final NeutronNode neutronNode = new NeutronNode(this.mvt, neutron);
        neutron.addPositionListener(new SimpleObserver(){

            public void update() {
                if (!neutron.isUserControlled()) {
                    SchematicAtomNode.this.updateNucleonLayer(neutron, neutronNode);
                }
            }
        });
        neutron.addListener(new SphericalParticle.Adapter(){

            public void removedFromModel(SphericalParticle sphericalParticle) {
                SchematicAtomNode.this.removeNucleonNodeFromLayers(neutronNode);
                neutron.removeListener(this);
            }
        });
        if (!this.neutronsAreInteractive) {
            neutronNode.setPickable(false);
            neutronNode.setChildrenPickable(false);
        }
        this.nucleusLayers.get(this.mapNucleonToLayerNumber(neutron)).addChild(neutronNode);
    }

    protected void addElectronNode(final Electron electron) {
        final ElectronNode electronNode = new ElectronNode(this.mvt, electron){
            {
                super(modelViewTransform, sphericalParticle);
                SchematicAtomNode.this.orbitalViewProperty.addObserver(new SimpleObserver(){

                    public void update() {
                        this.setVisible(SchematicAtomNode.this.orbitalViewProperty.get() == OrbitalView.PARTICLES || !SchematicAtomNode.this.atom.containsElectron(electron));
                    }
                });
                SchematicAtomNode.this.atom.addAtomListener(new AtomListener.Adapter(){

                    public void configurationChanged() {
                        this.setVisible(SchematicAtomNode.this.orbitalViewProperty.get() == OrbitalView.PARTICLES || !SchematicAtomNode.this.atom.containsElectron(electron));
                    }
                });
            }
        };
        this.electronParticleLayer.addChild(electronNode);
        electron.addListener(new SphericalParticle.Adapter(){

            public void removedFromModel(SphericalParticle sphericalParticle) {
                SchematicAtomNode.this.electronParticleLayer.removeChild(electronNode);
                electron.removeListener(this);
            }
        });
        if (!this.electronsAreInteractive) {
            electronNode.setPickable(false);
            electronNode.setChildrenPickable(false);
        }
    }

    protected void addParticleNode(SphericalParticle sphericalParticle) {
        if (sphericalParticle instanceof Neutron) {
            this.addNeutronNode((Neutron)sphericalParticle);
        } else if (sphericalParticle instanceof Proton) {
            this.addProtonNode((Proton)sphericalParticle);
        } else if (sphericalParticle instanceof Electron) {
            this.addElectronNode((Electron)sphericalParticle);
        }
    }
}

