/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildanatom.modules.game.view;

import edu.colorado.phet.buildanatom.BuildAnAtomConstants;
import edu.colorado.phet.buildanatom.BuildAnAtomStrings;
import edu.colorado.phet.buildanatom.model.ImmutableAtom;
import edu.colorado.phet.buildanatom.modules.game.model.SimpleAtom;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.periodictable.CellFactory;
import edu.colorado.phet.common.piccolophet.nodes.periodictable.ElementCell;
import edu.colorado.phet.common.piccolophet.nodes.periodictable.HighlightingElementCell;
import edu.colorado.phet.common.piccolophet.nodes.periodictable.PeriodicTableAtom;
import edu.colorado.phet.common.piccolophet.nodes.periodictable.PeriodicTableNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class GamePeriodicTable
extends PNode {
    private final ArrayList<SimpleObserver> jradioButtonListeners = new ArrayList();
    private final SimpleAtom atom = new SimpleAtom();
    private final Property<ChargeGuess> chargeGuessProperty = new Property<ChargeGuess>(ChargeGuess.UNANSWERED);
    private final PNode selectNeutralOrIonTypeNode;

    public GamePeriodicTable() {
        PSwing pSwing = new PSwing(new JPanel(){
            {
                final PhetFont phetFont = new PhetFont(20);
                this.setOpaque(false);
                this.setBackground(BuildAnAtomConstants.CANVAS_BACKGROUND);
                this.add(new JRadioButton(BuildAnAtomStrings.GAME_NEUTRAL_ATOM){
                    {
                        super(string);
                        this.setOpaque(false);
                        this.setFont(phetFont);
                        this.setBackground(BuildAnAtomConstants.CANVAS_BACKGROUND);
                        final SimpleObserver simpleObserver = new SimpleObserver(){

                            public void update() {
                                this.setSelected(GamePeriodicTable.this.chargeGuessProperty.get() == ChargeGuess.NEUTRAL_ATOM);
                            }
                        };
                        GamePeriodicTable.this.chargeGuessProperty.addObserver(simpleObserver);
                        this.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                GamePeriodicTable.this.chargeGuessProperty.set(ChargeGuess.NEUTRAL_ATOM);
                                simpleObserver.update();
                                GamePeriodicTable.this.notifyRadioButtonPressed();
                            }
                        });
                    }
                });
                this.add(new JRadioButton(BuildAnAtomStrings.GAME_ION){
                    {
                        super(string);
                        this.setOpaque(false);
                        this.setFont(phetFont);
                        this.setBackground(BuildAnAtomConstants.CANVAS_BACKGROUND);
                        final SimpleObserver simpleObserver = new SimpleObserver(){

                            public void update() {
                                this.setSelected(GamePeriodicTable.this.chargeGuessProperty.get() == ChargeGuess.ION);
                            }
                        };
                        GamePeriodicTable.this.chargeGuessProperty.addObserver(simpleObserver);
                        this.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                GamePeriodicTable.this.chargeGuessProperty.set(ChargeGuess.ION);
                                simpleObserver.update();
                                GamePeriodicTable.this.notifyRadioButtonPressed();
                            }
                        });
                    }
                });
            }
        });
        this.selectNeutralOrIonTypeNode = new PNode();
        PText pText = new PText(BuildAnAtomStrings.IS_IT){
            {
                this.setFont(new PhetFont(30, true));
            }
        };
        this.selectNeutralOrIonTypeNode.addChild(pText);
        pSwing.setOffset(pText.getFullBoundsReference().width + 5.0, pText.getFullBoundsReference().height * 0.6 - pSwing.getFullBoundsReference().height / 2.0);
        this.selectNeutralOrIonTypeNode.addChild(pSwing);
        this.addChild(this.selectNeutralOrIonTypeNode);
        this.selectNeutralOrIonTypeNode.setVisible(false);
        PeriodicTableNode periodicTableNode = new PeriodicTableNode(BuildAnAtomConstants.CANVAS_BACKGROUND, new CellFactory(){

            public ElementCell createCellForElement(int n, Color color) {
                return new SelectableElementCell(GamePeriodicTable.this, GamePeriodicTable.this.atom, n, color);
            }
        });
        this.addChild(periodicTableNode);
        this.selectNeutralOrIonTypeNode.setOffset(periodicTableNode.getFullBoundsReference().getCenterX() - this.selectNeutralOrIonTypeNode.getFullBoundsReference().width / 2.0, periodicTableNode.getFullBoundsReference().getMaxY() + 30.0);
    }

    private void notifyRadioButtonPressed() {
        for (SimpleObserver simpleObserver : this.jradioButtonListeners) {
            simpleObserver.update();
        }
    }

    public int getGuessedNumberProtons() {
        return this.atom.getNumProtons();
    }

    public void setNumProtonsInAtom(int n) {
        this.atom.setNumProtons(n);
    }

    public boolean doesAtomChargeMatchGuess(ImmutableAtom immutableAtom) {
        if (this.chargeGuessProperty.get() == ChargeGuess.UNANSWERED) {
            return false;
        }
        return immutableAtom.isNeutral() && this.chargeGuessProperty.get() == ChargeGuess.NEUTRAL_ATOM || !immutableAtom.isNeutral() && this.chargeGuessProperty.get() == ChargeGuess.ION;
    }

    public void setGuessNeutral(boolean bl) {
        if (bl) {
            this.chargeGuessProperty.set(ChargeGuess.NEUTRAL_ATOM);
        } else {
            this.chargeGuessProperty.set(ChargeGuess.ION);
        }
        this.selectNeutralOrIonTypeNode.setVisible(true);
    }

    public void addJRadioButtonListener(SimpleObserver simpleObserver) {
        this.jradioButtonListeners.add(simpleObserver);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ChargeGuess
    extends Enum<ChargeGuess> {
        public static final /* enum */ ChargeGuess UNANSWERED = new ChargeGuess();
        public static final /* enum */ ChargeGuess NEUTRAL_ATOM = new ChargeGuess();
        public static final /* enum */ ChargeGuess ION = new ChargeGuess();
        private static final /* synthetic */ ChargeGuess[] $VALUES;

        public static ChargeGuess[] values() {
            return (ChargeGuess[])$VALUES.clone();
        }

        static {
            $VALUES = new ChargeGuess[]{UNANSWERED, NEUTRAL_ATOM, ION};
        }
    }

    private static class SelectableElementCell
    extends HighlightingElementCell {
        public SelectableElementCell(final GamePeriodicTable gamePeriodicTable, PeriodicTableAtom periodicTableAtom, int n, Color color) {
            super(periodicTableAtom, n, color);
            this.addInputEventListener(new CursorHandler());
            this.addInputEventListener(new PBasicInputEventHandler(){

                public void mousePressed(PInputEvent pInputEvent) {
                    gamePeriodicTable.setNumProtonsInAtom(SelectableElementCell.this.getAtomicNumber());
                    gamePeriodicTable.selectNeutralOrIonTypeNode.setVisible(true);
                }
            });
        }
    }
}

