/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildanatom.modules.game.view;

import edu.colorado.phet.buildanatom.BuildAnAtomConstants;
import edu.colorado.phet.buildanatom.BuildAnAtomDefaults;
import edu.colorado.phet.buildanatom.modules.game.model.BuildAnAtomGameModel;
import edu.colorado.phet.buildanatom.modules.game.model.State;
import edu.colorado.phet.buildanatom.modules.game.view.StateView;
import edu.colorado.phet.common.games.GameScoreboardNode;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.umd.cs.piccolo.PNode;
import java.awt.Color;
import java.awt.geom.Dimension2D;
import java.text.DecimalFormat;

public class BuildAnAtomGameCanvas
extends PhetPCanvas {
    public static final Color BUTTONS_COLOR = new Color(255, 255, 0, 150);
    private final PNode rootNode;
    private final GameScoreboardNode scoreboard;
    private StateView currentView;

    public BuildAnAtomGameCanvas(final BuildAnAtomGameModel buildAnAtomGameModel) {
        this.scoreboard = new GameScoreboardNode(4, buildAnAtomGameModel.getMaximumPossibleScore(), new DecimalFormat("0.#")){
            {
                super(n, d, numberFormat);
                this.setBackgroundWidth(BuildAnAtomDefaults.STAGE_SIZE.width * 0.85);
                buildAnAtomGameModel.getGameClock().addClockListener(new ClockAdapter(){

                    public void simulationTimeChanged(ClockEvent clockEvent) {
                        if (buildAnAtomGameModel.isTimerEnabled() && buildAnAtomGameModel.isBestTimeRecorded(buildAnAtomGameModel.getLevel())) {
                            this.setTime(buildAnAtomGameModel.getTime(), buildAnAtomGameModel.getBestTime(buildAnAtomGameModel.getLevel()));
                        } else {
                            this.setTime(buildAnAtomGameModel.getTime());
                        }
                    }
                });
                buildAnAtomGameModel.getScoreProperty().addObserver(new SimpleObserver(){

                    public void update() {
                        this.setScore(buildAnAtomGameModel.getScoreProperty().get().intValue());
                    }
                });
                buildAnAtomGameModel.getGameSettings().timerEnabled.addObserver(new SimpleObserver(){

                    public void update() {
                        this.setTimerVisible((Boolean)buildAnAtomGameModel.getGameSettings().timerEnabled.get());
                    }
                });
                buildAnAtomGameModel.getGameSettings().level.addObserver(new SimpleObserver(){

                    public void update() {
                        this.setLevel((Integer)buildAnAtomGameModel.getGameSettings().level.get());
                    }
                });
            }
        };
        this.scoreboard.addGameScoreboardListener(new GameScoreboardNode.GameScoreboardListener(){

            public void newGamePressed() {
                buildAnAtomGameModel.newGame();
            }
        });
        this.setWorldTransformStrategy(new PhetPCanvas.CenteredStage(this, BuildAnAtomDefaults.STAGE_SIZE));
        this.rootNode = new PNode();
        this.addWorldChild(this.rootNode);
        this.setBackground(BuildAnAtomConstants.CANVAS_BACKGROUND);
        buildAnAtomGameModel.addListener(new BuildAnAtomGameModel.GameModelListener(){

            public void stateChanged(State state, State state2) {
                BuildAnAtomGameCanvas.this.currentView.teardown();
                BuildAnAtomGameCanvas.this.currentView = BuildAnAtomGameCanvas.this.createView(state2);
                BuildAnAtomGameCanvas.this.currentView.init();
            }
        });
        this.currentView = this.createView(buildAnAtomGameModel.getState());
        this.currentView.init();
    }

    public StateView createView(State state) {
        return state.createView(this);
    }

    protected void updateLayout() {
        Dimension2D dimension2D = this.getWorldSize();
        if (dimension2D.getWidth() <= 0.0 || dimension2D.getHeight() <= 0.0) {
            return;
        }
    }

    public GameScoreboardNode getScoreboard() {
        return this.scoreboard;
    }

    public PNode getRootNode() {
        return this.rootNode;
    }
}

