/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildanatom.modules.game.model;

import edu.colorado.phet.buildanatom.developer.ProblemTypeSelectionDialog;
import edu.colorado.phet.buildanatom.model.ImmutableAtom;
import edu.colorado.phet.buildanatom.modules.game.model.BuildAnAtomGameModel;
import edu.colorado.phet.buildanatom.modules.game.model.CountsToChargeQuestionProblem;
import edu.colorado.phet.buildanatom.modules.game.model.CountsToElementProblem;
import edu.colorado.phet.buildanatom.modules.game.model.CountsToMassQuestionProblem;
import edu.colorado.phet.buildanatom.modules.game.model.CountsToSymbolProblem;
import edu.colorado.phet.buildanatom.modules.game.model.Problem;
import edu.colorado.phet.buildanatom.modules.game.model.ProblemType;
import edu.colorado.phet.buildanatom.modules.game.model.SchematicToChargeQuestionProblem;
import edu.colorado.phet.buildanatom.modules.game.model.SchematicToElementProblem;
import edu.colorado.phet.buildanatom.modules.game.model.SchematicToMassQuestionProblem;
import edu.colorado.phet.buildanatom.modules.game.model.SchematicToSymbolProblem;
import edu.colorado.phet.buildanatom.modules.game.model.SymbolToCountsProblem;
import edu.colorado.phet.buildanatom.modules.game.model.SymbolToSchematicProblem;
import edu.colorado.phet.common.phetcommon.util.function.Function1;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProblemSet {
    public static final Random RAND = new Random();
    private final ArrayList<Problem> problems = new ArrayList();
    private ArrayList<ProblemType> availableProblemTypes = new ArrayList();
    private ProblemType previousProblemType = null;
    private int currentProblemIndex = 0;
    private static final ArrayList<ProblemType> LEVEL_1_ALLOWED_PROB_TYPES = new ArrayList<ProblemType>(){
        {
            this.add(ProblemType.SCHEMATIC_TO_ELEMENT);
            this.add(ProblemType.COUNTS_TO_ELEMENT);
        }
    };
    private static final ArrayList<ProblemType> LEVEL_2_ALLOWED_PROB_TYPES = new ArrayList<ProblemType>(){
        {
            this.add(ProblemType.COUNTS_TO_CHARGE_QUESTION);
            this.add(ProblemType.COUNTS_TO_MASS_QUESTION);
            this.add(ProblemType.SCHEMATIC_TO_CHARGE_QUESTION);
            this.add(ProblemType.SCHEMATIC_TO_MASS_QUESTION);
        }
    };
    private static final ArrayList<ProblemType> LEVEL_3_ALLOWED_PROB_TYPES = new ArrayList<ProblemType>(){
        {
            this.add(ProblemType.SCHEMATIC_TO_SYMBOL_CHARGE);
            this.add(ProblemType.SCHEMATIC_TO_SYMBOL_MASS);
            this.add(ProblemType.SCHEMATIC_TO_SYMBOL_PROTON_COUNT);
            this.add(ProblemType.COUNTS_TO_SYMBOL_CHARGE);
            this.add(ProblemType.COUNTS_TO_SYMBOL_MASS);
        }
    };
    private static final ArrayList<ProblemType> LEVEL_4_ALLOWED_PROB_TYPES = new ArrayList<ProblemType>(){
        {
            this.add(ProblemType.SCHEMATIC_TO_SYMBOL_ALL);
            this.add(ProblemType.SYMBOL_TO_SCHEMATIC);
            this.add(ProblemType.SYMBOL_TO_COUNTS);
            this.add(ProblemType.COUNTS_TO_SYMBOL_ALL);
        }
    };
    private static final HashMap<Integer, ArrayList<ProblemType>> mapLevelToProbTypes = new HashMap<Integer, ArrayList<ProblemType>>(){
        {
            this.put(1, LEVEL_1_ALLOWED_PROB_TYPES);
            this.put(2, LEVEL_2_ALLOWED_PROB_TYPES);
            this.put(3, LEVEL_3_ALLOWED_PROB_TYPES);
            this.put(4, LEVEL_4_ALLOWED_PROB_TYPES);
        }
    };

    public ProblemSet(BuildAnAtomGameModel buildAnAtomGameModel, int n) {
        AtomValuePool atomValuePool = new AtomValuePool(buildAnAtomGameModel);
        for (int i = this.problems.size(); i < n; ++i) {
            Problem problem = this.generateProblem(buildAnAtomGameModel, atomValuePool);
            if (problem == null) continue;
            this.addProblem(problem);
        }
        if (this.problems.size() == 0) {
            System.err.println(this.getClass().getName() + " - Warning: Empty problem set, probably due to developer dialog settings.");
        }
    }

    private void addProblem(Problem problem) {
        this.problems.add(problem);
    }

    public int getProblemIndex(Problem problem) {
        return this.problems.indexOf(problem);
    }

    public int getTotalNumProblems() {
        return this.problems.size();
    }

    public Problem getCurrentProblem() {
        return this.problems.get(this.currentProblemIndex);
    }

    public boolean isLastProblem() {
        return this.currentProblemIndex == this.problems.size() - 1;
    }

    public Problem nextProblem() {
        assert (!this.isLastProblem());
        ++this.currentProblemIndex;
        return this.getCurrentProblem();
    }

    private ArrayList<ProblemType> filterProblemTypes(ArrayList<ProblemType> arrayList) {
        ArrayList<ProblemType> arrayList2 = new ArrayList<ProblemType>();
        ProblemTypeSelectionDialog problemTypeSelectionDialog = ProblemTypeSelectionDialog.getInstance();
        for (ProblemType problemType : arrayList) {
            if (!problemTypeSelectionDialog.isProblemTypeAllowed(problemType)) continue;
            arrayList2.add(problemType);
        }
        return arrayList2;
    }

    private Problem generateProblem(BuildAnAtomGameModel buildAnAtomGameModel, AtomValuePool atomValuePool) {
        ProblemType problemType;
        if (this.availableProblemTypes.size() == 0) {
            this.availableProblemTypes.addAll((Collection<ProblemType>)mapLevelToProbTypes.get(buildAnAtomGameModel.getLevel()));
            this.availableProblemTypes = this.filterProblemTypes(this.availableProblemTypes);
        }
        if (this.availableProblemTypes.size() == 0) {
            System.err.println(this.getClass().getName() + " - Warning: No problem types enabled for level " + buildAnAtomGameModel.getLevel());
            return null;
        }
        int n = RAND.nextInt(this.availableProblemTypes.size());
        if (this.previousProblemType != null && this.availableProblemTypes.get(n) == this.previousProblemType && this.availableProblemTypes.size() > 1) {
            n = (n + 1) % this.availableProblemTypes.size();
        }
        this.previousProblemType = problemType = this.availableProblemTypes.get(n);
        this.availableProblemTypes.remove((Object)problemType);
        int n2 = 0;
        int n3 = Integer.MAX_VALUE;
        boolean bl = false;
        if (this.isSchematicProbType(problemType)) {
            n3 = 3;
        } else {
            n2 = 4;
        }
        if (this.isChargeProbType(problemType)) {
            bl = RAND.nextBoolean();
        }
        ImmutableAtom immutableAtom = atomValuePool.getRandomAtomValue(n2, n3, bl);
        atomValuePool.markAtomAsUsed(immutableAtom);
        return this.createProblem(buildAnAtomGameModel, problemType, immutableAtom);
    }

    private Problem createProblem(BuildAnAtomGameModel buildAnAtomGameModel, ProblemType problemType, ImmutableAtom immutableAtom) {
        Problem problem = null;
        switch (problemType) {
            case COUNTS_TO_ELEMENT: {
                problem = new CountsToElementProblem(buildAnAtomGameModel, immutableAtom);
                break;
            }
            case COUNTS_TO_CHARGE_QUESTION: {
                problem = new CountsToChargeQuestionProblem(buildAnAtomGameModel, immutableAtom);
                break;
            }
            case COUNTS_TO_MASS_QUESTION: {
                problem = new CountsToMassQuestionProblem(buildAnAtomGameModel, immutableAtom);
                break;
            }
            case COUNTS_TO_SYMBOL_ALL: {
                problem = new CountsToSymbolProblem(buildAnAtomGameModel, immutableAtom, true, true, true);
                break;
            }
            case COUNTS_TO_SYMBOL_CHARGE: {
                problem = new CountsToSymbolProblem(buildAnAtomGameModel, immutableAtom, false, false, true);
                break;
            }
            case COUNTS_TO_SYMBOL_MASS: {
                problem = new CountsToSymbolProblem(buildAnAtomGameModel, immutableAtom, false, true, false);
                break;
            }
            case COUNTS_TO_SYMBOL_PROTON_COUNT: {
                problem = new CountsToSymbolProblem(buildAnAtomGameModel, immutableAtom, true, false, false);
                break;
            }
            case SCHEMATIC_TO_ELEMENT: {
                problem = new SchematicToElementProblem(buildAnAtomGameModel, immutableAtom);
                break;
            }
            case SCHEMATIC_TO_CHARGE_QUESTION: {
                problem = new SchematicToChargeQuestionProblem(buildAnAtomGameModel, immutableAtom);
                break;
            }
            case SCHEMATIC_TO_MASS_QUESTION: {
                problem = new SchematicToMassQuestionProblem(buildAnAtomGameModel, immutableAtom);
                break;
            }
            case SCHEMATIC_TO_SYMBOL_ALL: {
                problem = new SchematicToSymbolProblem(buildAnAtomGameModel, immutableAtom, true, true, true);
                break;
            }
            case SCHEMATIC_TO_SYMBOL_CHARGE: {
                problem = new SchematicToSymbolProblem(buildAnAtomGameModel, immutableAtom, false, false, true);
                break;
            }
            case SCHEMATIC_TO_SYMBOL_MASS: {
                problem = new SchematicToSymbolProblem(buildAnAtomGameModel, immutableAtom, false, true, false);
                break;
            }
            case SCHEMATIC_TO_SYMBOL_PROTON_COUNT: {
                problem = new SchematicToSymbolProblem(buildAnAtomGameModel, immutableAtom, true, false, false);
                break;
            }
            case SYMBOL_TO_COUNTS: {
                problem = new SymbolToCountsProblem(buildAnAtomGameModel, immutableAtom);
                break;
            }
            case SYMBOL_TO_SCHEMATIC: {
                problem = new SymbolToSchematicProblem(buildAnAtomGameModel, immutableAtom);
                break;
            }
            default: {
                System.err.println(this.getClass().getName() + " - Error: Request to create unknown problem type.");
            }
        }
        return problem;
    }

    private boolean isSchematicProbType(ProblemType problemType) {
        return problemType == ProblemType.SCHEMATIC_TO_ELEMENT || problemType == ProblemType.SCHEMATIC_TO_CHARGE_QUESTION || problemType == ProblemType.SCHEMATIC_TO_MASS_QUESTION || problemType == ProblemType.SCHEMATIC_TO_SYMBOL_ALL || problemType == ProblemType.SCHEMATIC_TO_SYMBOL_PROTON_COUNT || problemType == ProblemType.SCHEMATIC_TO_SYMBOL_CHARGE || problemType == ProblemType.SCHEMATIC_TO_SYMBOL_MASS || problemType == ProblemType.SYMBOL_TO_SCHEMATIC;
    }

    private boolean isChargeProbType(ProblemType problemType) {
        return problemType == ProblemType.SCHEMATIC_TO_CHARGE_QUESTION || problemType == ProblemType.COUNTS_TO_CHARGE_QUESTION || problemType == ProblemType.COUNTS_TO_SYMBOL_CHARGE || problemType == ProblemType.SCHEMATIC_TO_SYMBOL_CHARGE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AtomValuePool {
        private static final Random AVP_RAND = new Random();
        private final ArrayList<ImmutableAtom> remainingAtomValues;
        private final ArrayList<ImmutableAtom> usedAtomValues = new ArrayList();

        public AtomValuePool(BuildAnAtomGameModel buildAnAtomGameModel) {
            this.remainingAtomValues = new ArrayList<ImmutableAtom>(buildAnAtomGameModel.getLevelPool());
        }

        public boolean markAtomAsUsed(ImmutableAtom immutableAtom) {
            if (this.remainingAtomValues.remove(immutableAtom)) {
                this.usedAtomValues.add(immutableAtom);
                return true;
            }
            return false;
        }

        public ImmutableAtom getRandomAtomValue(final int n, final int n2, final boolean bl) {
            return this.getRandomAtomValue(new Function1<ImmutableAtom, Boolean>(){

                @Override
                public Boolean apply(ImmutableAtom immutableAtom) {
                    if (immutableAtom.getNumProtons() >= n && immutableAtom.getNumProtons() <= n2) {
                        if (bl) {
                            if (!immutableAtom.isNeutral()) {
                                return true;
                            }
                        } else {
                            return true;
                        }
                    }
                    return false;
                }
            });
        }

        private ImmutableAtom getRandomAtomValue(Function1<ImmutableAtom, Boolean> function1) {
            ArrayList<ImmutableAtom> arrayList = new ArrayList<ImmutableAtom>();
            for (ImmutableAtom immutableAtom : this.remainingAtomValues) {
                if (!function1.apply(immutableAtom).booleanValue()) continue;
                arrayList.add(immutableAtom);
            }
            if (arrayList.size() == 0) {
                System.err.println(this.getClass().getName() + " - Warning: No remaining atoms values that meet the criteria.");
                for (ImmutableAtom immutableAtom : this.usedAtomValues) {
                    if (!function1.apply(immutableAtom).booleanValue()) continue;
                    arrayList.add(immutableAtom);
                }
            }
            Iterator<ImmutableAtom> iterator = null;
            if (arrayList.size() > 0) {
                iterator = (ImmutableAtom)arrayList.get(AVP_RAND.nextInt(arrayList.size()));
            } else {
                System.err.println(this.getClass().getName() + " - Error: No atoms found below specified size threshold.");
            }
            return iterator;
        }
    }
}

