/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildanatom.modules.game.model;

import edu.colorado.phet.buildanatom.model.ImmutableAtom;
import edu.colorado.phet.buildanatom.modules.game.model.BuildAnAtomGameModel;
import edu.colorado.phet.buildanatom.modules.game.model.State;

public abstract class Problem
extends State {
    private final ImmutableAtom atom;
    private int numGuesses = 0;
    private int score = 0;
    private boolean solvedCorrectly = false;

    public Problem(BuildAnAtomGameModel buildAnAtomGameModel, ImmutableAtom immutableAtom) {
        super(buildAnAtomGameModel);
        this.atom = immutableAtom;
    }

    public boolean isGuessCorrect(ImmutableAtom immutableAtom) {
        return this.atom.equals(immutableAtom);
    }

    public void processGuess(ImmutableAtom immutableAtom) {
        ++this.numGuesses;
        if (this.isGuessCorrect(immutableAtom)) {
            this.solvedCorrectly = true;
            if (this.numGuesses == 1) {
                this.score = 2;
            } else if (this.numGuesses == 2) {
                this.score = 1;
            }
        }
    }

    public int getNumGuesses() {
        return this.numGuesses;
    }

    public boolean isSolvedCorrectly() {
        return this.solvedCorrectly;
    }

    public Integer getScore() {
        return this.score;
    }

    public ImmutableAtom getAnswer() {
        return this.atom;
    }
}

