/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.api;

import java.util.BitSet;
import org.jmol.api.JmolEdge;
import org.jmol.api.JmolNode;
import org.jmol.util.Elements;

public class JmolMolecule {
    public JmolNode[] nodes;
    public int moleculeIndex;
    public int modelIndex;
    public int indexInModel;
    public int firstAtomIndex;
    public int atomCount;
    public int nElements;
    public int[] elementCounts = new int[Elements.elementNumberMax];
    public int[] altElementCounts = new int[Elements.altElementMax];
    public int elementNumberMax;
    public int altElementMax;
    public String mf;
    public BitSet atomList;

    public JmolMolecule() {
    }

    public static final JmolMolecule[] getMolecules(JmolNode[] jmolNodeArray, BitSet[] bitSetArray, JmolMolecule[] jmolMoleculeArray, int n, BitSet bitSet) {
        BitSet bitSet2 = null;
        BitSet bitSet3 = new BitSet();
        int n2 = -1;
        int n3 = 0;
        if (jmolMoleculeArray == null) {
            jmolMoleculeArray = new JmolMolecule[4];
        }
        if (bitSetArray == null) {
            bitSet2 = new BitSet();
            bitSet2.set(0, jmolNodeArray.length);
        }
        if (bitSet == null) {
            bitSet = new BitSet();
        }
        for (int i = 0; i < jmolNodeArray.length; ++i) {
            if (bitSet.get(i) || bitSet3.get(i)) continue;
            if (jmolNodeArray[i].isDeleted()) {
                bitSet.set(i);
                continue;
            }
            int n4 = jmolNodeArray[i].getModelIndex();
            if (n4 != n2) {
                n2 = n4;
                n3 = 0;
                if (bitSetArray != null) {
                    bitSet2 = bitSetArray[n4];
                }
            }
            if ((bitSet3 = JmolMolecule.getBranchBitSet(jmolNodeArray, bitSet2, i, -1, true, true)).nextSetBit(0) < 0) continue;
            jmolMoleculeArray = JmolMolecule.addMolecule(jmolMoleculeArray, n++, jmolNodeArray, i, bitSet3, n4, n3++, bitSet);
        }
        return JmolMolecule.allocateArray(jmolMoleculeArray, n);
    }

    public static BitSet getBranchBitSet(JmolNode[] jmolNodeArray, BitSet bitSet, int n, int n2, boolean bl, boolean bl2) {
        BitSet bitSet2 = new BitSet(jmolNodeArray.length);
        if (n < 0) {
            return bitSet2;
        }
        if (n2 >= 0) {
            bitSet.clear(n2);
        }
        return JmolMolecule.getCovalentlyConnectedBitSet(jmolNodeArray[n], bitSet, bl, bl2, bitSet2) ? bitSet2 : new BitSet();
    }

    public static final JmolMolecule[] addMolecule(JmolMolecule[] jmolMoleculeArray, int n, JmolNode[] jmolNodeArray, int n2, BitSet bitSet, int n3, int n4, BitSet bitSet2) {
        bitSet2.or(bitSet);
        if (n == jmolMoleculeArray.length) {
            jmolMoleculeArray = JmolMolecule.allocateArray(jmolMoleculeArray, n * 2 + 1);
        }
        jmolMoleculeArray[n] = new JmolMolecule(jmolNodeArray, n, n2, bitSet, n3, n4);
        return jmolMoleculeArray;
    }

    public static String getMolecularFormula(JmolNode[] jmolNodeArray, BitSet bitSet, boolean bl) {
        JmolMolecule jmolMolecule = new JmolMolecule();
        jmolMolecule.nodes = jmolNodeArray;
        jmolMolecule.atomList = bitSet;
        return jmolMolecule.getMolecularFormula(bl);
    }

    public String getMolecularFormula(boolean bl) {
        int n;
        int n2;
        if (this.mf != null) {
            return this.mf;
        }
        this.getElementAndAtomCount(bl);
        String string = "";
        String string2 = "";
        for (n2 = 1; n2 <= this.elementNumberMax; ++n2) {
            n = this.elementCounts[n2];
            if (n == 0) continue;
            string = string + string2 + Elements.elementSymbolFromNumber(n2) + " " + n;
            string2 = " ";
        }
        for (n2 = 1; n2 <= this.altElementMax; ++n2) {
            n = this.altElementCounts[n2];
            if (n == 0) continue;
            string = string + string2 + Elements.elementSymbolFromNumber(Elements.altElementNumberFromIndex(n2)) + " " + n;
            string2 = " ";
        }
        return string;
    }

    private JmolMolecule(JmolNode[] jmolNodeArray, int n, int n2, BitSet bitSet, int n3, int n4) {
        this.nodes = jmolNodeArray;
        this.firstAtomIndex = n2;
        this.atomList = bitSet;
        this.moleculeIndex = n;
        this.modelIndex = n3;
        this.indexInModel = n4;
    }

    private void getElementAndAtomCount(boolean bl) {
        if (this.atomList == null) {
            this.atomList = new BitSet();
            this.atomList.set(0, this.nodes.length);
        }
        this.elementCounts = new int[Elements.elementNumberMax];
        this.altElementCounts = new int[Elements.altElementMax];
        int n = 0;
        int n2 = this.atomList.nextSetBit(0);
        while (n2 >= 0) {
            ++n;
            int n3 = this.nodes[n2].getAtomicAndIsotopeNumber();
            if (n3 < Elements.elementNumberMax) {
                int n4;
                int n5 = n3;
                this.elementCounts[n5] = this.elementCounts[n5] + 1;
                if (this.elementCounts[n3] == 1) {
                    ++this.nElements;
                }
                this.elementNumberMax = Math.max(this.elementNumberMax, n3);
                if (bl && (n4 = this.nodes[n2].getImplicitHydrogenCount()) > 0) {
                    if (this.elementCounts[1] == 0) {
                        ++this.nElements;
                    }
                    this.elementCounts[1] = this.elementCounts[1] + n4;
                }
            } else {
                int n6 = n3 = Elements.altElementIndexFromNumber(n3);
                this.altElementCounts[n6] = this.altElementCounts[n6] + 1;
                if (this.altElementCounts[n3] == 1) {
                    ++this.nElements;
                }
                this.altElementMax = Math.max(this.altElementMax, n3);
            }
            n2 = this.atomList.nextSetBit(n2 + 1);
        }
        this.atomCount = n;
    }

    private static boolean getCovalentlyConnectedBitSet(JmolNode jmolNode, BitSet bitSet, boolean bl, boolean bl2, BitSet bitSet2) {
        int n = jmolNode.getIndex();
        if (!bitSet.get(n)) {
            return bl;
        }
        if (!bl2 && jmolNode.getGroupType().length() > 0) {
            return bl;
        }
        bitSet.clear(n);
        bitSet2.set(n);
        JmolEdge[] jmolEdgeArray = jmolNode.getEdges();
        if (jmolEdgeArray == null) {
            return true;
        }
        int n2 = jmolEdgeArray.length;
        while (--n2 >= 0) {
            JmolEdge jmolEdge = jmolEdgeArray[n2];
            if (!jmolEdge.isCovalent() || JmolMolecule.getCovalentlyConnectedBitSet(jmolEdge.getOtherAtom(jmolNode), bitSet, bl, bl2, bitSet2)) continue;
            return false;
        }
        return true;
    }

    private static JmolMolecule[] allocateArray(JmolMolecule[] jmolMoleculeArray, int n) {
        if (jmolMoleculeArray.length == n) {
            return jmolMoleculeArray;
        }
        JmolMolecule[] jmolMoleculeArray2 = new JmolMolecule[n];
        System.arraycopy(jmolMoleculeArray, 0, jmolMoleculeArray2, 0, n < jmolMoleculeArray.length ? n : jmolMoleculeArray.length);
        return jmolMoleculeArray2;
    }
}

