/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildamolecule.view;

import edu.colorado.phet.buildamolecule.BuildAMoleculeConstants;
import edu.colorado.phet.buildamolecule.BuildAMoleculeResources;
import edu.colorado.phet.buildamolecule.model.Atom2D;
import edu.colorado.phet.buildamolecule.model.CompleteMolecule;
import edu.colorado.phet.buildamolecule.model.Kit;
import edu.colorado.phet.buildamolecule.model.Molecule;
import edu.colorado.phet.buildamolecule.view.view3d.JmolDialogProperty;
import edu.colorado.phet.buildamolecule.view.view3d.ShowMolecule3DButtonNode;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;

public class MoleculeMetadataNode
extends PNode {
    private Molecule molecule;
    private final JmolDialogProperty dialog = new JmolDialogProperty();
    private Map<Atom2D, SimpleObserver> observerMap = new HashMap<Atom2D, SimpleObserver>();

    public MoleculeMetadataNode(final Kit kit, final Molecule molecule) {
        this.molecule = molecule;
        if (molecule.getAtoms().size() < 2) {
            return;
        }
        CompleteMolecule completeMolecule = molecule.getMatchingCompleteMolecule();
        final Property<Double> property = new Property<Double>(0.0);
        if (completeMolecule != null) {
            this.addChild(new HTMLNode(completeMolecule.getDisplayName()){
                {
                    super(string);
                    this.setFont(new PhetFont(14, true));
                    property.set((Double)property.get() + this.getFullBounds().getWidth() + 10.0);
                }
            });
            this.addChild(new ShowMolecule3DButtonNode(this.dialog, completeMolecule){
                {
                    super(jmolDialogProperty, completeMolecule);
                    this.setOffset((Double)property.get(), 0.0);
                    property.set((Double)property.get() + this.getFullBounds().getWidth() + 5.0);
                }
            });
        }
        this.addChild(new PNode(){
            {
                this.addChild(new PImage(BuildAMoleculeResources.getImage("split-blue.png")));
                this.addInputEventListener(new CursorHandler(){

                    public void mouseClicked(PInputEvent pInputEvent) {
                        kit.breakMolecule(molecule);
                    }
                });
                this.setOffset((Double)property.get(), 0.0);
            }
        });
        for (final Atom2D atom2D : molecule.getAtoms()) {
            atom2D.addPositionListener(new SimpleObserver(){
                {
                    MoleculeMetadataNode.this.observerMap.put(atom2D, this);
                }

                public void update() {
                    MoleculeMetadataNode.this.updatePosition();
                }
            });
        }
        this.updatePosition();
        kit.visible.addObserver(new SimpleObserver(){

            public void update() {
                if (!kit.visible.get().booleanValue()) {
                    MoleculeMetadataNode.this.dialog.hideDialogIfShown();
                }
            }
        });
    }

    public void destruct() {
        for (Atom2D atom2D : this.observerMap.keySet()) {
            atom2D.removePositionListener(this.observerMap.get(atom2D));
        }
        this.dialog.hideDialogIfShown();
    }

    public void updatePosition() {
        PBounds pBounds = this.molecule.getPositionBounds();
        Rectangle2D rectangle2D = BuildAMoleculeConstants.MODEL_VIEW_TRANSFORM.modelToView(pBounds).getBounds2D();
        this.setOffset(rectangle2D.getCenterX() - this.getFullBounds().getWidth() / 2.0, rectangle2D.getY() - this.getFullBounds().getHeight() - 5.0);
    }
}

