/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildamolecule.model;

import edu.colorado.phet.buildamolecule.model.Bond;
import edu.colorado.phet.buildamolecule.model.MoleculeStructure;
import edu.colorado.phet.chemistry.model.Atom;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StrippedMolecule<AtomT extends Atom> {
    public final MoleculeStructure<AtomT> stripped;
    private final int[] hydrogenCount;

    public StrippedMolecule(MoleculeStructure<AtomT> moleculeStructure) {
        ArrayList<Atom> arrayList = new ArrayList<Atom>();
        ArrayList<Bond> arrayList2 = new ArrayList<Bond>();
        for (Atom object : moleculeStructure.getAtoms()) {
            if (object.isHydrogen()) continue;
            arrayList.add(object);
        }
        this.hydrogenCount = new int[arrayList.size()];
        for (Bond bond : moleculeStructure.getBonds()) {
            boolean bl = ((Atom)bond.a).isHydrogen();
            boolean bl2 = ((Atom)bond.b).isHydrogen();
            if (bl && bl2) continue;
            if (bl || bl2) {
                int n = arrayList.indexOf(bl ? bond.b : bond.a);
                this.hydrogenCount[n] = this.hydrogenCount[n] + 1;
                continue;
            }
            arrayList2.add(bond);
        }
        this.stripped = new MoleculeStructure(arrayList.size(), arrayList2.size());
        for (Atom atom : arrayList) {
            this.stripped.addAtom(atom);
        }
        for (Bond bond : arrayList2) {
            this.stripped.addBond(bond);
        }
    }

    private int getIndex(AtomT AtomT) {
        int n = this.stripped.getAtoms().indexOf(AtomT);
        assert (n != -1);
        return n;
    }

    public int getHydrogenCount(AtomT AtomT) {
        return this.hydrogenCount[this.getIndex(AtomT)];
    }

    public <AtomU extends Atom> boolean isHydrogenSubmolecule(StrippedMolecule<AtomU> strippedMolecule) {
        if (this == strippedMolecule) {
            return true;
        }
        if (this.stripped.getAtoms().size() == 0) {
            return strippedMolecule.stripped.getAtoms().size() == 0;
        }
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        Atom atom = (Atom)this.stripped.getAtoms().iterator().next();
        for (Atom atom2 : strippedMolecule.stripped.getAtoms()) {
            if (!this.checkEquivalency(strippedMolecule, hashSet, hashSet2, atom, atom2, true)) continue;
            return true;
        }
        return false;
    }

    private <AtomU extends Atom> boolean checkEquivalency(StrippedMolecule<AtomU> strippedMolecule, Set<AtomT> set, Set<AtomU> set2, AtomT AtomT, AtomU AtomU, boolean bl) {
        if (!((Atom)AtomT).hasSameElement(AtomU)) {
            return false;
        }
        if (!bl ? this.getHydrogenCount(AtomT) != strippedMolecule.getHydrogenCount(AtomU) : this.getHydrogenCount(AtomT) < strippedMolecule.getHydrogenCount(AtomU)) {
            return false;
        }
        List<AtomT> list = this.stripped.getNeighborsNotInSet(AtomT, set);
        List<AtomT> list2 = strippedMolecule.stripped.getNeighborsNotInSet(AtomU, set2);
        if (list.size() != list2.size()) {
            return false;
        }
        if (list.isEmpty()) {
            return true;
        }
        int n = list.size();
        set.add(AtomT);
        set2.add(AtomU);
        boolean[][] blArray = new boolean[n][n];
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        for (int i = 0; i < n; ++i) {
            linkedList.add(i);
            for (int j = 0; j < n; ++j) {
                blArray[i][j] = this.checkEquivalency(strippedMolecule, set, set2, (Atom)list.get(i), (Atom)list2.get(j), bl);
            }
        }
        set.remove(AtomT);
        set2.remove(AtomU);
        return MoleculeStructure.checkEquivalencyMatrix(blArray, 0, linkedList);
    }
}

